/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.LogEntry;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.ProjDefs;
import projections.analysis.TimelineEvent;
import projections.analysis.TimelineMessage;
import projections.analysis.UserEvent;
import projections.analysis.ViewerEvent;
import projections.gui.Analysis;
import projections.misc.EntryNotFoundException;
import projections.misc.LogLoadException;
import projections.misc.ProgressDialog;

public class LogLoader
extends ProjDefs {
    private long BeginTime;
    private long EndTime;
    private String validPEString;
    private int basePE;
    private int upperPE;
    private boolean validPERange;
    private StringBuffer validPEStringBuffer;
    private long prevTime = 0L;
    private boolean deltaEncoded = false;

    public LogLoader() throws LogLoadException {
        ProgressDialog progressDialog = new ProgressDialog("Finding end time...");
        this.BeginTime = 0L;
        this.EndTime = Integer.MIN_VALUE;
        int n = Analysis.getNumProcessors();
        this.validPEStringBuffer = new StringBuffer();
        this.validPERange = false;
        this.basePE = -1;
        this.upperPE = -1;
        int n2 = 0;
        while (n2 < n) {
            progressDialog.progress(n2, n, n2 + " of " + n);
            try {
                File file = new File(Analysis.getLogName(n2));
                if (!file.exists()) {
                    System.out.println(Analysis.getLogName(n2) + " does not exist, ignoring.");
                    this.updatePEStringBuffer();
                    this.validPERange = false;
                } else {
                    String string;
                    StringTokenizer stringTokenizer;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    this.registerPE(n2);
                    long l = randomAccessFile.length() - 240L;
                    if (l < 0L) {
                        l = 0L;
                    }
                    randomAccessFile.seek(l);
                    while (randomAccessFile.readByte() != 10) {
                    }
                    while (Integer.parseInt((stringTokenizer = new StringTokenizer(string = randomAccessFile.readLine())).nextToken()) != 7) {
                    }
                    long l2 = Long.parseLong(stringTokenizer.nextToken());
                    if (l2 > this.EndTime) {
                        this.EndTime = l2;
                    }
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Couldn't read log file " + Analysis.getLogName(n2));
            }
            ++n2;
        }
        this.updatePEStringBuffer();
        this.validPEString = this.validPEStringBuffer.toString();
        progressDialog.done();
        Analysis.setTotalTime(this.EndTime - this.BeginTime);
    }

    public Vector createtimeline(int n, long l, long l2, Vector vector, Vector vector2) throws LogLoadException {
        int n2 = 0;
        long l3 = Long.MIN_VALUE;
        boolean bl = true;
        AsciiIntegerReader asciiIntegerReader = null;
        LogEntry logEntry = null;
        TimelineEvent timelineEvent = null;
        Hashtable<Integer, UserEvent> hashtable = new Hashtable<Integer, UserEvent>();
        UserEvent userEvent = null;
        TimelineMessage timelineMessage = null;
        PackTime packTime = null;
        System.gc();
        try {
            asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(new FileReader(Analysis.getLogName(n))));
            String string = asciiIntegerReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.deltaEncoded = stringTokenizer.countTokens() > 1;
            this.prevTime = 0L;
            while (true) {
                logEntry = this.readlogentry(asciiIntegerReader);
                if (logEntry.Entry == -1) continue;
                if (logEntry.TransactionType == 2 && logEntry.Entry != -1) {
                    l3 = logEntry.Time - this.BeginTime;
                    n2 = logEntry.Entry;
                } else if (logEntry.TransactionType == 14) {
                    l3 = logEntry.Time - this.BeginTime;
                }
                if (logEntry.Time >= l) break;
            }
            if (l3 == Long.MIN_VALUE) {
                l3 = l;
            }
            if (logEntry.Time > l2) {
                switch (logEntry.TransactionType) {
                    case 2: {
                        System.out.println("finished empty timeline for " + n);
                        asciiIntegerReader.close();
                        return vector;
                    }
                }
                timelineEvent = new TimelineEvent(l - this.BeginTime, l2 - this.BeginTime, logEntry.Entry, logEntry.Pe);
                vector.addElement(timelineEvent);
                asciiIntegerReader.close();
                return vector;
            }
            do {
                if (logEntry.Entry != -1) {
                    switch (logEntry.TransactionType) {
                        case 2: {
                            timelineEvent = new TimelineEvent(logEntry.Time - this.BeginTime, logEntry.Time - this.BeginTime, logEntry.Entry, logEntry.Pe, logEntry.MsgLen, logEntry.recvTime, logEntry.id, logEntry.EventID);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 3: {
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = logEntry.Time - this.BeginTime;
                            }
                            timelineEvent = null;
                            break;
                        }
                        case 1: {
                            boolean bl2 = false;
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(logEntry.Time - this.BeginTime, logEntry.Time - this.BeginTime, n2, logEntry.Pe, logEntry.MsgLen);
                                vector.addElement(timelineEvent);
                                bl2 = true;
                            }
                            timelineMessage = new TimelineMessage(logEntry.Time - this.BeginTime, logEntry.Entry, logEntry.MsgLen, logEntry.EventID);
                            timelineEvent.addMessage(timelineMessage);
                            if (!bl2) break;
                            timelineEvent = null;
                            break;
                        }
                        case 13: {
                            UserEvent userEvent2 = new UserEvent(logEntry.Time - this.BeginTime, logEntry.MsgType, logEntry.EventID, 1);
                            vector2.addElement(userEvent2);
                            break;
                        }
                        case 100: {
                            Integer n3 = new Integer(logEntry.EventID);
                            userEvent = (UserEvent)hashtable.get(n3);
                            if (userEvent != null) {
                                if (userEvent.CharmEventID != logEntry.EventID || userEvent.UserEventID != logEntry.MsgType) {
                                    System.out.println("WARN: LogLoader.createtimeline() USER_EVENT_PAIR does not match same EventID");
                                }
                                userEvent.EndTime = logEntry.Time - this.BeginTime;
                                hashtable.remove(n3);
                                vector2.addElement(userEvent);
                                break;
                            }
                            userEvent = new UserEvent(logEntry.Time - this.BeginTime, logEntry.MsgType, logEntry.EventID, 2);
                            hashtable.put(n3, userEvent);
                            break;
                        }
                        case 16: {
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(logEntry.Time - this.BeginTime, logEntry.Time - this.BeginTime, -1, logEntry.Pe);
                                vector.addElement(timelineEvent);
                            }
                            packTime = new PackTime(logEntry.Time - this.BeginTime);
                            timelineEvent.addPack(packTime);
                            break;
                        }
                        case 17: {
                            if (packTime != null) {
                                packTime.EndTime = logEntry.Time - this.BeginTime;
                            }
                            packTime = null;
                            if (timelineEvent.EntryPoint != -1) break;
                            timelineEvent = null;
                            break;
                        }
                        case 14: {
                            timelineEvent = new TimelineEvent(logEntry.Time - this.BeginTime, Long.MAX_VALUE, -1, -1);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 15: {
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = logEntry.Time - this.BeginTime;
                            }
                            timelineEvent = null;
                        }
                    }
                }
                logEntry = this.readlogentry(asciiIntegerReader);
            } while (logEntry.Time - this.BeginTime <= l2);
            while (timelineEvent != null) {
                if (logEntry.TransactionType == 3) {
                    timelineEvent.EndTime = logEntry.Time - this.BeginTime;
                    timelineEvent = null;
                }
                logEntry = this.readlogentry(asciiIntegerReader);
            }
            asciiIntegerReader.close();
        }
        catch (EOFException eOFException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (IOException iOException) {
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        return vector;
    }

    private ViewerEvent entrytotext(LogEntry logEntry) {
        ViewerEvent viewerEvent = new ViewerEvent();
        viewerEvent.Time = logEntry.Time - this.BeginTime;
        viewerEvent.EventType = logEntry.TransactionType;
        switch (logEntry.TransactionType) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return viewerEvent;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (logEntry.Entry != -1 && logEntry.Entry != -1) {
                    String[][] stringArray = Analysis.getEntryNames();
                    viewerEvent.Dest = new String(stringArray[logEntry.Entry][1] + "::" + stringArray[logEntry.Entry][0]);
                    if (logEntry.TransactionType != 1) {
                        viewerEvent.SrcPe = logEntry.Pe;
                    }
                    return viewerEvent;
                }
                return null;
            }
        }
        return null;
    }

    LogEntry readlogentry(AsciiIntegerReader asciiIntegerReader) throws IOException {
        LogEntry logEntry = new LogEntry();
        logEntry.TransactionType = asciiIntegerReader.nextInt();
        switch (logEntry.TransactionType) {
            case 13: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 100: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 2: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Entry = asciiIntegerReader.nextInt();
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                logEntry.MsgLen = Analysis.getVersion() > 1.0 ? asciiIntegerReader.nextInt() : -1;
                if (Analysis.getVersion() >= 4.0) {
                    logEntry.recvTime = asciiIntegerReader.nextLong();
                    logEntry.id = new ObjectId(asciiIntegerReader.nextInt(), asciiIntegerReader.nextInt(), asciiIntegerReader.nextInt());
                }
                return logEntry;
            }
            case 1: 
            case 3: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Entry = asciiIntegerReader.nextInt();
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                logEntry.MsgLen = Analysis.getVersion() > 1.0 ? asciiIntegerReader.nextInt() : -1;
                if (Analysis.getVersion() >= 5.0 && logEntry.TransactionType == 1) {
                    logEntry.sendTime = asciiIntegerReader.nextLong();
                }
                return logEntry;
            }
            case 4: 
            case 5: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 10: 
            case 11: 
            case 12: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Time = asciiIntegerReader.nextLong();
                logEntry.Time = asciiIntegerReader.nextLong();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 8: 
            case 9: {
                if (this.deltaEncoded) {
                    this.prevTime += asciiIntegerReader.nextLong();
                    logEntry.Time = this.prevTime;
                } else {
                    logEntry.Time = asciiIntegerReader.nextLong();
                }
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 6: {
                logEntry.Time = asciiIntegerReader.nextLong();
                if (this.deltaEncoded) {
                    this.prevTime += logEntry.Time;
                }
                return logEntry;
            }
            case 7: {
                logEntry.Time = asciiIntegerReader.nextLong();
                return logEntry;
            }
        }
        System.out.println("ERROR: weird event type " + logEntry.TransactionType);
        asciiIntegerReader.nextLine();
        return logEntry;
    }

    public long searchtimeline(int n, int n2, int n3) throws LogLoadException, EntryNotFoundException {
        long l = 0L;
        LogEntry logEntry = null;
        AsciiIntegerReader asciiIntegerReader = null;
        System.out.println("looking through log for processor " + n);
        try {
            System.gc();
            asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(new FileReader(Analysis.getLogName(n))));
            String string = asciiIntegerReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.deltaEncoded = stringTokenizer.countTokens() > 1;
            this.prevTime = 0L;
            while (true) {
                logEntry = this.readlogentry(asciiIntegerReader);
                if (logEntry.Entry == -1) continue;
                if (logEntry.Entry == n2 && logEntry.TransactionType == 2) {
                    ++l;
                }
                if (l > (long)n3) break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        return logEntry.Time - this.BeginTime;
    }

    public Vector view(int n) throws LogLoadException {
        AsciiIntegerReader asciiIntegerReader = null;
        Vector<ViewerEvent> vector = null;
        try {
            vector = new Vector<ViewerEvent>();
            asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(new FileReader(Analysis.getLogName(n))));
            String string = asciiIntegerReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.deltaEncoded = stringTokenizer.countTokens() > 1;
            this.prevTime = 0L;
            while (true) {
                ViewerEvent viewerEvent;
                if ((viewerEvent = this.entrytotext(this.readlogentry(asciiIntegerReader))) == null) {
                    continue;
                }
                vector.addElement(viewerEvent);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.out.println("throwing....2");
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        return vector;
    }

    public String getValidProcessorString() {
        return this.validPEString;
    }

    private void registerPE(int n) {
        if (!this.validPERange) {
            this.basePE = n;
        }
        this.upperPE = n;
        this.validPERange = true;
    }

    private void updatePEStringBuffer() {
        if (!this.validPERange) {
            return;
        }
        if (this.validPEStringBuffer.length() > 0) {
            this.validPEStringBuffer.append(",");
        }
        if (this.upperPE > this.basePE) {
            this.validPEStringBuffer.append(String.valueOf(this.basePE));
            this.validPEStringBuffer.append("-");
            this.validPEStringBuffer.append(String.valueOf(this.upperPE));
        } else if (this.upperPE == this.basePE) {
            this.validPEStringBuffer.append(String.valueOf(this.basePE));
        }
    }
}

