/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.ProjDefs;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.misc.ProgressDialog;

public class LogReader
extends ProjDefs {
    public static final int SYS_Q = 0;
    public static final int SYS_CPU = 1;
    public static final int SYS_IDLE = 2;
    public static final int IDLE_ENTRY = -1;
    public static final int CREATE = 0;
    public static final int PROCESS = 1;
    public static final int TIME = 2;
    private int[][][] sysUsgData;
    private int[][][][] userEntries;
    private int[][][][] categorized;
    private long progStartTime;
    private int numProcessors;
    private int numUserEntries;
    private long startTime;
    private int currentEntry;
    private int currentMtype;
    private int interval;
    private int curPe;
    private int numIntervals;
    private long intervalSize;
    private int intervalStart;
    private int intervalEnd;
    private int processing;
    private boolean byEntryPoint;
    private long prevTime = 0L;
    private boolean deltaEncoded = false;

    public long getIntervalSize() {
        return this.intervalSize;
    }

    private final void addToInterval(int n, int n2, boolean bl) {
        if (this.processing <= 0) {
            return;
        }
        if (n2 < this.intervalStart || n2 > this.intervalEnd) {
            return;
        }
        if (this.currentEntry == -1) {
            int[] nArray = this.sysUsgData[2][this.curPe];
            int n3 = n2 - this.intervalStart;
            nArray[n3] = nArray[n3] + (bl ? 100 : n);
        } else {
            int[] nArray = this.sysUsgData[1][this.curPe];
            int n4 = n2 - this.intervalStart;
            nArray[n4] = nArray[n4] + (bl ? 100 : n);
            if (this.byEntryPoint) {
                int[] nArray2 = this.userEntries[this.currentEntry][2][this.curPe];
                int n5 = n2 - this.intervalStart;
                nArray2[n5] = nArray2[n5] + n;
                int n6 = this.mtypeToCategoryIdx(this.currentMtype);
                if (n6 != -1) {
                    int[] nArray3 = this.categorized[n6][2][this.curPe];
                    int n7 = n2 - this.intervalStart;
                    nArray3[n7] = nArray3[n7] + n;
                }
            }
        }
        this.startTime += (long)n;
    }

    private final void count(int n, int n2, int n3) {
        if (!this.byEntryPoint) {
            return;
        }
        if (this.userEntries[n2][n3][this.curPe] == null) {
            this.userEntries[n2][n3][this.curPe] = new int[this.numIntervals + 1];
        }
        if (n3 == 1 && this.userEntries[n2][2][this.curPe] == null) {
            this.userEntries[n2][2][this.curPe] = new int[this.numIntervals + 1];
        }
        int[] nArray = this.userEntries[n2][n3][this.curPe];
        int n4 = this.interval - this.intervalStart;
        nArray[n4] = nArray[n4] + 1;
        int n5 = this.mtypeToCategoryIdx(n);
        if (n5 != -1) {
            if (this.categorized[n5][n3][this.curPe] == null) {
                this.categorized[n5][n3][this.curPe] = new int[this.numIntervals + 1];
                if (n3 == 1) {
                    this.categorized[n5][2][this.curPe] = new int[this.numIntervals + 1];
                }
            }
            int[] nArray2 = this.categorized[n5][n3][this.curPe];
            int n6 = this.interval - this.intervalStart;
            nArray2[n6] = nArray2[n6] + 1;
        }
    }

    private void fillToInterval(int n) {
        if (this.interval >= n) {
            return;
        }
        int n2 = (int)((long)(this.interval + 1) * this.intervalSize - this.startTime);
        this.addToInterval(n2, this.interval, false);
        this.rescale(this.interval);
        int n3 = this.interval + 1;
        while (n3 < n) {
            this.addToInterval((int)this.intervalSize, n3, true);
            ++n3;
        }
        this.interval = n;
    }

    public int[][][][] getSystemMsgs() {
        return this.categorized;
    }

    public int[][][] getSystemUsageData() {
        return this.sysUsgData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntries;
    }

    private void intervalCalc(int n, int n2, int n3, long l) throws IOException {
        this.fillToInterval((int)(l / this.intervalSize));
        switch (n) {
            case 4: {
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPe];
                int n4 = this.interval - this.intervalStart;
                nArray[n4] = nArray[n4] + 1;
                break;
            }
            case 1: {
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPe];
                int n5 = this.interval - this.intervalStart;
                nArray[n5] = nArray[n5] + 1;
                this.count(n2, n3, 0);
                break;
            }
            case 2: {
                ++this.processing;
                this.startTime = l;
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPe];
                int n6 = this.interval - this.intervalStart;
                nArray[n6] = nArray[n6] - 1;
                this.currentMtype = n2;
                this.currentEntry = n3;
                this.count(this.currentMtype, this.currentEntry, 1);
                break;
            }
            case 3: {
                if (this.interval >= this.intervalStart && this.interval <= this.intervalEnd) {
                    this.addToInterval((int)(l - this.startTime), this.interval, false);
                }
                --this.processing;
                break;
            }
            case 14: {
                ++this.processing;
                this.startTime = l;
                this.currentEntry = -1;
                break;
            }
            case 15: {
                if (this.interval >= this.intervalStart && this.interval <= this.intervalEnd) {
                    this.addToInterval((int)(l - this.startTime), this.interval, false);
                }
                --this.processing;
                break;
            }
            default: {
                System.out.println("Unhandled type " + n + " in logreader!");
            }
        }
    }

    private final int mtypeToCategoryIdx(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 14: 
            case 15: {
                return 4;
            }
        }
        return -1;
    }

    public void read(long l, int n, int n2, boolean bl, OrderedIntList orderedIntList) {
        int n3;
        this.numProcessors = Analysis.getNumProcessors();
        this.numUserEntries = Analysis.getNumUserEntries();
        this.intervalSize = l;
        this.intervalStart = n;
        this.intervalEnd = n2;
        this.numIntervals = this.intervalEnd - this.intervalStart + 1;
        this.byEntryPoint = bl;
        if (orderedIntList == null) {
            orderedIntList = new OrderedIntList();
            n3 = 0;
            while (n3 < this.numProcessors) {
                orderedIntList.insert(n3);
                ++n3;
            }
        }
        ProgressDialog progressDialog = new ProgressDialog("Reading log files...");
        double d = 0.5;
        double d2 = d + (double)this.numProcessors;
        progressDialog.progress(0.0, "allocating");
        this.sysUsgData = new int[3][this.numProcessors][];
        if (this.byEntryPoint) {
            this.userEntries = new int[this.numUserEntries][3][this.numProcessors][this.numIntervals];
            this.categorized = new int[5][3][this.numProcessors][];
        }
        int n4 = 0;
        orderedIntList.reset();
        int n5 = orderedIntList.size();
        this.curPe = orderedIntList.nextElement();
        while (this.curPe != -1) {
            try {
                this.sysUsgData[0][this.curPe] = new int[this.numIntervals + 1];
                this.sysUsgData[1][this.curPe] = new int[this.numIntervals + 1];
                this.sysUsgData[2][this.curPe] = new int[this.numIntervals + 1];
                ++n4;
                this.processing = 0;
                this.interval = 0;
                this.currentEntry = -1;
                this.startTime = 0L;
                FileReader fileReader = new FileReader(Analysis.getLogName(this.curPe));
                AsciiIntegerReader asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(fileReader));
                String string = asciiIntegerReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                this.deltaEncoded = stringTokenizer.countTokens() > 1;
                asciiIntegerReader.nextInt();
                this.progStartTime = 0L;
                if (this.deltaEncoded) {
                    this.prevTime = asciiIntegerReader.nextLong();
                }
                int n6 = 2;
                if (!progressDialog.progress(d + (double)this.curPe, d2, "Loading " + n4 + " of " + n5)) break;
                try {
                    block17: while (true) {
                        asciiIntegerReader.nextLine();
                        int n7 = asciiIntegerReader.nextInt();
                        ++n6;
                        switch (n7) {
                            case 14: 
                            case 15: {
                                long l2;
                                if (this.deltaEncoded) {
                                    this.prevTime += asciiIntegerReader.nextLong();
                                    l2 = this.prevTime;
                                } else {
                                    l2 = asciiIntegerReader.nextLong();
                                }
                                n3 = asciiIntegerReader.nextInt();
                                this.intervalCalc(n7, 0, 0, l2 - this.progStartTime);
                                continue block17;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                long l2;
                                int n8 = asciiIntegerReader.nextInt();
                                int n9 = asciiIntegerReader.nextInt();
                                if (this.deltaEncoded) {
                                    this.prevTime += asciiIntegerReader.nextLong();
                                    l2 = this.prevTime;
                                } else {
                                    l2 = asciiIntegerReader.nextLong();
                                }
                                int n10 = asciiIntegerReader.nextInt();
                                n3 = asciiIntegerReader.nextInt();
                                int n11 = Analysis.getVersion() > 1.0 ? asciiIntegerReader.nextInt() : -1;
                                this.intervalCalc(n7, n8, n9, l2 - this.progStartTime);
                                continue block17;
                            }
                            case 4: {
                                long l2;
                                int n8 = asciiIntegerReader.nextInt();
                                if (this.deltaEncoded) {
                                    this.prevTime += asciiIntegerReader.nextLong();
                                    l2 = this.prevTime;
                                } else {
                                    l2 = asciiIntegerReader.nextLong();
                                }
                                int n10 = asciiIntegerReader.nextInt();
                                n3 = asciiIntegerReader.nextInt();
                                this.intervalCalc(n7, n8, 0, l2 - this.progStartTime);
                                continue block17;
                            }
                            case 7: {
                                long l2 = asciiIntegerReader.nextLong();
                                this.fillToInterval(this.numIntervals);
                                continue block17;
                            }
                            case 13: 
                            case 100: {
                                if (!this.deltaEncoded) continue block17;
                                asciiIntegerReader.nextInt();
                                this.prevTime += asciiIntegerReader.nextLong();
                                continue block17;
                            }
                            case 5: {
                                if (!this.deltaEncoded) continue block17;
                                asciiIntegerReader.nextInt();
                                this.prevTime += asciiIntegerReader.nextLong();
                                continue block17;
                            }
                            case 8: 
                            case 9: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                if (!this.deltaEncoded) continue block17;
                                this.prevTime += asciiIntegerReader.nextLong();
                                continue block17;
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                continue block17;
                            }
                        }
                        System.out.println("Warning: Unknown Event! May mess delta encoding!");
                    }
                }
                catch (EOFException eOFException) {
                    asciiIntegerReader.close();
                }
                catch (IOException iOException) {
                    asciiIntegerReader.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Exception reading log file #" + this.curPe);
                return;
            }
            this.curPe = orderedIntList.nextElement();
        }
        progressDialog.done();
    }

    private void rescale(int n) {
        if (n < this.intervalStart || n > this.intervalEnd) {
            return;
        }
        this.sysUsgData[1][this.curPe][n - this.intervalStart] = (int)((long)(this.sysUsgData[1][this.curPe][n - this.intervalStart] * 100) / this.intervalSize);
        this.sysUsgData[2][this.curPe][n - this.intervalStart] = (int)((long)(this.sysUsgData[2][this.curPe][n - this.intervalStart] * 100) / this.intervalSize);
    }
}

