/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Color;
import java.util.Vector;
import projections.gui.Analysis;
import projections.gui.graph.MultiRunDataSource;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.MultiRunYAxis;
import projections.misc.MultiRunData;
import projections.misc.ProjectionsStatistics;

public class MultiRunDataAnalyzer {
    private MultiRunData data;
    private double[][][] dataTable;
    private double[][][] extraTable;
    public static final int NUM_EXTR_ENTRIES = 1;
    public static final int EXTR_OVERHEAD = 0;
    private static final String[] extraNames = new String[]{"Idle Time and System Overhead"};
    private double[] runTimeSum;
    private double[] epTimeMean;
    private double[] epTimeVariance;
    private double[] extraTimeMean;
    private double[] extraTimeVariance;
    private Vector[][] categories;
    private String[] catNames;
    private static final int NUM_CATEGORIES = 4;
    private static final int CAT_EP_NO_CHANGE = 0;
    private static final int CAT_EP_INSIGNIFICANT = 1;
    private static final int CAT_EP_CHANGE = 2;
    private static final int CAT_OVERHEAD_IDLE = 3;
    private static final Color[] catColors = new Color[]{Color.green, Color.yellow, Color.red, Color.white};
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;
    private ProjectionsStatistics timeStats = new ProjectionsStatistics();
    private ProjectionsStatistics numCallsStats = new ProjectionsStatistics();

    public MultiRunDataAnalyzer(MultiRunData multiRunData) {
        this.data = multiRunData;
        this.numEPs = multiRunData.getNumEPs();
        this.numRuns = multiRunData.getNumRuns();
        this.epNames = multiRunData.getEPNames();
        this.runNames = multiRunData.getRunNames();
        this.dataTable = multiRunData.getData();
        this.computeDerivedInformation();
        this.computeExtraInformation();
        this.computeExtraDerivedInformation();
        this.constructCategories();
    }

    private void computeDerivedInformation() {
        this.runTimeSum = new double[this.numRuns];
        int n = 0;
        while (n < this.numRuns) {
            this.timeStats.reset();
            this.timeStats.accumulate(this.dataTable[0][n]);
            this.runTimeSum[n] = this.timeStats.getSum();
            ++n;
        }
        this.epTimeMean = new double[this.numEPs];
        this.epTimeVariance = new double[this.numEPs];
        int n2 = 0;
        while (n2 < this.numEPs) {
            this.timeStats.reset();
            int n3 = 0;
            while (n3 < this.numRuns) {
                this.timeStats.accumulate(this.dataTable[0][n3][n2]);
                ++n3;
            }
            this.epTimeMean[n2] = this.timeStats.getMean();
            this.epTimeVariance[n2] = this.timeStats.getVariance(this.epTimeMean[n2]);
            ++n2;
        }
    }

    public void computeExtraInformation() {
        this.extraTable = new double[4][this.numRuns][1];
        double[] dArray = this.data.getRunWallTimes();
        int n = 0;
        while (n < this.numRuns) {
            this.extraTable[0][n][0] = dArray[n] - this.runTimeSum[n];
            ++n;
        }
    }

    public void computeExtraDerivedInformation() {
    }

    private void constructCategories() {
        this.categories = new Vector[4][4];
        this.catNames = new String[4];
        int n = 0;
        while (n < 4) {
            this.catNames[n] = this.getCategoryName(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 4) {
                this.categories[n2][n3] = new Vector();
                ++n3;
            }
            this.categorize(n2);
            ++n2;
        }
    }

    private String getCategoryName(int n) {
        switch (n) {
            case 0: {
                return "EPs with little change";
            }
            case 1: {
                return "Insignificant EPs";
            }
            case 2: {
                return "EPs with change";
            }
            case 3: {
                return "Idle time and System Overhead";
            }
        }
        return "unknown category";
    }

    public void categorize(int n) {
        int n2;
        int n3 = 0;
        while (n3 < this.numEPs) {
            n2 = 0;
            int n4 = 0;
            while (n4 < this.numRuns) {
                if (this.dataTable[n][n4][n3] < 0.01 * this.runTimeSum[n4]) {
                    ++n2;
                }
                ++n4;
            }
            if (n2 > this.numRuns / 2) {
                this.categories[n][1].add(new Integer(n3));
            } else {
                int n5 = 0;
                int n6 = 0;
                double d = 0.0;
                double d2 = this.dataTable[n][0][n3];
                int n7 = 1;
                while (n7 < this.numRuns) {
                    d += Math.abs(this.dataTable[n][n7][n3] - d2);
                    if (this.dataTable[n][n7][n3] > d2) {
                        ++n5;
                    } else if (this.dataTable[n][n7][n3] < d2) {
                        ++n6;
                    }
                    ++n7;
                }
                d /= (double)(this.numRuns - 1);
                if (((double)n5 > (double)this.numRuns * 0.75 || (double)n6 > (double)this.numRuns * 0.75) && d > 0.05 * this.epTimeMean[n3]) {
                    this.categories[n][2].add(new Integer(n3));
                } else {
                    this.categories[n][0].add(new Integer(n3));
                }
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 1) {
            switch (n2) {
                case 0: {
                    this.categories[n][3].add(new Integer(this.numEPs + 0));
                }
            }
            ++n2;
        }
    }

    public int getNumRows(int n, int n2) {
        return this.categories[n][n2].size();
    }

    public int getNumColumns(int n, int n2) {
        return this.numRuns + 1;
    }

    public String getColumnName(int n, int n2, int n3) {
        if (n3 == 0) {
            return "Entry Point Name";
        }
        return this.runNames[n3 - 1];
    }

    public Object getTableValueAt(int n, int n2, int n3, int n4) {
        int n5 = (Integer)this.categories[n][n2].elementAt(n3);
        if (n4 == 0) {
            if (n5 >= this.numEPs) {
                return extraNames[this.numEPs - n5];
            }
            return this.epNames[n5];
        }
        if (n5 >= this.numEPs) {
            return new Double(this.extraTable[n][n4 - 1][this.numEPs - n5]);
        }
        return new Double(this.dataTable[n][n4 - 1][n5]);
    }

    public String[] getCategoryNames() {
        return this.catNames;
    }

    public MultiRunDataSource getDataSource(int n) {
        int n2 = this.numEPs - this.categories[n][1].size() + 1 + 1;
        double[][] dArray = new double[this.numRuns][n2];
        String string = "";
        switch (n) {
            case 0: {
                string = "Time taken";
                break;
            }
            case 1: {
                string = "Number of times called";
                break;
            }
            case 2: {
                string = "Messages sent per processor";
                break;
            }
            case 3: {
                string = "Amount of data sent";
            }
        }
        this.computeOutputArray(dArray, n, 0);
        Color[] colorArray = this.computeColorMap(n2, n, 0);
        return new MultiRunDataSource(dArray, colorArray, string);
    }

    public MultiRunXAxis getMRXAxisData() {
        return new MultiRunXAxis(this.runNames);
    }

    public MultiRunYAxis getMRYAxisData(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "Time summed across processors (us)";
                break;
            }
            case 1: {
                string = "Number of times entry point was called";
                break;
            }
            case 2: {
                string = "Number of messages sent per processor";
                break;
            }
            case 3: {
                string = "Total amount of data sent (bytes)";
            }
        }
        ProjectionsStatistics projectionsStatistics = new ProjectionsStatistics();
        int n2 = 0;
        while (n2 < this.numRuns) {
            projectionsStatistics.accumulate(this.dataTable[n][n2]);
            ++n2;
        }
        return new MultiRunYAxis(1, string, projectionsStatistics.getMax());
    }

    private void computeOutputArray(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = this.categories[n][0].size();
        int n11 = 0;
        while (n11 < n10) {
            n8 = (Integer)this.categories[n][0].elementAt(n11);
            n7 = 0;
            while (n7 < this.numRuns) {
                dArray[n7][n9] = this.dataTable[n][n7][n8];
                ++n7;
            }
            ++n9;
            ++n11;
        }
        n8 = this.categories[n][1].size();
        n7 = 0;
        while (n7 < this.numRuns) {
            n6 = 0;
            while (n6 < n8) {
                n5 = (Integer)this.categories[n][1].elementAt(n6);
                double[] dArray2 = dArray[n7];
                int n12 = n9;
                dArray2[n12] = dArray2[n12] + this.dataTable[n][n7][n5];
                ++n6;
            }
            ++n7;
        }
        ++n9;
        n6 = this.categories[n][2].size();
        n5 = 0;
        while (n5 < n6) {
            n4 = (Integer)this.categories[n][2].elementAt(n5);
            n3 = 0;
            while (n3 < this.numRuns) {
                dArray[n3][n9] = this.dataTable[n][n3][n4];
                ++n3;
            }
            ++n9;
            ++n5;
        }
        n4 = this.categories[n][3].size();
        n3 = 0;
        while (n3 < n4) {
            int n13 = this.numEPs - (Integer)this.categories[n][3].elementAt(n3);
            int n14 = 0;
            while (n14 < this.numRuns) {
                dArray[n14][n9] = this.extraTable[n][n14][n13];
                ++n14;
            }
            ++n9;
            ++n3;
        }
    }

    private Color[] computeColorMap(int n, int n2, int n3) {
        Color[] colorArray = new Color[n];
        int n4 = this.categories[n2][0].size();
        int n5 = this.categories[n2][2].size();
        colorArray = Analysis.createColorMap(n);
        colorArray[n4] = Color.gray;
        int n6 = this.categories[n2][3].size();
        int n7 = n4 + 1 + n5;
        int n8 = 0;
        while (n8 < n6) {
            switch (n8) {
                case 0: {
                    colorArray[n7 + n8] = Color.white;
                }
            }
            ++n8;
        }
        return colorArray;
    }
}

