/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JPanel;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class CommWindow
extends GenericGraphWindow
implements ItemListener {
    private double[][] msgCount;
    private double[][] byteCount;
    private ArrayList histogram;
    private int[] histArray;
    private String[][] histText;
    private String[][] msgText;
    private String[][] byteText;
    private String[][] popupText;
    private String[][] EPNames;
    private JPanel mainPanel;
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private Checkbox sentMssgs;
    private Checkbox sentBytes;
    private Checkbox histogramCB;

    public CommWindow(MainWindow mainWindow) {
        this();
    }

    public CommWindow() {
        super("Projections Communications");
        this.setGraphSpecificData();
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        this.setLayout();
        this.showDialog();
        this.setPopupText(this.msgText);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (checkbox == this.histogramCB) {
                this.setDataSource("Histogram", this.histArray, (GenericGraphWindow)this);
                this.setPopupText(this.histText);
                this.setYAxis("Frequency", null);
                this.setXAxis("Byte Size", "bytes");
                super.refreshGraph();
            } else if (checkbox == this.sentMssgs) {
                this.setDataSource("Communications", this.msgCount, (GenericGraphWindow)this);
                this.setPopupText(this.msgText);
                this.setYAxis("Messages Sent", "");
                this.setXAxis("Processor", null);
                super.refreshGraph();
            } else if (checkbox == this.sentBytes) {
                this.setDataSource("Communications", this.byteCount, (GenericGraphWindow)this);
                this.setPopupText(this.byteText);
                this.setYAxis("Bytes Sent", "bytes");
                this.setXAxis("Processor", null);
                super.refreshGraph();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void setPopupText(String[][] stringArray) {
        this.popupText = stringArray;
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0 || this.popupText == null) {
            return null;
        }
        if (this.EPNames == null) {
            this.EPNames = Analysis.getEntryNames();
        }
        String[] stringArray = new String[2];
        if (this.popupText != this.histText) {
            stringArray[0] = "EPid: " + this.EPNames[n2][0];
            stringArray[1] = this.popupText[n][n2];
        } else {
            stringArray[0] = this.popupText[n][0];
            stringArray[1] = this.popupText[n][1];
        }
        return stringArray;
    }

    protected void setLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.graphPanel = this.getMainPanel();
        this.checkBoxPanel = new JPanel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.histogramCB = new Checkbox("Histogram", checkboxGroup, false);
        this.sentMssgs = new Checkbox("Messages Sent (mssgs)", checkboxGroup, true);
        this.sentBytes = new Checkbox("Messages Sent (bytes)", checkboxGroup, false);
        this.histogramCB.addItemListener(this);
        this.sentMssgs.addItemListener(this);
        this.sentBytes.addItemListener(this);
        Util.gblAdd(this.checkBoxPanel, this.histogramCB, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentMssgs, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.graphPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gridBagConstraints, 0, 2, 1, 1, 0, 0);
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Processor", "");
        this.setYAxis("Messages Sent", "");
    }

    protected void showDialog() {
        int n;
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        }
        if ((n = this.dialog.showDialog()) == 0) {
            this.dialog.setAllData();
        }
        this.msgCount = new double[this.validPEs.size()][];
        this.byteCount = new double[this.validPEs.size()][];
        this.msgText = new String[this.validPEs.size()][];
        this.byteText = new String[this.validPEs.size()][];
        this.getData();
        this.refreshGraph();
    }

    public void refreshGraph() {
        this.setDataSource("Communcations", this.msgCount, (GenericGraphWindow)this);
        super.refreshGraph();
    }

    protected void getData() {
        int n;
        LogEntryData logEntryData = new LogEntryData();
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        int n2 = orderedIntList.size();
        int n3 = Analysis.getNumUserEntries();
        this.histogram = new ArrayList();
        while (orderedIntList.hasMoreElements()) {
            n = orderedIntList.nextElement();
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n), Analysis.getVersion());
            try {
                this.msgCount[n] = new double[n3 + 1];
                this.byteCount[n] = new double[n3 + 1];
                this.msgText[n] = new String[n3 + 1];
                this.byteText[n] = new String[n3 + 1];
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (true) {
                    genericLogReader.nextEventOfType(2, logEntryData);
                    int n4 = logEntryData.entry;
                    while (true) {
                        genericLogReader.nextEvent(logEntryData);
                        if (logEntryData.type == 1) {
                            double[] dArray = this.msgCount[n];
                            int n5 = n4;
                            dArray[n5] = dArray[n5] + 1.0;
                            this.msgText[n][n4] = "Count = " + this.msgCount[n][n4];
                            double[] dArray2 = this.byteCount[n];
                            int n6 = n4;
                            dArray2[n6] = dArray2[n6] + (double)logEntryData.msglen;
                            this.byteText[n][n4] = "Bytes: " + this.byteCount[n][n4];
                            this.histogram.add(new MyArray(logEntryData.msglen));
                            continue;
                        }
                        if (logEntryData.type == 3) break;
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
                exception.printStackTrace();
            }
        }
        n = ((MyArray)this.histogram.get((int)0)).index;
        int n7 = ((MyArray)this.histogram.get((int)0)).index;
        int n8 = 1;
        while (n8 < this.histogram.size()) {
            if (((MyArray)this.histogram.get((int)n8)).index < n7) {
                n7 = ((MyArray)this.histogram.get((int)n8)).index;
            }
            if (((MyArray)this.histogram.get((int)n8)).index > n) {
                n = ((MyArray)this.histogram.get((int)n8)).index;
            }
            ++n8;
        }
        this.histArray = new int[n + 1];
        this.histText = new String[n + 1][];
        int n9 = 0;
        while (n9 < Array.getLength(this.histArray)) {
            this.histArray[n9] = 0;
            this.histText[n9] = new String[2];
            this.histText[n9][0] = "";
            this.histText[n9][1] = "";
            ++n9;
        }
        int n10 = 0;
        while (n10 < this.histogram.size()) {
            int n11;
            int n12 = n11 = ((MyArray)this.histogram.get((int)n10)).index;
            this.histArray[n12] = this.histArray[n12] + 1;
            this.histText[n11][0] = n11 + " bytes";
            this.histText[n11][1] = "Count = " + this.histArray[n11];
            ++n10;
        }
    }

    private class MyArray {
        public int index;

        public MyArray(int n) {
            this.index = n;
        }
    }
}

