/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import projections.analysis.EPDataGenerator;
import projections.analysis.EPNamdDefs;
import projections.gui.Analysis;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;

public class EPAnalysis
extends ProjectionsWindow
implements EPNamdDefs {
    private OrderedIntList validPEs;
    private long startTime;
    private long endTime;
    private long[][] data;
    private String[] userEventNames;
    private String[][] entryNames;
    private double[][] categoryData;
    private MainWindow mainWindow;

    public EPAnalysis(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.showDialog();
    }

    void showDialog() {
        int n;
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "Select Range");
        }
        if ((n = this.dialog.showDialog()) == 1) {
            this.dialog = null;
            this.closeWindow();
            return;
        }
        this.generateEPData();
        this.closeWindow();
    }

    public void setProcessorRange(OrderedIntList orderedIntList) {
        this.validPEs = orderedIntList;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    private void closeWindow() {
        this.mainWindow.CloseEPAnalysis();
    }

    private void generateEPData() {
        this.data = new long[1][Analysis.getNumUserEntries() + Analysis.getNumUserDefinedEvents() + 3];
        this.userEventNames = Analysis.getUserEventNames();
        this.entryNames = Analysis.getEntryNames();
        this.categoryData = new double[1][7];
        EPDataGenerator ePDataGenerator = new EPDataGenerator(this.data, this.validPEs, this.startTime, this.endTime);
        int n = 0;
        while (n < Analysis.getNumUserEntries()) {
            if (n >= 71 && n <= 74) {
                double[] dArray = this.categoryData[0];
                dArray[0] = dArray[0] + (double)this.data[0][n] / 1000000.0;
            } else if (n == 0) {
                double[] dArray = this.categoryData[0];
                dArray[1] = dArray[1] + (double)this.data[0][n] / 1000000.0;
            } else if (n == 79) {
                double[] dArray = this.categoryData[0];
                dArray[3] = dArray[3] + (double)this.data[0][n] / 1000000.0;
            } else if (n == 84 || n >= 89 && n <= 91) {
                double[] dArray = this.categoryData[0];
                dArray[4] = dArray[4] + (double)this.data[0][n] / 1000000.0;
            } else if (n == 138 || n == 139 || n >= 141 && n <= 149) {
                double[] dArray = this.categoryData[0];
                dArray[2] = dArray[2] + (double)this.data[0][n] / 1000000.0;
            } else {
                double[] dArray = this.categoryData[0];
                dArray[5] = dArray[5] + (double)this.data[0][n] / 1000000.0;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < Analysis.getNumUserDefinedEvents()) {
            double[] dArray = this.categoryData[0];
            dArray[3] = dArray[3] + (double)this.data[0][Analysis.getNumUserEntries() + n2] / 1000000.0;
            ++n2;
        }
        double[] dArray = this.categoryData[0];
        dArray[6] = dArray[6] + (double)this.data[0][Analysis.getNumUserEntries() + Analysis.getNumUserDefinedEvents()] / 1000000.0;
        double[] dArray2 = this.categoryData[0];
        dArray2[3] = dArray2[3] + (double)this.data[0][Analysis.getNumUserEntries() + Analysis.getNumUserDefinedEvents() + 1] / 1000000.0;
        double[] dArray3 = this.categoryData[0];
        dArray3[3] = dArray3[3] + (double)this.data[0][Analysis.getNumUserEntries() + Analysis.getNumUserDefinedEvents() + 2] / 1000000.0;
        System.out.print("Num PEs\t");
        System.out.print("Compute Time\t");
        System.out.print("Integration Time\t");
        System.out.print("PME Work\t");
        System.out.print("Communication Time\t");
        System.out.print("Message Processing Time\t");
        System.out.print("Other\t");
        System.out.println("Idle Time");
        System.out.print(Analysis.getNumProcessors() + "\t");
        int n3 = 0;
        while (n3 < 6) {
            System.out.print(this.categoryData[0][n3] + "\t");
            ++n3;
        }
        System.out.println(this.categoryData[0][6]);
    }
}

