/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.EntrySelectionDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;
import projections.misc.LogEntryData;

public class EPCharWindow
extends ProjectionsWindow
implements ActionListener {
    private GraphPanel graphPanel;
    private Graph graphCanvas;
    private long intervalSize;
    private EntrySelectionDialog entryDialog;
    private boolean[][] stateArray;
    private Color[][] colorArray;
    private String[] entryNames;
    private double[][] dataSource;
    private boolean startUp = true;
    private final int NO_OF_PARAMETERS = 1;
    private final int EXECUTION_TIME = 0;

    public EPCharWindow(MainWindow mainWindow) {
        this.setTitle("Projections EntryPoint Characteristics Graph");
        this.createLayout();
        this.createMenus();
        this.pack();
        ((Component)this).setVisible(true);
        this.showDialog();
        this.refreshGraph();
    }

    void showDialog() {
        int n;
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "Select Range");
        }
        if ((n = this.dialog.showDialog()) == 0) {
            this.refreshGraph();
        }
    }

    public void setIntervalSize(long l) {
        this.intervalSize = l;
    }

    void showEntryDialog() {
        int n = Analysis.getNumUserEntries();
        String[] stringArray = new String[]{"Entry Points"};
        boolean[][] blArray = new boolean[1][n];
        int n2 = 0;
        while (n2 < n) {
            blArray[0][n2] = true;
            ++n2;
        }
        if (this.entryDialog == null) {
            this.entryDialog = new EntrySelectionDialog(this, stringArray, this.stateArray, this.colorArray, blArray, this.entryNames);
        }
        this.entryDialog.showDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText().equals("Set Range")) {
                this.showDialog();
            } else if (jMenuItem.getText().equals("Select Entry Points")) {
                this.showEntryDialog();
            } else if (jMenuItem.getText().equals("Show Pie Chart")) {
                this.refreshGraph();
            } else if (jMenuItem.getText().equals("Close")) {
                this.close();
            }
        }
    }

    private void createLayout() {
        Container container = this.getContentPane();
        this.graphCanvas = new Graph();
        this.graphPanel = new GraphPanel(this.graphCanvas);
        container.add((Component)this.graphPanel, "Center");
    }

    protected void createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Pie Chart");
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Set Range", "Select Entry Points", "Close"}, null, this));
        jMenuBar.add(Util.makeJMenu("View", new Object[]{jCheckBoxMenuItem}, null, this));
    }

    private void refreshGraph() {
        this.getNewData();
        String string = "EntryPoints vs Execution Time";
        DataSource2D dataSource2D = new DataSource2D(string, this.dataSource);
        XAxisFixed xAxisFixed = new XAxisFixed("Entry Points", "");
        YAxisAuto yAxisAuto = new YAxisAuto("Time", "", dataSource2D);
        this.graphCanvas.setData(dataSource2D, xAxisFixed, yAxisAuto);
        this.graphCanvas.repaint();
    }

    private void getNewData() {
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        LogEntryData logEntryData = new LogEntryData();
        LogEntryData logEntryData2 = new LogEntryData();
        int n = Analysis.getNumUserEntries();
        this.dataSource = new double[n][1];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 1) {
                this.dataSource[n2][n3] = 0.0;
                ++n3;
            }
            ++n2;
        }
        System.out.println("no. of bins: " + n);
        block9: while (orderedIntList.hasMoreElements()) {
            int n4 = orderedIntList.nextElement();
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n4), Analysis.getVersion());
            try {
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (true) {
                    genericLogReader.nextEvent(logEntryData);
                    if (logEntryData.time > this.endTime) continue block9;
                    switch (logEntryData.type) {
                        case 2: {
                            logEntryData2 = logEntryData.copyOf();
                            break;
                        }
                        case 3: {
                            long l = logEntryData.time - logEntryData2.time;
                            int n5 = logEntryData.entry;
                            double[] dArray = this.dataSource[n5];
                            dArray[0] = dArray[0] + (double)l;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.out.println("Exception at IntervalWindow::getData() " + iOException);
            }
        }
    }
}

