/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class FloatTextField
extends TextField
implements TextListener {
    private String lastValue;
    private int lastCaretPosition;

    public FloatTextField(float f, int n) {
        super("" + f, n);
        this.addTextListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!('0' <= c && c <= '9' || c == '.' || Character.isISOControl(c))) {
                    keyEvent.consume();
                } else {
                    FloatTextField.this.lastCaretPosition = FloatTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + f;
    }

    private void checkValue() {
        try {
            Float.valueOf(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException numberFormatException) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public float getValue() {
        this.checkValue();
        try {
            return Float.valueOf(this.getText().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return Float.valueOf(this.lastValue).floatValue();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.checkValue();
    }
}

