/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import projections.gui.ProjectionsWindow;
import projections.gui.Util;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;
import projections.gui.graph.YAxisFixed;

public abstract class GenericGraphWindow
extends ProjectionsWindow {
    static final Color BACKGROUND = Color.white;
    protected GraphPanel graphPanel;
    protected Graph graphCanvas;
    protected DataSource dataSource;
    protected XAxisFixed xAxis;
    protected YAxis yAxis;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu("File");

    protected abstract void setGraphSpecificData();

    public GenericGraphWindow(String string) {
        this.setTitle(string);
        ((Component)this).setBackground(BACKGROUND);
        this.menuBar.add(this.fileMenu);
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Set Range", "Close"}, null, this);
        this.setJMenuBar(this.menuBar);
    }

    public String[] getPopup(int n, int n2) {
        return null;
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        this.graphCanvas = new Graph();
        this.graphPanel = new GraphPanel(this.graphCanvas);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.graphPanel);
        return jPanel;
    }

    protected void setBarGraphType(int n) {
        if (this.graphCanvas != null) {
            this.graphCanvas.setBarGraphType(n);
        } else {
            System.err.println("Warning: The graph canvas has not yet been initialized! Ignoring request.");
        }
    }

    protected void setXAxis(String string, String string2) {
        this.xAxis = new XAxisFixed(string, string2);
    }

    protected void setXAxis(String string, String string2, double d, double d2) {
        this.xAxis = new XAxisFixed(string, string2);
        this.xAxis.setLimits(d, d2);
    }

    protected void setYAxis(String string, String string2) {
        this.yAxis = this.dataSource != null ? new YAxisAuto(string, string2, this.dataSource) : new YAxisFixed(string, string2, 0.0);
    }

    protected void setDataSource(String string, int[] nArray) {
        this.dataSource = new DataSource1D(string, nArray);
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, double[][] dArray) {
        this.dataSource = new DataSource2D(string, dArray);
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, int[] nArray, GenericGraphWindow genericGraphWindow) {
        this.dataSource = new DataSource1D(string, nArray, genericGraphWindow);
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, double[][] dArray, GenericGraphWindow genericGraphWindow) {
        this.dataSource = new DataSource2D(string, dArray, genericGraphWindow);
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void refreshGraph() {
        this.graphCanvas.setData(this.dataSource, this.xAxis, this.yAxis);
        this.graphCanvas.repaint();
    }
}

