/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import projections.gui.Analysis;
import projections.gui.GraphData;
import projections.gui.LWPanel;
import projections.gui.OrderedIntList;
import projections.gui.SelectField;
import projections.gui.Util;
import projections.misc.ErrorDialog;

public class GraphControlPanel
extends Panel
implements ActionListener,
ItemListener {
    private Button bPlus5;
    private Button bPlus1;
    private Button bMinus1;
    private Button bMinus5;
    private Button bSelectAll;
    private Button bApply;
    private Checkbox cbXInterval;
    private Checkbox cbXProcessor;
    private Checkbox cbYMsg;
    private Checkbox cbYTime;
    private GraphData data;
    private Label lIterate;
    private Label lSelect;
    private SelectField rangeField;
    private ErrorDialog errDlg;
    private OrderedIntList origProcList;

    public GraphControlPanel() {
        this.setBackground(Color.lightGray);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        this.cbXInterval = new Checkbox("Interval", true, checkboxGroup);
        this.cbXProcessor = new Checkbox("Processor", false, checkboxGroup);
        this.cbYMsg = new Checkbox("Msgs", true, checkboxGroup2);
        this.cbYTime = new Checkbox("Time", false, checkboxGroup2);
        this.bPlus5 = new Button(">>");
        this.bPlus1 = new Button(">");
        this.bMinus1 = new Button("<");
        this.bMinus5 = new Button("<<");
        this.bSelectAll = new Button("Select All");
        this.bApply = new Button("Apply");
        this.cbXInterval.addItemListener(this);
        this.cbXProcessor.addItemListener(this);
        this.cbYMsg.addItemListener(this);
        this.cbYTime.addItemListener(this);
        this.bPlus5.addActionListener(this);
        this.bPlus1.addActionListener(this);
        this.bMinus1.addActionListener(this);
        this.bMinus5.addActionListener(this);
        this.bSelectAll.addActionListener(this);
        this.bApply.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        LWPanel lWPanel = new LWPanel();
        LWPanel lWPanel2 = new LWPanel();
        LWPanel lWPanel3 = new LWPanel();
        lWPanel.setLayout(gridBagLayout);
        lWPanel2.setLayout(gridBagLayout);
        lWPanel3.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        Util.gblAdd(this, lWPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this, lWPanel2, gridBagConstraints, 1, 0, 1, 1, 3, 1);
        Util.gblAdd(this, lWPanel3, gridBagConstraints, 2, 0, 1, 1, 2, 1);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Util.gblAdd(lWPanel, new Label("X-AXIS", 1), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(lWPanel, new Label("Y-AXIS", 1), gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(lWPanel, this.cbXInterval, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(lWPanel, this.cbXProcessor, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(lWPanel, this.cbYMsg, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(lWPanel, this.cbYTime, gridBagConstraints, 1, 2, 1, 1, 1, 1);
        this.lIterate = new Label("", 1);
        Util.gblAdd(lWPanel2, this.lIterate, gridBagConstraints, 2, 0, 4, 1, 1, 1);
        Util.gblAdd(lWPanel2, new Label("-5", 1), gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, new Label("-1", 1), gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, new Label("+1", 1), gridBagConstraints, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, new Label("+5", 1), gridBagConstraints, 5, 1, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, this.bMinus5, gridBagConstraints, 2, 2, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, this.bMinus1, gridBagConstraints, 3, 2, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, this.bPlus1, gridBagConstraints, 4, 2, 1, 1, 1, 1);
        Util.gblAdd(lWPanel2, this.bPlus5, gridBagConstraints, 5, 2, 1, 1, 1, 1);
        this.lSelect = new Label("", 1);
        String string = "Format: #,#-#,#,#,#-#,etc...";
        this.rangeField = new SelectField("", 12);
        Util.gblAdd(lWPanel3, this.lSelect, gridBagConstraints, 6, 0, 4, 1, 1, 1);
        Util.gblAdd(lWPanel3, this.rangeField, gridBagConstraints, 6, 1, 4, 1, 1, 1);
        Util.gblAdd(lWPanel3, this.bSelectAll, gridBagConstraints, 6, 2, 2, 1, 1, 1);
        Util.gblAdd(lWPanel3, this.bApply, gridBagConstraints, 8, 2, 2, 1, 1, 1);
        this.rangeField.setText(string);
        this.rangeField.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bPlus5 || button == this.bPlus1 || button == this.bMinus1 || button == this.bMinus5) {
                int n = 0;
                if (button == this.bPlus5) {
                    n = 5;
                } else if (button == this.bPlus1) {
                    n = 1;
                } else if (button == this.bMinus1) {
                    n = -1;
                } else if (button == this.bMinus5) {
                    n = -5;
                }
                int n2 = 0;
                if (this.data.xmode == 0) {
                    this.data.interval.list.reset();
                    n2 = this.data.interval.list.currentElement();
                    n2 = (n2 + n) % this.data.interval.num;
                    if (n2 < 0) {
                        n2 += this.data.interval.num;
                    }
                } else {
                    if (n < 0) {
                        n += this.origProcList.size();
                    }
                    n2 = this.origProcList.currentElement();
                    int n3 = 0;
                    while (n3 < n) {
                        n2 = this.origProcList.nextElement();
                        if (n2 == -1) {
                            n2 = this.origProcList.nextElement();
                        }
                        ++n3;
                    }
                }
                this.rangeField.setText(n2 + "");
            } else if (button == this.bSelectAll) {
                int n = 0;
                if (this.data.xmode == 0) {
                    n = this.data.interval.num - 1;
                    this.rangeField.setText("0-" + n);
                } else {
                    this.rangeField.setText(this.origProcList.listToString());
                }
            }
        }
        if (this.data.xmode == 0) {
            this.data.interval.list = this.rangeField.getValue(this.data.interval.num);
            this.data.interval.string = this.rangeField.getText();
            this.data.setData();
        } else {
            this.data.processor.list = this.rangeField.getValue(Analysis.getNumProcessors());
            if (!this.origProcList.contains(this.data.processor.list)) {
                System.out.println("Invalid processor range. ");
                if (this.errDlg == null) {
                    this.errDlg = new ErrorDialog((Frame)this.data.graphWindow, "Processors Range Beyond Scope!");
                }
                if (!this.errDlg.isShowing()) {
                    this.errDlg.show();
                }
                this.rangeField.setText(this.origProcList.listToString());
                return;
            }
            this.data.processor.string = this.rangeField.getText();
            this.data.setData();
        }
        this.data.displayPanel.setAllBounds();
        this.data.displayPanel.UpdateDisplay();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.data == null) {
            return;
        }
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        if (checkbox == this.cbXProcessor) {
            this.setXMode(0);
        } else if (checkbox == this.cbXInterval) {
            this.setXMode(1);
        } else if (checkbox == this.cbYMsg) {
            this.setYMode(11);
        } else if (checkbox == this.cbYTime) {
            this.setYMode(10);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        super.paint(graphics);
    }

    public void setGraphData(GraphData graphData) {
        this.data = graphData;
        this.origProcList = graphData.processor.list;
    }

    public void setXMode(int n) {
        if (this.data == null) {
            return;
        }
        this.data.xmode = n;
        if (n == 0) {
            if (!this.cbXProcessor.getState()) {
                this.cbXProcessor.setState(true);
            }
            this.lIterate.setText("ITERATE INTERVALS");
            this.lSelect.setText("SELECT INTERVALS (0-" + (this.data.interval.num - 1) + ")");
            this.rangeField.setText(this.data.interval.string);
        } else {
            if (!this.cbXInterval.getState()) {
                this.cbXInterval.setState(true);
            }
            this.lIterate.setText("ITERATE PROCESSORS");
            this.lSelect.setText("SELECT PROCESSORS (" + this.origProcList.listToString() + ")");
            this.rangeField.setText(this.data.processor.string);
        }
        this.data.displayPanel.setAllBounds();
        this.data.displayPanel.UpdateDisplay();
    }

    public void setYMode(int n) {
        if (this.data == null) {
            return;
        }
        if (n == 10 && !this.cbYTime.getState()) {
            this.cbYTime.setState(true);
        } else if (n == 11 && !this.cbYMsg.getState()) {
            this.cbYMsg.setState(true);
        }
        this.data.ymode = n;
        this.data.displayPanel.setAllBounds();
        this.data.displayPanel.UpdateDisplay();
        this.data.legendPanel.UpdateLegend();
    }
}

