/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import projections.gui.Analysis;
import projections.gui.BItem;
import projections.gui.GraphControlPanel;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphLegendPanel;
import projections.gui.GraphWindow;
import projections.gui.OrderedIntList;
import projections.gui.ZItem;

public class GraphData {
    static final int PROCESSOR = 0;
    static final int INTERVAL = 1;
    static final int TIME = 10;
    static final int MSGS = 11;
    static final int BOTH = 12;
    static final int LINE = 20;
    static final int BAR = 21;
    protected int intervalStart;
    protected int intervalEnd;
    protected int numUserEntries;
    protected int graphtype;
    protected int xmode;
    protected int ymode;
    protected int minx;
    protected int maxx;
    protected int offset;
    protected int offset2;
    protected int offset3;
    protected float scale;
    protected double yscale;
    protected double wscale;
    protected double xscale;
    private float colorindex;
    private float colorvalue;
    private boolean colorflag = false;
    protected ZItem[] systemUsage;
    protected ZItem[][] systemMsgs;
    protected ZItem[][] userEntry;
    protected ZItem[] onGraph;
    protected BItem processor;
    protected BItem interval;
    protected GraphControlPanel controlPanel;
    protected GraphLegendPanel legendPanel;
    protected GraphDisplayPanel displayPanel;
    protected GraphWindow graphWindow;
    protected OrderedIntList origProcList;

    public GraphData(int n, long l, int n2, int n3, OrderedIntList orderedIntList) {
        this.intervalStart = n2;
        this.intervalEnd = n3;
        this.yscale = 1.0;
        this.wscale = 1.0;
        this.offset = 10;
        this.offset2 = 0;
        this.offset3 = 0;
        this.numUserEntries = Analysis.getNumUserEntries();
        this.colorvalue = 0.0f;
        this.colorindex = 1.0f / (float)(this.numUserEntries + 7);
        this.graphtype = 21;
        this.xmode = 1;
        this.ymode = 11;
        this.processor = new BItem();
        this.origProcList = orderedIntList;
        this.processor.list = orderedIntList;
        this.processor.string = this.processor.list.listToString();
        this.processor.num = orderedIntList.size();
        String[] stringArray = new String[]{"Queue Size", "Processor Usage(%)", "Idle Time(%)"};
        this.systemUsage = new ZItem[3];
        int n4 = 0;
        while (n4 < 3) {
            this.systemUsage[n4] = new ZItem();
            this.systemUsage[n4].name = stringArray[n4];
            this.systemUsage[n4].exists = null != Analysis.getSystemUsageData(n4);
            float f = (float)(1.0 - (double)n4 * 0.3);
            this.systemUsage[n4].color = new Color(f, f, f);
            if (n4 == 1) {
                this.systemUsage[n4].state = true;
            }
            if (n4 == 0) {
                this.systemUsage[n4].type = "Msgs";
                this.systemUsage[n4].ymode = 11;
            } else {
                this.systemUsage[n4].type = "%";
                this.systemUsage[n4].ymode = 12;
            }
            ++n4;
        }
        this.onGraph = new ZItem[1];
        this.onGraph[0] = this.systemUsage[1];
        String[] stringArray2 = new String[]{"New Chare", "For Chare", "New Group", "Load Balancing", "Quiescence"};
        String[] stringArray3 = new String[]{"Creation", "Processing", "Time"};
        this.systemMsgs = new ZItem[5][3];
        int n5 = 0;
        while (n5 < 5) {
            int n6 = 0;
            while (n6 < 3) {
                this.systemMsgs[n5][n6] = new ZItem();
                this.systemMsgs[n5][n6].name = stringArray2[n5];
                this.systemMsgs[n5][n6].type = stringArray3[n6];
                this.systemMsgs[n5][n6].exists = Analysis.hasSystemMsgsData(n5, n6);
                if (n6 == 0) {
                    this.systemMsgs[n5][n6].color = this.nextColor();
                    this.systemMsgs[n5][n6].ymode = 11;
                } else if (n6 == 1) {
                    this.systemMsgs[n5][n6].color = this.systemMsgs[n5][0].color.darker();
                    this.systemMsgs[n5][n6].ymode = 11;
                } else if (n6 == 2) {
                    this.systemMsgs[n5][n6].color = this.systemMsgs[n5][0].color;
                    this.systemMsgs[n5][n6].ymode = 10;
                }
                ++n6;
            }
            ++n5;
        }
        String[][] stringArray4 = Analysis.getEntryNames();
        this.userEntry = new ZItem[this.numUserEntries][3];
        int n7 = 0;
        while (n7 < this.numUserEntries) {
            int n8 = 0;
            while (n8 < 3) {
                this.userEntry[n7][n8] = new ZItem();
                this.userEntry[n7][n8].name = stringArray4[n7][0];
                this.userEntry[n7][n8].type = stringArray3[n8];
                this.userEntry[n7][n8].parent = stringArray4[n7][1];
                this.userEntry[n7][n8].exists = Analysis.hasUserEntryData(n7, n8);
                if (n8 == 0) {
                    this.userEntry[n7][n8].color = this.nextColor();
                    this.userEntry[n7][n8].ymode = 11;
                } else if (n8 == 1) {
                    this.userEntry[n7][n8].color = this.userEntry[n7][0].color.darker();
                    this.userEntry[n7][n8].ymode = 11;
                } else if (n8 == 2) {
                    this.userEntry[n7][n8].color = this.userEntry[n7][0].color;
                    this.userEntry[n7][n8].ymode = 10;
                }
                ++n8;
            }
            ++n7;
        }
        this.initData(n, l);
    }

    public void initData(int n, long l) {
        int n2;
        this.scale = 1.0f;
        this.interval = new BItem();
        this.interval.num = n;
        this.interval.size = l;
        this.interval.list = new OrderedIntList();
        int n3 = this.intervalStart;
        while (n3 <= this.intervalEnd) {
            this.interval.list.insert(n3);
            ++n3;
        }
        this.interval.string = this.interval.list.listToString();
        int n4 = Analysis.getNumProcessors();
        int n5 = 0;
        while (n5 < 3) {
            if (null != Analysis.getSystemUsageData(n5)) {
                this.systemUsage[n5].data = Analysis.getSystemUsageData(n5);
                this.systemUsage[n5].curPData = new int[n4];
                this.systemUsage[n5].curIData = new int[this.interval.num];
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < 5) {
            n2 = 0;
            while (n2 < 3) {
                if (Analysis.hasSystemMsgsData(n6, n2)) {
                    this.systemMsgs[n6][n2].data = Analysis.getSystemMsgsData(n6, n2);
                    this.systemMsgs[n6][n2].curPData = new int[n4];
                    this.systemMsgs[n6][n2].curIData = new int[this.interval.num];
                }
                ++n2;
            }
            ++n6;
        }
        n2 = 0;
        while (n2 < this.numUserEntries) {
            int n7 = 0;
            while (n7 < 3) {
                if (Analysis.hasUserEntryData(n2, n7)) {
                    this.userEntry[n2][n7].data = Analysis.getUserEntryData(n2, n7);
                    this.userEntry[n2][n7].curPData = new int[n4];
                    this.userEntry[n2][n7].curIData = new int[this.interval.num];
                }
                ++n7;
            }
            ++n2;
        }
        this.setData();
    }

    private Color nextColor() {
        Color color = Color.getHSBColor((float)((double)this.colorvalue * 0.173 % 1.0), (float)(1.0 - 0.6 * ((double)this.colorvalue * 0.729 % 1.0)), 1.0f);
        this.colorvalue = (float)((double)this.colorvalue + 1.0);
        return color;
    }

    private int setCurIData(ZItem zItem) {
        int n = 0;
        int n2 = this.intervalStart;
        while (n2 <= this.intervalEnd) {
            zItem.curIData[n2 - this.intervalStart] = 0;
            if (this.interval.list.contains(n2)) {
                int n3;
                int n4 = 0;
                this.processor.list.reset();
                while ((n3 = this.processor.list.nextElement()) >= 0) {
                    if (zItem.data[n3] == null) continue;
                    int n5 = n2 - this.intervalStart;
                    zItem.curIData[n5] = zItem.curIData[n5] + zItem.data[n3][n2 - this.intervalStart];
                    ++n4;
                }
                if (zItem.ymode == 12) {
                    if (n4 != 0) {
                        int n6 = n2 - this.intervalStart;
                        zItem.curIData[n6] = zItem.curIData[n6] / n4;
                    }
                } else {
                    n = Math.max(zItem.curIData[n2 - this.intervalStart], n);
                }
            }
            ++n2;
        }
        return n;
    }

    private int setCurPData(ZItem zItem) {
        int n = 0;
        int n2 = Analysis.getNumProcessors();
        int n3 = 0;
        while (n3 < n2) {
            zItem.curPData[n3] = 0;
            if (this.processor.list.contains(n3) && zItem.data[n3] != null) {
                int n4;
                int n5 = 0;
                this.interval.list.reset();
                while ((n4 = this.interval.list.nextElement()) >= 0) {
                    int n6 = n3;
                    zItem.curPData[n6] = zItem.curPData[n6] + zItem.data[n3][n4 - this.intervalStart];
                    ++n5;
                }
                if (zItem.ymode == 12) {
                    int n7 = n3;
                    zItem.curPData[n7] = zItem.curPData[n7] / n5;
                } else {
                    n = Math.max(zItem.curPData[n3], n);
                }
            }
            ++n3;
        }
        return n;
    }

    public void setData() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.onGraph.length) {
            if (this.onGraph[n5] == null) {
                System.out.println("onGraph[" + n5 + "/" + this.onGraph.length + "]==null");
            } else if (this.onGraph[n5].ymode == 12) {
                this.setCurPData(this.onGraph[n5]);
                this.setCurIData(this.onGraph[n5]);
            } else if (this.onGraph[n5].ymode == 10) {
                n2 = Math.max(this.setCurPData(this.onGraph[n5]), n2);
                n4 = Math.max(this.setCurIData(this.onGraph[n5]), n4);
            } else {
                n = Math.max(this.setCurPData(this.onGraph[n5]), n);
                n3 = Math.max(this.setCurIData(this.onGraph[n5]), n3);
            }
            ++n5;
        }
        this.processor.maxTime = n2;
        this.processor.maxMsgs = n;
        this.interval.maxTime = n4;
        this.interval.maxMsgs = n3;
    }
}

