/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Analysis;
import projections.gui.GraphWindow;
import projections.gui.OrderedIntList;
import projections.gui.SelectField;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

public class GraphIntervalDialog
extends Dialog
implements ActionListener,
KeyListener,
FocusListener {
    private GraphWindow graphWindow;
    private SelectField processorsField;
    private Panel timePanel;
    private TimeTextField sizeField;
    private TimeTextField startTimeField;
    private TimeTextField endTimeField;
    private Panel intervalPanel;
    private Label numLabel;
    private Label startLabel;
    private Label endLabel;
    private Button bOK;
    private Button bCancel;
    private int numProcs;
    private long intervalSize;
    private long totalTime;
    private long startTime;
    private long endTime;
    private int numIntervals;
    private int intervalStart;
    private int intervalEnd;
    private long extraTime;
    private OrderedIntList processorList;
    private String processorString;

    public GraphIntervalDialog(GraphWindow graphWindow, int n, long l, int n2, int n3, long l2, long l3, String string) {
        super(graphWindow, "Set Interval Size", true);
        this.numIntervals = n;
        this.intervalSize = l;
        this.intervalStart = n2;
        this.intervalEnd = n3;
        this.startTime = l2;
        this.endTime = l3;
        this.graphWindow = graphWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)GraphIntervalDialog.this).setVisible(false);
                GraphIntervalDialog.this.dispose();
            }
        });
        this.totalTime = Analysis.getTotalTime();
        this.numProcs = Analysis.getNumProcessors();
        if (this.numIntervals <= 0) {
            this.intervalSize = 1000L;
            this.numIntervals = this.getNumIntervals(this.intervalSize);
        }
        if (this.intervalStart <= 0 || this.intervalEnd <= 0) {
            this.intervalStart = 0;
            this.intervalEnd = this.numIntervals - 1;
            this.startTime = 0L;
            this.endTime = this.totalTime;
        }
        this.processorString = string == null ? "0-" + Integer.toString(this.numProcs - 1) : string;
        this.CreateLayout();
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bOK) {
                TextComponent textComponent = this.checkConsistent();
                if (textComponent != null) {
                    textComponent.selectAll();
                    textComponent.requestFocus();
                    return;
                }
                this.graphWindow.setIntervalSize(this.intervalSize);
                this.graphWindow.setNumIntervals(this.numIntervals);
                this.graphWindow.setTimes(this.startTime, this.endTime);
                this.graphWindow.setIntervalRange(this.intervalStart, this.intervalEnd);
                this.processorList = this.processorsField.getValue(Analysis.getNumProcessors());
                this.processorString = this.processorList.listToString();
                this.graphWindow.setProcessorRange(this.processorList);
            }
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() instanceof TextComponent) {
            this.updateData((TextComponent)actionEvent.getSource());
            this.bOK.setEnabled(true);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof TextComponent) {
            this.updateData((TextComponent)focusEvent.getComponent());
            this.bOK.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getComponent() instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)keyEvent.getComponent();
            switch (n) {
                case 10: {
                    this.updateData(textComponent);
                    this.bOK.setEnabled(true);
                    break;
                }
                case 9: {
                    this.updateData(textComponent);
                    this.bOK.setEnabled(true);
                    break;
                }
                default: {
                    this.bOK.setEnabled(false);
                }
            }
        }
    }

    private void CreateLayout() {
        this.processorsField = new SelectField(this.processorString, 12);
        this.processorsField.addActionListener(this);
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.timePanel = new Panel();
        this.sizeField = new TimeTextField(this.intervalSize, 12);
        this.startTimeField = new TimeTextField(this.startTime, 12);
        this.endTimeField = new TimeTextField(this.endTime, 12);
        this.sizeField.addActionListener(this);
        this.startTimeField.addActionListener(this);
        this.endTimeField.addActionListener(this);
        this.sizeField.addKeyListener(this);
        this.startTimeField.addKeyListener(this);
        this.endTimeField.addKeyListener(this);
        this.sizeField.addFocusListener(this);
        this.startTimeField.addFocusListener(this);
        this.endTimeField.addFocusListener(this);
        this.intervalPanel = new Panel();
        this.numLabel = new Label("" + this.numIntervals, 0);
        this.startLabel = new Label("" + this.intervalStart, 0);
        this.endLabel = new Label("" + this.intervalEnd, 0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        panel2.setLayout(new FlowLayout());
        this.timePanel.setLayout(gridBagLayout);
        this.intervalPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Util.gblAdd(panel, new Label("Total Time:", 2), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label(U.t(this.totalTime), 2), gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label("Total Processors:", 2), gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label(Integer.toString(this.numProcs), 2), gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label("Processors:", 2), gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(panel, this.processorsField, gridBagConstraints, 1, 2, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, new Label("Interval Size:", 2), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.sizeField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, new Label("Start time:", 2), gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTimeField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, new Label("End time:", 2), gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTimeField, gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, this.timePanel, gridBagConstraints, 0, 4, 2, 1, 1, 1);
        Util.gblAdd(this.intervalPanel, new Label("# of Intervals:", 2), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.intervalPanel, this.numLabel, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.intervalPanel, new Label("Start Interval:", 2), gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.intervalPanel, this.startLabel, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.intervalPanel, new Label("End Interval:", 2), gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.intervalPanel, this.endLabel, gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, this.intervalPanel, gridBagConstraints, 0, 6, 2, 1, 1, 1);
        this.bOK = new Button("OK");
        this.bCancel = new Button("Cancel");
        panel2.add(this.bOK);
        panel2.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.add((Component)panel, "Center");
        this.add((Component)panel2, "South");
    }

    private int getNumIntervals(long l) {
        if (l <= 0L) {
            l = 1L;
        }
        return (int)Math.ceil((double)this.totalTime / (double)l);
    }

    private int getIntervalIndex(long l) {
        return (int)(l / this.intervalSize);
    }

    private void updateData(TextComponent textComponent) {
        if (textComponent instanceof TimeTextField) {
            if (textComponent == this.sizeField) {
                this.intervalSize = this.sizeField.getValue();
                this.intervalSize = U.makeEven(this.intervalSize);
                this.sizeField.setValue(this.intervalSize);
                this.numIntervals = this.getNumIntervals(this.intervalSize);
                this.numLabel.setText("" + this.numIntervals);
                this.intervalStart = this.getIntervalIndex(this.startTime);
                this.startLabel.setText("" + this.intervalStart);
                this.intervalEnd = this.getIntervalIndex(this.endTime);
                this.endLabel.setText("" + this.intervalEnd);
            } else if (textComponent == this.startTimeField) {
                this.startTime = this.startTimeField.getValue();
                this.intervalStart = this.getIntervalIndex(this.startTime);
                this.startLabel.setText("" + this.intervalStart);
            } else if (textComponent == this.endTimeField) {
                this.endTime = this.endTimeField.getValue();
                this.intervalEnd = this.getIntervalIndex(this.endTime);
                this.endLabel.setText("" + this.intervalEnd);
            }
        }
    }

    private TextComponent checkConsistent() {
        if (this.startTime >= this.endTime) {
            return this.startTimeField;
        }
        if (this.startTime < 0L) {
            return this.startTimeField;
        }
        if (this.endTime > this.totalTime) {
            return this.endTimeField;
        }
        return null;
    }
}

