/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Component;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;

public class GraphingWindow
extends GenericGraphWindow {
    private MainWindow mainWindow;
    private double[][] data;
    protected IntervalRangeDialog dialog;

    public GraphingWindow(MainWindow mainWindow) {
        super("Graph");
        this.mainWindow = mainWindow;
        this.showDialog();
    }

    protected void showDialog() {
        int n;
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        if ((n = this.dialog.showDialog()) == 0) {
            this.dialog.setAllData();
            this.createLayout();
        } else {
            this.close();
        }
    }

    protected void setGraphSpecificData() {
        this.setBarGraphType(0);
        this.setXAxis("Intervals", "");
        this.setDataSource("Time spent by EP", this.data);
        this.dataSource.setColors(Analysis.getColorMap());
        this.setYAxis("Time", "ms");
        System.out.println(Analysis.getColorMap().length);
        System.out.println(this.data.length);
        System.out.println(this.data[0].length);
    }

    private void createLayout() {
        this.getContentPane().add(this.getMainPanel());
        this.setupData();
        this.setGraphSpecificData();
        this.pack();
        ((Component)this).setVisible(true);
        this.refreshGraph();
    }

    private void setupData() {
        if (Analysis.hasSumDetailData()) {
            int n = Analysis.getNumProcessors();
            int n2 = Analysis.getNumUserEntries();
            int n3 = Analysis.getNumIntervals();
            double d = Analysis.getIntervalSize();
            int n4 = (int)((double)this.startTime / (d * 1000000.0));
            int n5 = (int)((double)this.endTime / (d * 1000000.0));
            System.out.println(d);
            System.out.println(this.startTime + " " + this.endTime);
            System.out.println(n4 + " " + n5);
            double[][] dArray = Analysis.getDataSummedAcrossProcessors(0, this.validPEs, n4, n5);
            this.data = new double[n5 - n4 + 1][n2];
            int n6 = 0;
            while (n6 < dArray.length) {
                int n7 = 0;
                while (n7 < dArray[n6].length) {
                    this.data[n7][n6] = dArray[n6][n7];
                    ++n7;
                }
                ++n6;
            }
        }
    }
}

