/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class IntervalWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener {
    private long thresholdTime;
    private long intervalSize;
    private double[][] dataSource;
    private boolean countSends = true;
    private boolean getNewData = false;
    private final int NO_OF_DATASOURCES = 3;
    private final int STRETCHED_EP = 0;
    private final int SEND_COUNT = 1;
    private final int MSG_LEN_COUNT = 2;

    public IntervalWindow(MainWindow mainWindow) {
        super("Projections Interval Graph");
        this.setGraphSpecificData();
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        ((Component)this).setVisible(true);
        this.showDialog();
        this.refreshGraph();
    }

    void showDialog() {
        int n;
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        if ((n = this.dialog.showDialog()) == 0) {
            this.setAllData();
            this.getNewData = true;
            this.refreshGraph();
        }
    }

    public void setAllData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.thresholdTime = intervalRangeDialog.getThresholdTime();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText().equals("Set Range")) {
                this.showDialog();
            } else if (jMenuItem.getText().equals("Send Count vs Stretched EntryPoints")) {
                this.countSends = jMenuItem.isSelected();
                this.getNewData = false;
                this.refreshGraph();
            } else if (jMenuItem.getText().equals("Bytes Sent vs Stretched EntryPoints")) {
                this.countSends = !jMenuItem.isSelected();
                this.getNewData = false;
                this.refreshGraph();
            } else if (jMenuItem.getText().equals("Close")) {
                this.close();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
        String string = "Item event detected. \n   Event source: " + jMenuItem.getText() + "\n    New state: " + (itemEvent.getStateChange() == 1 ? "selected" : "unselected");
        System.out.println(string);
    }

    protected void createMenus() {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Send Count vs Stretched EntryPoints", true);
        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Bytes Sent vs Stretched EntryPoints", false);
        jRadioButtonMenuItem2.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Set Range", "Close"}, null, this));
        jMenuBar.add(Util.makeJMenu("Options", new Object[]{jRadioButtonMenuItem, jRadioButtonMenuItem2}, null, this));
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Time Interval", "");
        this.setYAxis("#", "");
    }

    protected void refreshGraph() {
        if (this.getNewData) {
            this.getNewData();
        }
        if (this.dataSource != null) {
            int n;
            String string;
            if (this.countSends) {
                string = "Stretched EntryPoints vs Send Messages";
                n = 1;
            } else {
                string = "Stretched EntryPoints vs Bytes Sent";
                n = 2;
            }
            double[][] dArray = new double[this.dataSource.length][2];
            int n2 = 0;
            while (n2 < this.dataSource.length) {
                dArray[n2][0] = this.dataSource[n2][0];
                dArray[n2][1] = this.dataSource[n2][n];
                ++n2;
            }
            double d = (double)(this.endTime - this.startTime) / (double)(this.dataSource.length - 1);
            this.setXAxis("Time Interval (" + U.t(this.startTime) + " - " + U.t(this.endTime) + ")", "ms", this.startTime / 1000L, d / 1000.0);
            this.setDataSource(string, dArray);
            super.refreshGraph();
        }
    }

    private void getNewData() {
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        LogEntryData logEntryData = new LogEntryData();
        LogEntryData logEntryData2 = new LogEntryData();
        int n = (int)((this.endTime - this.startTime) / this.intervalSize) + 1;
        this.dataSource = new double[n][3];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 3) {
                this.dataSource[n2][n3] = 0.0;
                ++n3;
            }
            ++n2;
        }
        block10: while (orderedIntList.hasMoreElements()) {
            int n4 = orderedIntList.nextElement();
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n4), Analysis.getVersion());
            try {
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (true) {
                    genericLogReader.nextEvent(logEntryData);
                    if (logEntryData.time > this.endTime) continue block10;
                    switch (logEntryData.type) {
                        case 1: {
                            int n5 = (int)((logEntryData.time - this.startTime) / this.intervalSize);
                            double[] dArray = this.dataSource[n5];
                            dArray[1] = dArray[1] + 1.0;
                            double[] dArray2 = this.dataSource[n5];
                            dArray2[2] = dArray2[2] + (double)logEntryData.msglen;
                            break;
                        }
                        case 2: {
                            logEntryData2 = logEntryData.copyOf();
                            break;
                        }
                        case 3: {
                            long l = logEntryData.time - logEntryData2.time;
                            if (l <= this.thresholdTime) break;
                            int n5 = (int)((logEntryData2.time - this.startTime) / this.intervalSize);
                            double[] dArray = this.dataSource[n5];
                            dArray[0] = dArray[0] + 1.0;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.out.println("Exception at IntervalWindow::getData() " + iOException);
            }
        }
    }
}

