/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.Util;

public class MainRunStatusPanel
extends JPanel
implements ChangeListener {
    JTextField statusField;
    JLabel statusLabel;
    int tabIndex = 0;

    public MainRunStatusPanel() {
        this.createLayout();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof MainSummaryGraphPanel) {
            MainSummaryGraphPanel mainSummaryGraphPanel = (MainSummaryGraphPanel)changeEvent.getSource();
            if (mainSummaryGraphPanel.isEmpty()) {
                this.setField(0, "Not Applicable");
            } else {
                int n = mainSummaryGraphPanel.getSelectedIndex();
                if (n != -1) {
                    this.setField(n, mainSummaryGraphPanel.getTitleAt(n));
                }
            }
        }
    }

    private void createLayout() {
        this.setBackground(Color.black);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.setLayout(gridBagLayout);
        this.statusField = new JTextField("Tab Index " + this.tabIndex + ": " + "Not Applicable");
        this.statusField.setEditable(false);
        this.statusLabel = new JLabel("Active Run: ");
        this.statusLabel.setForeground(Color.yellow);
        Util.gblAdd(this, this.statusLabel, gridBagConstraints, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0);
        Util.gblAdd(this, this.statusField, gridBagConstraints, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0);
    }

    private void setField(int n, String string) {
        this.statusField.setText("Tab Index " + n + ": " + string);
    }
}

