/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.AreaGraphPanel;
import projections.gui.MainWindow;
import projections.gui.MultiRunCallBack;
import projections.gui.MultiRunControlPanel;
import projections.gui.MultiRunTables;
import projections.gui.ProjectionsFileChooser;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.MultiRunDataSource;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.MultiRunYAxis;
import projections.misc.MultiRunData;

public class MultiRunWindow
extends JFrame
implements ActionListener,
ItemListener {
    private MainWindow mainWindow;
    private MultiRunControlPanel controlPanel;
    private MultiRunTables tablesPanel;
    private AreaGraphPanel graphPanel;
    private MultiRunDataAnalyzer analyzer;
    private JPanel mainPanel;
    GridBagLayout gbl;
    GridBagConstraints gbc;
    private static final int MODE_GRAPH = 0;
    private static final int MODE_TABLE = 1;
    private int displayMode;
    private int selectedDataType;

    public MultiRunWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MultiRunWindow.this.close();
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.showFileDialog();
    }

    public void close() {
        ((Component)this).setVisible(false);
        this.dispose();
        this.mainWindow.closeChildWindow(this);
    }

    public void showFileDialog() {
        try {
            ProjectionsFileChooser projectionsFileChooser = new ProjectionsFileChooser(this, "Multirun Analysis", 1);
            MultiRunCallBack multiRunCallBack = new MultiRunCallBack(this, projectionsFileChooser);
            int n = projectionsFileChooser.showDialog(multiRunCallBack);
        }
        catch (Exception exception) {
            System.out.println("Filechooser error. Please fix");
            ProjectionsFileChooser.handleException(this, exception);
        }
    }

    public void beginAnalysis(ProjectionsFileChooser projectionsFileChooser) {
        String[] stringArray = projectionsFileChooser.userSelect_returnVal;
        try {
            MultiRunData multiRunData = new MultiRunData(stringArray);
            this.analyzer = new MultiRunDataAnalyzer(multiRunData);
            this.selectedDataType = 0;
            this.createDisplayPanels();
            this.createLayout();
            this.pack();
            this.setTitle("Multi-Run Analysis");
            ((Component)this).setVisible(true);
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    private void createLayout() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(Color.gray);
        this.displayMode = 0;
        this.controlPanel = new MultiRunControlPanel(this, this.selectedDataType);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.mainPanel.setLayout(this.gbl);
        this.gbc.fill = 1;
        Util.gblAdd(this.mainPanel, this.graphPanel, this.gbc, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(this.mainPanel, this.controlPanel, this.gbc, 0, 1, 2, 1, 1, 0, 2, 2, 2, 2);
        this.setContentPane(this.mainPanel);
    }

    private void createDisplayPanels() {
        MultiRunDataSource multiRunDataSource = this.analyzer.getDataSource(this.selectedDataType);
        MultiRunXAxis multiRunXAxis = this.analyzer.getMRXAxisData();
        MultiRunYAxis multiRunYAxis = this.analyzer.getMRYAxisData(this.selectedDataType);
        Graph graph = new Graph(multiRunDataSource, multiRunXAxis, multiRunYAxis);
        this.graphPanel = new AreaGraphPanel(graph);
        this.tablesPanel = new MultiRunTables(this.selectedDataType, this.analyzer);
    }

    private void setDisplayMode(int n) {
        if (n == this.displayMode) {
            return;
        }
        this.displayMode = n;
        switch (n) {
            case 0: {
                this.mainPanel.remove(this.tablesPanel);
                Util.gblAdd(this.mainPanel, this.graphPanel, this.gbc, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2);
                this.mainPanel.validate();
                this.graphPanel.repaint();
                break;
            }
            case 1: {
                this.mainPanel.remove(this.graphPanel);
                Util.gblAdd(this.mainPanel, this.tablesPanel, this.gbc, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2);
                this.mainPanel.validate();
                this.tablesPanel.repaint();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (itemEvent.getStateChange() == 1) {
                if (jRadioButton.getText().equals("Table")) {
                    this.setDisplayMode(1);
                } else if (jRadioButton.getText().equals("Graph")) {
                    this.setDisplayMode(0);
                } else {
                    this.selectedDataType = this.controlPanel.getSelectedIdx(itemEvent.getItemSelectable());
                    MultiRunDataSource multiRunDataSource = this.analyzer.getDataSource(this.selectedDataType);
                    MultiRunXAxis multiRunXAxis = this.analyzer.getMRXAxisData();
                    MultiRunYAxis multiRunYAxis = this.analyzer.getMRYAxisData(this.selectedDataType);
                    this.graphPanel.setData(multiRunDataSource, multiRunXAxis, multiRunYAxis);
                    this.tablesPanel.setType(this.selectedDataType);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        if (actionEvent.getSource() instanceof JButton && (jButton = (JButton)actionEvent.getSource()).getText().equals("Close Window")) {
            this.close();
        }
    }
}

