/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import projections.gui.Analysis;
import projections.gui.GrayPanel;
import projections.gui.ProfileData;
import projections.gui.SelectField;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

public class ProfileDialog2
extends Dialog
implements ActionListener,
TextListener {
    private TimeTextField beginField;
    private TimeTextField endField;
    private TimeTextField lengthField;
    private SelectField processorField;
    private SelectField phasesField;
    private long beginTime;
    private long endTime;
    private long totalTime;
    private long length;
    private ProfileData data;
    private Button bOK;
    private Button bCancel;
    private Button bFullRange;

    public ProfileDialog2(Frame frame, ProfileData profileData) {
        super(frame, "Select Processor and Time Ranges", true);
        this.data = profileData;
        this.beginTime = profileData.begintime;
        this.endTime = profileData.endtime;
        this.length = this.endTime - this.beginTime;
        this.totalTime = Analysis.getTotalTime();
        this.beginField = new TimeTextField(this.beginTime, 10);
        this.endField = new TimeTextField(this.endTime, 10);
        this.lengthField = new TimeTextField(this.length, 10);
        this.processorField = new SelectField(profileData.pstring, 20);
        this.phasesField = new SelectField(profileData.pstring, 20);
        this.beginField.addActionListener(this);
        this.beginField.addTextListener(this);
        this.endField.addActionListener(this);
        this.endField.addTextListener(this);
        this.lengthField.addActionListener(this);
        this.lengthField.addTextListener(this);
        this.processorField.addActionListener(this);
        this.phasesField.addActionListener(this);
        this.endField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof TimeTextField && focusEvent.getSource() == ProfileDialog2.this.endField) {
                    ProfileDialog2.this.endTime = ProfileDialog2.this.endField.getValue();
                    if (ProfileDialog2.this.endTime <= ProfileDialog2.this.beginTime || ProfileDialog2.this.endTime > ProfileDialog2.this.totalTime) {
                        ProfileDialog2.this.endField.selectAll();
                        ProfileDialog2.this.endField.requestFocus();
                    }
                }
            }
        });
        this.bOK = new Button("OK");
        this.bOK.addActionListener(this);
        this.bCancel = new Button("Cancel");
        this.bCancel.addActionListener(this);
        this.bFullRange = new Button("Select Full Time Range");
        this.bFullRange.addActionListener(this);
        Label label = new Label("Processor(s): ");
        Label label2 = new Label("Begin Time: ");
        Label label3 = new Label("End Time: ");
        Label label4 = new Label("Length: ");
        Label label5 = new Label("-OR-", 1);
        Label label6 = new Label("-OR-", 1);
        Label label7 = new Label("Valid times: 0 - " + U.t(this.totalTime), 1);
        Label label8 = new Label("Valid processors: 0 - " + (Analysis.getNumProcessors() - 1), 1);
        Label label9 = new Label("Phase(s): ");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GrayPanel grayPanel = new GrayPanel();
        grayPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(grayPanel, label, gridBagConstraints, 0, 0, 1, 1, 1, 1, 8, 8, 4, 0);
        Util.gblAdd(grayPanel, this.processorField, gridBagConstraints, 1, 0, 4, 1, 1, 1, 8, 0, 4, 8);
        Util.gblAdd(grayPanel, label9, gridBagConstraints, 0, 1, 1, 1, 1, 1, 8, 8, 4, 0);
        Util.gblAdd(grayPanel, this.phasesField, gridBagConstraints, 1, 1, 1, 1, 1, 1, 4, 0, 0, 4);
        Util.gblAdd(grayPanel, label2, gridBagConstraints, 0, 2, 1, 1, 1, 1, 4, 8, 0, 0);
        Util.gblAdd(grayPanel, this.beginField, gridBagConstraints, 1, 2, 1, 1, 1, 1, 4, 0, 0, 4);
        Util.gblAdd(grayPanel, label5, gridBagConstraints, 2, 2, 1, 1, 1, 1, 4, 4, 0, 4);
        Util.gblAdd(grayPanel, label3, gridBagConstraints, 0, 3, 1, 1, 1, 1, 0, 8, 4, 0);
        Util.gblAdd(grayPanel, this.endField, gridBagConstraints, 1, 3, 1, 1, 1, 1, 0, 0, 4, 4);
        Util.gblAdd(grayPanel, label6, gridBagConstraints, 2, 3, 1, 1, 1, 1, 0, 4, 4, 4);
        Util.gblAdd(grayPanel, label4, gridBagConstraints, 3, 3, 1, 1, 1, 1, 0, 4, 4, 0);
        Util.gblAdd(grayPanel, this.lengthField, gridBagConstraints, 4, 3, 1, 1, 1, 1, 0, 0, 4, 8);
        Util.gblAdd(grayPanel, label7, gridBagConstraints, 0, 4, 2, 1, 1, 1, 4, 8, 8, 4);
        Util.gblAdd(grayPanel, label8, gridBagConstraints, 2, 4, 3, 1, 1, 1, 4, 4, 8, 8);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(this.bFullRange);
        panel.add(this.bOK);
        panel.add(this.bCancel);
        Util.gblAdd(grayPanel, panel, gridBagConstraints, 0, 5, 5, 1, 1, 1, 0, 4, 4, 4);
        Panel panel2 = new Panel();
        panel2.setBackground(Color.gray);
        this.add("Center", panel2);
        panel2.setLayout(gridBagLayout);
        Util.gblAdd(panel2, grayPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button && (Button)object == this.bOK || object instanceof TimeTextField || object instanceof SelectField) {
            if (this.endTime > this.beginTime) {
                this.data.plist = this.processorField.getValue(Analysis.getNumProcessors());
                this.data.phaselist = this.phasesField.getValue(Analysis.getNumPhases());
                this.data.pstring = this.data.plist.listToString();
                this.data.begintime = this.beginField.getValue();
                this.data.endtime = this.endField.getValue();
                this.data.profileWindow.CloseDialog();
            } else {
                this.endField.selectAll();
                this.endField.requestFocus();
            }
        } else if (object instanceof Button && (Button)object == this.bCancel) {
            this.data.profileWindow.CancelDialog();
        } else if (object instanceof Button && (Button)object == this.bFullRange) {
            this.beginTime = 0L;
            this.endTime = this.totalTime;
            this.length = this.endTime - this.beginTime;
            this.beginField.setText("" + this.beginTime);
            this.endField.setText("" + this.endTime);
            this.lengthField.setText("" + this.length);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() instanceof TimeTextField) {
            TimeTextField timeTextField = (TimeTextField)textEvent.getSource();
            TimeTextField timeTextField2 = null;
            if (this.getFocusOwner() instanceof TimeTextField) {
                timeTextField2 = (TimeTextField)this.getFocusOwner();
            }
            if (timeTextField == this.beginField) {
                this.beginTime = this.beginField.getValue();
                if (this.beginTime > this.totalTime - 1L) {
                    int n = this.beginField.getCaretPosition();
                    this.beginTime = this.totalTime - 1L;
                    this.beginField.setText("" + this.beginTime);
                    this.beginField.setCaretPosition(n);
                }
                this.length = this.endTime - this.beginTime;
                if (this.length < 1L) {
                    this.length = 1L;
                    this.endTime = this.beginTime + this.length;
                }
                this.endField.setText("" + this.endTime);
                this.lengthField.setText("" + this.length);
            } else if (timeTextField == this.endField && timeTextField2 == this.endField) {
                this.endTime = this.endField.getValue();
                if (this.endTime > this.totalTime) {
                    int n = this.endField.getCaretPosition();
                    this.endTime = this.totalTime;
                    this.endField.setText("" + this.endTime);
                    this.endField.setCaretPosition(n);
                }
                this.length = this.endTime - this.beginTime;
                this.lengthField.setText("" + this.length);
            } else if (timeTextField == this.lengthField && timeTextField2 == this.lengthField) {
                this.length = this.lengthField.getValue();
                if (this.length < 1L) {
                    int n = this.lengthField.getCaretPosition();
                    this.length = 1L;
                    this.lengthField.setText("" + this.length);
                    this.lengthField.setCaretPosition(n);
                } else if (this.length > this.totalTime - this.beginTime) {
                    int n = this.lengthField.getCaretPosition();
                    this.length = this.totalTime - this.beginTime;
                    this.lengthField.setText("" + this.length);
                    this.lengthField.setCaretPosition(n);
                }
                this.endTime = this.beginTime + this.length;
                this.endField.setText("" + this.endTime);
            }
        }
    }
}

