/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Rubberband {
    protected Point anchor = new Point(0, 0);
    protected Point stretched = new Point(0, 0);
    protected Point last = new Point(0, 0);
    protected Point end = new Point(0, 0);
    protected Point highlight = new Point(0, 0);
    private Component component = null;
    private Image image = null;
    private boolean firstStretch = true;
    private boolean firstHighlight = true;
    private Graphics graphics = null;

    public abstract void drawLast(Graphics var1);

    public abstract void drawNext(Graphics var1);

    public abstract void drawHighlight(Graphics var1);

    public abstract void clearHighlight(Graphics var1);

    public Rubberband(Component component) {
        this.component = component;
    }

    public Rubberband(Image image) {
        this.image = image;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public Point getStretched() {
        return this.stretched;
    }

    public Point getLast() {
        return this.last;
    }

    public Point getEnd() {
        return this.end;
    }

    public boolean getFirstStretch() {
        return this.firstStretch;
    }

    public void highlight(Point point) {
        this.setGraphics();
        if (!this.firstHighlight) {
            this.clearHighlight(this.graphics);
        }
        this.highlight.x = point.x;
        this.highlight.y = point.y;
        if (this.graphics != null) {
            this.drawHighlight(this.graphics);
        }
        this.firstHighlight = false;
    }

    public void clearHighlight() {
        if (this.setGraphics() != null) {
            this.clearHighlight(this.graphics);
        }
        this.firstHighlight = true;
    }

    public void anchor(Point point) {
        this.firstStretch = true;
        this.anchor.x = point.x;
        this.anchor.y = point.y;
        this.stretched.x = this.last.x = this.anchor.x;
        this.stretched.y = this.last.y = this.anchor.y;
    }

    public void stretch(Point point) {
        this.last.x = this.stretched.x;
        this.last.y = this.stretched.y;
        this.stretched.x = point.x;
        this.stretched.y = point.y;
        if (this.setGraphics() != null) {
            if (this.firstStretch) {
                this.firstStretch = false;
            } else {
                this.drawLast(this.graphics);
            }
            this.drawNext(this.graphics);
        }
    }

    public void end(Point point) {
        this.last.x = this.end.x = point.x;
        this.last.y = this.end.y = point.y;
        if (this.setGraphics() != null) {
            this.drawLast(this.graphics);
        }
    }

    public Rectangle bounds() {
        return new Rectangle(this.stretched.x < this.anchor.x ? this.stretched.x : this.anchor.x, this.stretched.y < this.anchor.y ? this.stretched.y : this.anchor.y, Math.abs(this.stretched.x - this.anchor.x), Math.abs(this.stretched.y - this.anchor.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.last.x < this.anchor.x ? this.last.x : this.anchor.x, this.last.y < this.anchor.y ? this.last.y : this.anchor.y, Math.abs(this.last.x - this.anchor.x), Math.abs(this.last.y - this.anchor.y));
    }

    private Graphics setGraphics() {
        Color color = Color.black;
        if (this.component != null) {
            if (this.graphics == null) {
                this.graphics = this.component.getGraphics();
            }
            color = this.component.getBackground();
        } else if (this.image != null && this.graphics == null) {
            this.graphics = this.image.getGraphics();
        }
        if (this.graphics != null) {
            this.graphics.setXORMode(color);
        }
        return this.graphics;
    }
}

