/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.gui.Analysis;
import projections.gui.ColorMap;
import projections.gui.IntervalRangeDialog;
import projections.gui.ProjectionsWindow;
import projections.gui.ScalePanel;
import projections.gui.ScaleSlider;
import projections.gui.StlPanel;
import projections.gui.Util;

public class StlWindow
extends ProjectionsWindow
implements MouseListener,
ActionListener,
ScalePanel.StatusDisplay,
ItemListener {
    private ScaleSlider hor;
    private ScaleSlider ver;
    private ScalePanel scalePanel;
    private StlPanel stl;
    private Label status;
    private boolean okorcancelled;
    public static final int NUM_MODES = 2;
    public static final int MODE_UTILIZATION = 0;
    public static final int MODE_EP = 1;
    private int mode = 0;
    private JPanel modePanel;
    private ButtonGroup modeGroup;
    private JRadioButton utilizationMode;
    private JRadioButton epMode;
    private long intervalSize;

    public StlWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StlWindow.this.dispose();
            }
        });
        ((Component)this).setBackground(Color.black);
        this.setForeground(Color.lightGray);
        this.setTitle("Projections-- Overview");
        this.createMenus();
        this.createLayout();
        this.pack();
        this.showDialog();
        if (this.okorcancelled) {
            ((Component)this).setVisible(true);
        } else {
            this.dispose();
        }
    }

    private void createLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.status = new Label("");
        this.status.setBackground(Color.black);
        this.status.setForeground(Color.lightGray);
        this.hor = new ScaleSlider(0);
        this.hor.addMouseListener(this);
        this.ver = new ScaleSlider(1);
        this.ver.addMouseListener(this);
        this.stl = new StlPanel();
        this.scalePanel = new ScalePanel(this.hor, this.ver, this.stl);
        gridBagConstraints.fill = 1;
        Util.gblAdd(jPanel, this.scalePanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 3;
        Util.gblAdd(jPanel, this.ver, gridBagConstraints, 1, 0, 1, 1, 0, 1);
        gridBagConstraints.fill = 2;
        Util.gblAdd(jPanel, this.hor, gridBagConstraints, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.status, gridBagConstraints, 0, 2, 1, 1, 1, 0);
        this.modePanel = new JPanel();
        this.modeGroup = new ButtonGroup();
        this.utilizationMode = new JRadioButton("Utilization", true);
        this.utilizationMode.addItemListener(this);
        this.epMode = new JRadioButton("By EP Colors", false);
        this.epMode.addItemListener(this);
        this.modeGroup.add(this.utilizationMode);
        this.modeGroup.add(this.epMode);
        gridBagConstraints.fill = 2;
        Util.gblAdd(this.modePanel, this.utilizationMode, gridBagConstraints, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.modePanel, this.epMode, gridBagConstraints, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        Util.gblAdd(container, jPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(container, this.modePanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1);
        this.scalePanel.setStatusDisplay(this);
        this.setStlPanelData(1);
    }

    private void setStlPanelData(int n) {
        double d;
        double d2;
        if (this.scalePanel == null) {
            System.out.println("How  can it be ");
        }
        ColorMap colorMap = new ColorMap();
        if (this.mode == 0) {
            colorMap.addBreak(0, 0, 0, 55, 70, 255, 0, 0);
            colorMap.addBreak(70, 255, 0, 0, 100, 255, 255, 255);
            colorMap.addBreak(101, 0, 255, 0, 255, 0, 255, 0);
        } else if (this.mode == 1) {
            // empty if block
        }
        this.stl.setColorMap(colorMap);
        if (this.validPEs == null) {
            d2 = Analysis.getTotalTime();
            d = Analysis.getNumProcessors();
        } else {
            d2 = this.endTime - this.startTime;
            if (d2 <= 0.0) {
                d2 = Analysis.getTotalTime();
            }
            d = this.validPEs.size();
        }
        this.scalePanel.setScales(d2, d);
        double d3 = this.scalePanel.toSlider(1.0 / d2);
        double d4 = this.scalePanel.toSlider(0.01);
        this.hor.setMin(d3);
        this.hor.setMax(d4);
        this.hor.setValue(d3);
        this.hor.setTicks(Math.floor(d3), 1.0);
        double d5 = this.scalePanel.toSlider(1.0 / d);
        double d6 = this.scalePanel.toSlider(1.0);
        this.ver.setMin(d5);
        this.ver.setMax(d6);
        this.ver.setValue(d5);
        this.ver.setTicks(Math.floor(d5), 1.0);
    }

    private void createMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Close"}, this));
        menuBar.add(Util.makeMenu("Modify", new Object[]{"Set Range"}, this));
        this.setMenuBar(menuBar);
    }

    void showDialog() {
        try {
            if (this.dialog == null) {
                this.dialog = new IntervalRangeDialog(this, "Select Range", false, false);
            } else {
                this.dialog.dispose();
                this.dialog = new IntervalRangeDialog(this, "Select Range", false, false);
            }
            int n = this.dialog.showDialog();
            if (n == 0) {
                this.setStlPanelData(0);
                this.stl.setData(this.validPEs, this.startTime, this.endTime);
                this.okorcancelled = true;
            }
            if (n == 1) {
                this.okorcancelled = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getLabel();
            if (string.equals("Close")) {
                this.dispose();
            }
            if (string.equals("Set Range")) {
                this.showDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getItemSelectable();
            if (jRadioButton == this.utilizationMode) {
                this.mode = 0;
            } else if (jRadioButton == this.epMode) {
                this.mode = 1;
            }
            this.stl.setMode(this.mode);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.hor) {
            this.setStatus("Click or drag to set the horizontal zoom");
        }
        if (component == this.ver) {
            this.setStatus("Click or drag to set the vertical zoom");
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setStatus("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }

    public void setAllData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
    }
}

