/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.count;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.gui.ProjectionsFileMgr;
import projections.gui.count.CounterTable;
import projections.gui.count.FrameCallBack;
import projections.gui.count.TableSorter;

public class CounterFrame
extends JFrame {
    TableSorter sorter_ = null;
    JTable jTable_ = null;
    CounterTable cTable_ = new CounterTable();
    ProjectionsFileMgr fileMgr_ = null;
    JProgressBar progress_ = new JProgressBar();
    JTabbedPane tabbedPane_ = new JTabbedPane();

    public CounterFrame() {
        super("Performance Counter Analysis");
        this.sorter_ = new TableSorter(this.cTable_);
        this.jTable_ = new JTable(this.sorter_);
        this.jTable_.setAutoResizeMode(0);
        this.sorter_.addMouseListenerToHeaderInTable(this.jTable_);
        this.jTable_.setColumnSelectionAllowed(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CounterFrame.this.cTable_.setSheet(CounterFrame.this.tabbedPane_.getSelectedIndex(), CounterFrame.this.jTable_);
                CounterFrame.this.sortByColumn(1);
            }
        });
        jPanel.add((Component)this.tabbedPane_, "North");
        jPanel.add((Component)new JScrollPane(this.jTable_), "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.progress_.setBorderPainted(true);
        jPanel2.add(this.progress_);
        JButton jButton = (JButton)jPanel2.add(new JButton("EP Proc Graph"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CounterFrame.this.jTable_.getSelectedRows();
                CounterFrame.this.cTable_.createGraph(CounterFrame.this.sorter_.mapRows(nArray));
            }
        });
        JButton jButton2 = (JButton)jPanel2.add(new JButton("Calc MFlops/s"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CounterFrame.this.cTable_.calcMFlops();
            }
        });
        JButton jButton3 = (JButton)jPanel2.add(new JButton("Calc Cache Miss"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CounterFrame.this.cTable_.calcCacheMiss();
            }
        });
        JButton jButton4 = (JButton)jPanel2.add(new JButton("Multi Run Analysis"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CounterFrame.this.jTable_.getSelectedRows();
                CounterFrame.this.cTable_.multiRunAnalysis(CounterFrame.this.sorter_.mapRows(nArray));
            }
        });
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.createMenu(), "North");
        super.getContentPane().add((Component)jPanel, "Center");
        super.getContentPane().add((Component)jPanel2, "South");
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)CounterFrame.this).setVisible(false);
            }
        });
    }

    public void setFileMgr(ProjectionsFileMgr projectionsFileMgr) {
        this.fileMgr_ = projectionsFileMgr;
    }

    public void loadFiles() throws Exception {
        if (this.fileMgr_ == null) {
            throw new Exception("ERROR in CounterFrame.loadFiles():\n      Must call setFileMgr before load files!\n");
        }
        FrameCallBack frameCallBack = new FrameCallBack(this);
        this.cTable_.loadFiles(this.fileMgr_, this.progress_, this.jTable_, frameCallBack);
    }

    public void sortByColumn(int n) {
        if (this.cTable_.getColumnCount() > n) {
            this.sorter_.sortByColumn(n, false);
        }
    }

    private JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = jMenuBar.add(new JMenu("File"));
        jMenu.setMnemonic('f');
        jMenu.setMenuLocation(0, 0);
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Open Simulation(s)"));
        jMenuItem.setMnemonic('o');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Quit"));
        jMenuItem.setMnemonic('q');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)CounterFrame.this).setVisible(false);
            }
        });
        return jMenuBar;
    }
}

