/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.count;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import projections.analysis.ParseTokenizer;
import projections.analysis.StsReader;
import projections.gui.CallBack;
import projections.gui.ProjectionsFileChooser;
import projections.gui.ProjectionsFileMgr;
import projections.gui.Wait;
import projections.gui.WaitButton;
import projections.gui.count.ColorHeader;
import projections.gui.count.Counter;
import projections.gui.count.CounterListTable;
import projections.gui.count.FrameCallBack;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;

public class CounterTable
extends AbstractTableModel {
    public FrameCallBack callback;
    public JTable table;
    private Vector sheet_ = null;
    private Sheet currSheet_ = null;
    private DefaultTableCellRenderer leftJustify_ = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer rightJustify_ = new DefaultTableCellRenderer();
    private DecimalFormat intFormat_ = new DecimalFormat();
    private DecimalFormat doubleFormat_ = new DecimalFormat();
    private Wait wait_ = new Wait(false);
    private boolean merge_;
    public Vector similarCollection;
    public JList[] list;
    public JTextArea[] names;
    public JDialog dialog;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$projections$gui$count$CounterTable$FormattedNumber;

    public CounterTable() {
        this.leftJustify_.setHorizontalAlignment(2);
        this.rightJustify_.setHorizontalAlignment(4);
        ((NumberFormat)this.intFormat_).setGroupingUsed(true);
        ((NumberFormat)this.doubleFormat_).setGroupingUsed(true);
        this.doubleFormat_.setMinimumFractionDigits(2);
        this.doubleFormat_.setMaximumFractionDigits(2);
    }

    public int getColumnCount() {
        if (this.currSheet_ != null) {
            return this.currSheet_.numCols;
        }
        return 0;
    }

    public int getRowCount() {
        if (this.currSheet_ != null) {
            return this.currSheet_.numRows;
        }
        return 0;
    }

    public String getColumnName(int n) {
        if (this.currSheet_ != null) {
            if (n == 0) {
                return "Entry Point";
            }
            int n2 = (n - 1) / 3;
            String string = this.currSheet_.counters[n2].counterCode;
            int n3 = (n - 1) % 3;
            switch (n3) {
                case 0: {
                    return "numCalled per proc (avg):" + string;
                }
                case 1: {
                    return "totTime(us) per proc (avg):" + string;
                }
                case 2: {
                    return string + ":" + "per EP (avg over all procs)";
                }
                case 3: {
                    return string + ":" + "stDev per EP (avg over all procs)";
                }
                case 4: {
                    return string + ":" + "maxCount over all procs";
                }
                case 5: {
                    return string + ":" + "minCount over all procs";
                }
            }
            return "ERROR";
        }
        return new Integer(n).toString();
    }

    public Class getColumnClass(int n) {
        if (this.currSheet_ != null) {
            if (n == 0) {
                return class$java$lang$String == null ? (class$java$lang$String = CounterTable.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$projections$gui$count$CounterTable$FormattedNumber == null ? (class$projections$gui$count$CounterTable$FormattedNumber = CounterTable.class$("projections.gui.count.CounterTable$FormattedNumber")) : class$projections$gui$count$CounterTable$FormattedNumber;
        }
        return class$java$lang$String == null ? (class$java$lang$String = CounterTable.class$("java.lang.String")) : class$java$lang$String;
    }

    public Object getValueAt(int n, int n2) {
        if (this.currSheet_ != null) {
            if (n2 == 0) {
                return this.currSheet_.tableRows[n].name;
            }
            int n3 = (n2 - 1) / 3;
            CounterSummary counterSummary = this.currSheet_.tableRows[n].summary[n3];
            int n4 = (n2 - 1) % 3;
            switch (n4) {
                case 0: {
                    return new FormattedNumber(counterSummary.numCalled, this.doubleFormat_);
                }
                case 1: {
                    return new FormattedNumber(counterSummary.totTime, this.doubleFormat_);
                }
                case 2: {
                    return new FormattedNumber(counterSummary.avgCount, this.doubleFormat_);
                }
                case 3: {
                    return new FormattedNumber(counterSummary.stdevCount, this.doubleFormat_);
                }
                case 4: {
                    return new FormattedNumber(counterSummary.maxCount, this.intFormat_);
                }
                case 5: {
                    return new FormattedNumber(counterSummary.minCount, this.intFormat_);
                }
            }
            return new Integer(-1);
        }
        return new Integer(-1);
    }

    public int getNumSims() {
        return this.sheet_.size();
    }

    public String getRunName(int n) {
        Sheet sheet = (Sheet)this.sheet_.elementAt(n);
        if (sheet.merged) {
            return sheet.sheetName;
        }
        return this.getRunName(sheet.sheetName);
    }

    public String getToolTip(int n) {
        try {
            Sheet sheet = (Sheet)this.sheet_.elementAt(n);
            return sheet.sheetName;
        }
        catch (Exception exception) {
            ProjectionsFileChooser.handleException(null, exception);
            return null;
        }
    }

    public void loadFiles(ProjectionsFileMgr projectionsFileMgr, JProgressBar jProgressBar, JTable jTable, CallBack callBack) throws IOException, Exception {
        this.callback = (FrameCallBack)callBack;
        this.loadFiles(projectionsFileMgr, jProgressBar, jTable);
    }

    public void loadFiles(ProjectionsFileMgr projectionsFileMgr, JProgressBar jProgressBar, JTable jTable) throws IOException, Exception {
        Object object;
        this.table = jTable;
        int n = projectionsFileMgr.getNumFiles();
        this.sheet_ = new Vector(projectionsFileMgr.getNumFiles());
        Object object2 = null;
        int n2 = 0;
        while (n2 < n) {
            object = new Sheet(projectionsFileMgr, n2);
            this.sheet_.addElement(object);
            if (n2 == 0) {
                object2 = object;
            } else if (!((Sheet)object).sameEPs((Sheet)object)) {
                throw new IOException("sts1: " + projectionsFileMgr.getStsFile(0) + "\n" + "sts2: " + projectionsFileMgr.getStsFile(n2) + "\n");
            }
            ++n2;
        }
        object = new Vector();
        boolean[] blArray = new boolean[n];
        n2 = 0;
        while (n2 < n) {
            blArray[n2] = false;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                blArray[n2] = true;
                Sheet sheet = (Sheet)this.sheet_.elementAt(n2);
                Vector<Sheet> vector = new Vector<Sheet>();
                vector.add(sheet);
                ((Vector)object).add(vector);
                int n3 = n2 + 1;
                while (n3 < n) {
                    Sheet sheet2;
                    if (!blArray[n3] && (sheet2 = (Sheet)this.sheet_.elementAt(n3)).similarTo(sheet)) {
                        vector.add(sheet2);
                        blArray[n3] = true;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (this.removeSingleEntries((Vector)object)) {
            this.userMergeSimilar((Vector)object);
        } else {
            this.sortSheets();
            this.setSheet(0, jTable);
            this.callback.callBack();
        }
    }

    public Component getCounterPanel(int n) {
        Sheet sheet = (Sheet)this.sheet_.elementAt(n);
        if (this.sheet_ == null || sheet == null) {
            return null;
        }
        CounterListTable counterListTable = new CounterListTable(sheet.counters);
        JTable jTable = new JTable(counterListTable);
        jTable.setRowSelectionAllowed(false);
        counterListTable.configure(jTable);
        JPanel jPanel = new JPanel();
        jPanel.add(new JScrollPane(jTable));
        Dimension dimension = jTable.getPreferredSize();
        int n2 = sheet.counters.length;
        dimension.height = Math.min(100, dimension.height / n2 * (n2 + 1));
        jPanel.setPreferredSize(dimension);
        return jPanel;
    }

    public void setSheet(int n, JTable jTable) {
        this.currSheet_ = (Sheet)this.sheet_.elementAt(n);
        super.fireTableStructureChanged();
        TableColumn tableColumn = null;
        tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.leftJustify_);
        tableColumn.setPreferredWidth(250);
        int n2 = 1;
        while (n2 < this.currSheet_.numCols) {
            tableColumn = jTable.getColumnModel().getColumn(n2);
            tableColumn.setCellRenderer(this.rightJustify_);
            tableColumn.setPreferredWidth(110);
            tableColumn.setHeaderRenderer(this.getCounterHeader(n2));
            ++n2;
        }
    }

    public void createGraph(int[] nArray) {
        if (nArray.length == 0) {
            System.out.println("ERROR there are no selected rows");
        } else if (this.currSheet_ == null) {
            System.out.println("NO DATA IN TABLE");
        } else {
            Object object;
            int n = 0;
            Sheet sheet = this.currSheet_;
            double[][] dArrayArray = new double[sheet.numProcs][];
            int n2 = 0;
            while (n2 < sheet.numProcs) {
                dArrayArray[n2] = new double[nArray.length];
                int n3 = 0;
                while (n3 < nArray.length) {
                    object = (DoubleCountData)sheet.data[n2].cResults[n].countData[4];
                    dArrayArray[n2][n3] = ((DoubleCountData)object).getValue(nArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            DataSource2D dataSource2D = new DataSource2D(this.currSheet_.sheetName, dArrayArray);
            object = new XAxisFixed("Processor", "#");
            YAxisAuto yAxisAuto = new YAxisAuto(this.currSheet_.counters[0].counterCode, "#", dataSource2D);
            Graph graph = new Graph();
            graph.setGraphType(5);
            graph.setData(dataSource2D, (XAxis)object, yAxisAuto);
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(graph);
            ((Component)jFrame).setSize(800, 640);
            ((Component)jFrame).setVisible(true);
        }
    }

    public void calcMFlops() {
        if (this.currSheet_ == null) {
            System.out.println("NO DATA IN TABLE");
        } else {
            Sheet sheet = this.currSheet_;
            boolean bl = false;
            int n = -1;
            int n2 = 0;
            while (n2 < sheet.counters.length && !bl) {
                if (sheet.counters[n2].counterCode.equals("GR_FLOPS")) {
                    bl = true;
                    n = n2;
                }
                ++n2;
            }
            if (!bl) {
                System.out.println("COULD NOT FIND FLOPS!!!");
                return;
            }
            Vector<Integer> vector = new Vector<Integer>();
            n2 = 0;
            while (n2 < sheet.tableRows.length - 1) {
                if (sheet.tableRows[n2].summary[n].numCalled > 0.0) {
                    vector.addElement(new Integer(n2));
                }
                ++n2;
            }
            int n3 = vector.size();
            int[] nArray = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                nArray[n2] = (Integer)vector.elementAt(n2);
                ++n2;
            }
            vector.removeAllElements();
            double[][] dArrayArray = new double[n3][];
            double d = 0.0;
            double d2 = 0.0;
            n2 = 0;
            while (n2 < n3) {
                CounterSummary counterSummary = sheet.tableRows[nArray[n2]].summary[n];
                dArrayArray[n2] = new double[2];
                dArrayArray[n2][0] = counterSummary.numCalled * counterSummary.avgCount * (double)sheet.numProcs / counterSummary.totTime * 1000000.0;
                d += dArrayArray[n2][0] * counterSummary.numCalled;
                d2 += counterSummary.numCalled;
                ++n2;
            }
            double d3 = d / d2;
            n2 = 0;
            while (n2 < n3) {
                dArrayArray[n2][1] = d3;
                ++n2;
            }
            String[] stringArray = new String[n3];
            n2 = 0;
            while (n2 < n3) {
                stringArray[n2] = new Integer(nArray[n2]).toString();
                ++n2;
            }
            DataSource2D dataSource2D = new DataSource2D(this.currSheet_.sheetName + ": Overall Flops/s = " + d3, dArrayArray);
            MultiRunXAxis multiRunXAxis = new MultiRunXAxis(stringArray);
            YAxisAuto yAxisAuto = new YAxisAuto("Performance", "Flops/s", dataSource2D);
            Graph graph = new Graph();
            graph.setGraphType(5);
            graph.setData(dataSource2D, multiRunXAxis, yAxisAuto);
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(graph);
            ((Component)jFrame).setSize(800, 640);
            ((Component)jFrame).setVisible(true);
        }
    }

    public void calcCacheMiss() {
        if (this.currSheet_ == null) {
            System.out.println("NO DATA IN TABLE");
        } else {
            Object object;
            Sheet sheet = this.currSheet_;
            boolean bl = false;
            int n = -1;
            boolean bl2 = false;
            int n2 = -1;
            boolean bl3 = false;
            int n3 = -1;
            boolean bl4 = false;
            int n4 = -1;
            boolean bl5 = false;
            int n5 = -1;
            int n6 = 0;
            while (n6 < sheet.counters.length) {
                object = sheet.counters[n6].counterCode;
                System.out.println("  Counter " + n6 + ": " + (String)object);
                if (((String)object).equals("LOAD")) {
                    bl = true;
                    n = n6;
                } else if (((String)object).equals("STORE")) {
                    bl2 = true;
                    n2 = n6;
                } else if (((String)object).equals("L1_DMISS")) {
                    bl3 = true;
                    n3 = n6;
                } else if (((String)object).equals("L2_DMISS")) {
                    bl4 = true;
                    n4 = n6;
                } else if (((String)object).equals("TLB_MISS")) {
                    bl5 = true;
                    n5 = n6;
                }
                ++n6;
            }
            if (!bl || !bl2) {
                System.out.println("COULD NOT FIND LOADS/STORES!!!");
                return;
            }
            System.out.println("indexL1 " + n3 + " indexL2 " + n4 + " indexTLB " + n5);
            object = new Vector();
            n6 = 0;
            while (n6 < sheet.tableRows.length - 1) {
                if (sheet.tableRows[n6].summary[n].numCalled > 0.0 && sheet.tableRows[n6].summary[n2].numCalled > 0.0) {
                    ((Vector)object).addElement(new Integer(n6));
                }
                ++n6;
            }
            int n7 = ((Vector)object).size();
            int[] nArray = new int[n7];
            n6 = 0;
            while (n6 < n7) {
                nArray[n6] = (Integer)((Vector)object).elementAt(n6);
                ++n6;
            }
            ((Vector)object).removeAllElements();
            int n8 = 0;
            int[] nArray2 = new int[3];
            if (bl3) {
                nArray2[n8] = n3;
                ++n8;
            }
            if (bl4) {
                nArray2[n8] = n4;
                ++n8;
            }
            if (bl5) {
                nArray2[n8] = n5;
                ++n8;
            }
            System.out.println("THERE ARE " + n8 + " SETS");
            double[][] dArrayArray = new double[n7][];
            n6 = 0;
            while (n6 < n7) {
                dArrayArray[n6] = new double[n8 * 2];
                ++n6;
            }
            n6 = 0;
            while (n6 < n8) {
                this.fillCacheData(dArrayArray, nArray, n, n2, nArray2[n6], n6);
                ++n6;
            }
            String[] stringArray = new String[n7];
            n6 = 0;
            while (n6 < n7) {
                stringArray[n6] = new Integer(nArray[n6]).toString();
                ++n6;
            }
            String string = this.currSheet_.sheetName + ":";
            n8 = 0;
            if (bl3) {
                string = string.concat(" L1 Miss " + dArrayArray[0][n8 * 2 + 1]);
                ++n8;
            }
            if (bl4) {
                string = string.concat(" L2 Miss " + dArrayArray[0][n8 * 2 + 1]);
                ++n8;
            }
            if (bl5) {
                string = string.concat(" TLB Miss " + dArrayArray[0][n8 * 2 + 1]);
                ++n8;
            }
            DataSource2D dataSource2D = new DataSource2D(string, dArrayArray);
            MultiRunXAxis multiRunXAxis = new MultiRunXAxis(stringArray);
            YAxisAuto yAxisAuto = new YAxisAuto("Cache Miss Rate", "%", dataSource2D);
            Graph graph = new Graph();
            graph.setGraphType(5);
            graph.setData(dataSource2D, multiRunXAxis, yAxisAuto);
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(graph);
            ((Component)jFrame).setSize(800, 640);
            ((Component)jFrame).setVisible(true);
        }
    }

    public void multiRunAnalysis(int[] nArray) {
        if (nArray.length == 0) {
            System.out.println("ERROR there are no selected rows");
        } else {
            int n;
            Object object;
            int[] nArray2 = new int[this.sheet_.size()];
            int n2 = 0;
            while (n2 < nArray2.length) {
                object = (Sheet)this.sheet_.elementAt(n2);
                boolean bl = false;
                n = 0;
                while (n < object.counters.length && !bl) {
                    if (object.counters[n].counterCode.equals("GR_FLOPS")) {
                        bl = true;
                        nArray2[n2] = n;
                    }
                    ++n;
                }
                if (!bl) {
                    System.out.println("COULD NOT FIND FLOPS!!!");
                    return;
                }
                ++n2;
            }
            object = new double[this.sheet_.size()][];
            n2 = 0;
            while (n2 < this.sheet_.size()) {
                object[n2] = new double[nArray.length];
                Sheet sheet = (Sheet)this.sheet_.elementAt(n2);
                n = 0;
                while (n < nArray.length) {
                    object[n2][n] = sheet.tableRows[nArray[n]].summary[nArray2[n2]].avgCount;
                    ++n;
                }
                ++n2;
            }
            String[] stringArray = new String[this.sheet_.size()];
            n2 = 0;
            while (n2 < this.sheet_.size()) {
                stringArray[n2] = ((Sheet)this.sheet_.elementAt((int)n2)).sheetName;
                ++n2;
            }
            DataSource2D dataSource2D = new DataSource2D("EPs Across Procs", (double[][])object);
            MultiRunXAxis multiRunXAxis = new MultiRunXAxis(stringArray);
            YAxisAuto yAxisAuto = new YAxisAuto("GR_FLOPS", "#", dataSource2D);
            Graph graph = new Graph();
            graph.setGraphType(5);
            graph.setData(dataSource2D, multiRunXAxis, yAxisAuto);
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(graph);
            ((Component)jFrame).setSize(800, 640);
            ((Component)jFrame).setVisible(true);
        }
    }

    private void fillCacheData(double[][] dArray, int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        Sheet sheet = this.currSheet_;
        int n6 = 0;
        while (n6 < nArray.length) {
            double d;
            n5 = nArray[n6];
            CounterSummary counterSummary = sheet.tableRows[n5].summary[n];
            CounterSummary counterSummary2 = sheet.tableRows[n5].summary[n2];
            CounterSummary counterSummary3 = sheet.tableRows[n5].summary[n3];
            double d2 = counterSummary.numCalled * counterSummary.avgCount / counterSummary.totTime;
            double d3 = counterSummary2.numCalled * counterSummary2.avgCount / counterSummary2.totTime;
            double d4 = counterSummary3.numCalled * counterSummary3.avgCount / counterSummary3.totTime;
            dArray[n6][n4 * 2] = d = 100.0 * d4 / (d2 + d3);
            ++n6;
        }
        double d = 0.0;
        double d5 = 0.0;
        n6 = 0;
        while (n6 < nArray.length) {
            n5 = nArray[n6];
            CounterSummary counterSummary = sheet.tableRows[n5].summary[n3];
            d += counterSummary.totTime * dArray[n6][n4 * 2];
            d5 += counterSummary.totTime;
            ++n6;
        }
        double d6 = d / d5;
        System.out.println("CACHE MISS " + d6);
        n6 = 0;
        while (n6 < nArray.length) {
            dArray[n6][n4 * 2 + 1] = d6;
            ++n6;
        }
    }

    private void sortSheets() {
        int n = this.sheet_.size() - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                Sheet sheet = (Sheet)this.sheet_.elementAt(n2);
                Sheet sheet2 = (Sheet)this.sheet_.elementAt(n2 + 1);
                if (sheet.data.length > sheet2.data.length) {
                    this.sheet_.setElementAt(sheet2, n2);
                    this.sheet_.setElementAt(sheet, n2 + 1);
                }
                ++n2;
            }
            --n;
        }
    }

    private void userMergeSimilar(Vector vector) throws Exception {
        int n = vector.size();
        this.similarCollection = vector;
        this.list = new JList[n];
        this.names = new JTextArea[n];
        JPanel jPanel = this.createListPanel(vector, this.list, this.names);
        ((Component)this.callback.f).setVisible(false);
        JDialog jDialog = this.createMergeDialog(jPanel, n);
        ((Component)jDialog).setVisible(true);
    }

    private JPanel createListPanel(Vector vector, JList[] jListArray, JTextArea[] jTextAreaArray) {
        Sheet sheet = null;
        Vector vector2 = null;
        int n = vector.size();
        JPanel jPanel = new JPanel(new GridLayout(n, 1));
        int n2 = 0;
        while (n2 < n) {
            vector2 = (Vector)vector.elementAt(n2);
            String[] stringArray = new String[vector2.size()];
            int[] nArray = new int[vector2.size()];
            JPanel jPanel2 = new JPanel(new BorderLayout());
            int n3 = 0;
            while (n3 < vector2.size()) {
                sheet = (Sheet)vector2.elementAt(n3);
                nArray[n3] = n3;
                stringArray[n3] = sheet.sheetName;
                ++n3;
            }
            jListArray[n2] = new JList<String>(stringArray);
            jListArray[n2].setSelectedIndices(nArray);
            jTextAreaArray[n2] = new JTextArea(new Integer(sheet.numProcs).toString());
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("numPE=" + sheet.numProcs + ", group name=");
            jLabel.setPreferredSize(jLabel.getMinimumSize());
            jPanel3.add((Component)jLabel, "West");
            jPanel3.add((Component)jTextAreaArray[n2], "Center");
            jPanel2.add((Component)jPanel3, "North");
            jPanel2.add((Component)new JScrollPane(jListArray[n2]), "Center");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
            jPanel.add(jPanel2);
            ++n2;
        }
        return jPanel;
    }

    private JDialog createMergeDialog(JPanel jPanel, int n) {
        JTextArea jTextArea = new JTextArea("Projections has found several performance analysis runs\n  that were created using the same number of processors.\nShould runs on the same number of processors be merged into\n  one analysis window?  (Recommended to compare several counters\n  as an effective single run.)\nSelect the runs to be merged and change the group name (the\n  name that the merged run will be labeled) if desired.\nPress \"Merge Selected\" when ready, or press\n  \"Don't Merge Any\" if desired.\nUse \"Control-Click\" to deselect single selections.\n\nNOTE: To make more than one group out of a collection,\n  simply make a group out of some of its runs, and this\n  dialog will pop-up again allowing further merges.\n");
        jTextArea.setEditable(false);
        this.dialog = new JDialog();
        this.dialog.setTitle("Projections: Performance Counter Analysis (Merge Similar Files)");
        ((Component)this.dialog).setSize(600, 240 + 125 * n);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)jTextArea, "North");
        this.dialog.getContentPane().add((Component)jPanel, "Center");
        WaitButton waitButton = new WaitButton("Don't Merge Any", this.wait_);
        WaitButton waitButton2 = new WaitButton("Merge Selected", this.wait_);
        waitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CounterTable.this.merge_ = false;
                CounterTable.this.sortSheets();
                CounterTable.this.setSheet(0, CounterTable.this.table);
                CounterTable.this.callback.callBack();
                ((Component)CounterTable.this.dialog).setVisible(false);
            }
        });
        waitButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CounterTable.this.merge_ = true;
                try {
                    if (!CounterTable.this.merge_) {
                        return;
                    }
                    System.out.println("Merging files");
                    int n = 0;
                    while (n < CounterTable.this.similarCollection.size()) {
                        Vector vector = (Vector)CounterTable.this.similarCollection.elementAt(n);
                        int[] nArray = CounterTable.this.list[n].getSelectedIndices();
                        if (nArray.length == 0) {
                            CounterTable.this.similarCollection.removeElement(vector);
                            continue;
                        }
                        Sheet[] sheetArray = new Sheet[nArray.length];
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            Sheet sheet;
                            sheetArray[n2] = sheet = (Sheet)vector.elementAt(nArray[n2]);
                            CounterTable.this.sheet_.removeElement(sheet);
                            ++n2;
                        }
                        n2 = 0;
                        while (n2 < sheetArray.length) {
                            vector.removeElement(sheetArray[n2]);
                            ++n2;
                        }
                        CounterTable.this.sheet_.add(new Sheet(sheetArray, CounterTable.this.names[n].getText()));
                        ++n;
                    }
                    if (CounterTable.this.removeSingleEntries(CounterTable.this.similarCollection)) {
                        CounterTable.this.userMergeSimilar(CounterTable.this.similarCollection);
                    }
                    CounterTable.this.sortSheets();
                    CounterTable.this.setSheet(0, CounterTable.this.table);
                    CounterTable.this.callback.callBack();
                    ((Component)CounterTable.this.dialog).setVisible(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        Panel panel = new Panel(new FlowLayout());
        panel.add((Component)waitButton, "West");
        panel.add((Component)waitButton2, "East");
        this.dialog.getContentPane().add((Component)panel, "South");
        return this.dialog;
    }

    private boolean removeSingleEntries(Vector vector) {
        int n = 0;
        boolean bl = false;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            if (vector2.size() <= 1) {
                vector.removeElement(vector2);
                continue;
            }
            ++n;
            bl = true;
        }
        return bl;
    }

    private String getRunName(String string) {
        try {
            File file = new File(string);
            String string2 = file.getParent();
            File file2 = new File(string2);
            String string3 = file2.getParent();
            String string4 = "[" + string2.substring(string3.length() + 1, string2.length()) + "]" + this.getStartString(file.getName());
            return string4;
        }
        catch (Exception exception) {
            ProjectionsFileChooser.handleException(null, exception);
            return null;
        }
    }

    private String getStartString(String string) throws IOException {
        int n = string.lastIndexOf(".");
        int n2 = string.lastIndexOf(".", n - 1);
        if (!string.endsWith(".count") && !string.endsWith(".sts")) {
            throw new IOException("Expect count files to end with .count or .sts:\n" + string);
        }
        String string2 = string.substring(0, n2);
        return string2;
    }

    private ColorHeader getCounterHeader(int n) {
        if (this.currSheet_ != null) {
            if (n == 0) {
                return new ColorHeader(null, null);
            }
            int n2 = (n - 1) / 3;
            int n3 = (n - 1) % 3;
            String string = null;
            switch (n3) {
                case 0: {
                    string = "numCalled per proc (avg)";
                    break;
                }
                case 1: {
                    string = "totTime(us) per proc (avg)";
                    break;
                }
                case 2: {
                    string = "per EP (avg over all procs)";
                    break;
                }
                case 3: {
                    string = "stDev per EP (avg over all procs)";
                    break;
                }
                case 4: {
                    string = "maxCount over all procs";
                    break;
                }
                case 5: {
                    string = "minCount over all procs";
                    break;
                }
                default: {
                    string = "ERROR";
                }
            }
            return new ColorHeader(this.currSheet_.counters[n2].color, this.currSheet_.counters[n2].counterCode + ": " + string);
        }
        return new ColorHeader(null, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FormattedNumber
    extends Number {
        double number;
        NumberFormat format;

        public FormattedNumber(double d, NumberFormat numberFormat) {
            this.number = d;
            this.format = numberFormat;
        }

        public byte byteValue() {
            return (byte)this.number;
        }

        public double doubleValue() {
            return this.number;
        }

        public float floatValue() {
            return (float)this.number;
        }

        public int intValue() {
            return (int)this.number;
        }

        public long longValue() {
            return (long)this.number;
        }

        public short shortValue() {
            return (short)this.number;
        }

        public String toString() {
            return this.format.format(this.number);
        }
    }

    private class IntCountData
    extends CountData {
        public int[] values = null;

        public IntCountData(String string, String string2, int n, int n2) throws IOException {
            super(n);
            this.values = new int[n2];
            this.readLine(string, string2, n2);
        }

        public void setValue(int n, double d) {
            this.values[n] = (int)d;
        }

        public double getValue(int n) {
            return this.values[n];
        }
    }

    private class DoubleCountData
    extends CountData {
        public double[] values = null;

        public DoubleCountData(String string, String string2, int n, int n2) throws IOException {
            super(n);
            this.values = new double[n2];
            this.readLine(string, string2, n2);
        }

        public void setValue(int n, double d) {
            this.values[n] = d;
        }

        public double getValue(int n) {
            if (n < this.values.length) {
                return this.values[n];
            }
            return 0.0;
        }
    }

    private abstract class CountData {
        public static final int NUM_CALLED = 0;
        public static final int TOTAL_TIME = 1;
        public static final int MAX_VALUE = 2;
        public static final int MIN_VALUE = 3;
        public static final int AVG_COUNT = 4;
        public int type = -1;

        public CountData(int n) {
            this.type = n;
        }

        public abstract void setValue(int var1, double var2);

        public abstract double getValue(int var1);

        public void readLine(String string, String string2, int n) throws IOException {
            String string3 = "ERROR in CountData.readLine parser for line:\n  " + string + "\n";
            try {
                ParseTokenizer parseTokenizer = new ParseTokenizer(new StringReader(string));
                parseTokenizer.parseNumbers();
                parseTokenizer.whitespaceChars(91, 91);
                parseTokenizer.whitespaceChars(93, 93);
                parseTokenizer.wordChars(95, 95);
                parseTokenizer.wordChars(40, 40);
                parseTokenizer.wordChars(41, 41);
                parseTokenizer.checkNextString(string2);
                String string4 = null;
                switch (this.type) {
                    case 0: {
                        string4 = "num_called";
                        break;
                    }
                    case 1: {
                        string4 = "total_time(us)";
                        break;
                    }
                    case 2: {
                        string4 = "max_value";
                        break;
                    }
                    case 3: {
                        string4 = "min_value";
                        break;
                    }
                    case 4: {
                        string4 = "avg_count";
                        break;
                    }
                    default: {
                        string4 = "UNKNOWN TYPE";
                    }
                }
                parseTokenizer.checkNextString(string4);
                int n2 = 0;
                while (n2 < n) {
                    this.setValue(n2, parseTokenizer.nextNumber("value"));
                    ++n2;
                }
                if (parseTokenizer.nextToken() != -1) {
                    throw new IOException(string3 + "expected EOF but not found");
                }
            }
            catch (Exception exception) {
                throw new IOException(string3 + "\n" + exception.getMessage());
            }
        }
    }

    private class CounterResults {
        public Counter counter = null;
        public CountData[] countData = null;

        public CounterResults(File file, BufferedReader bufferedReader, int n, Counter[] counterArray, int n2, boolean bl, String string) throws IOException {
            String string2 = "File: " + file.getCanonicalPath() + "\n ERROR in CounterResults(): ";
            try {
                String string3 = bufferedReader.readLine();
                ParseTokenizer parseTokenizer = new ParseTokenizer(new StringReader(string3));
                parseTokenizer.parseNumbers();
                parseTokenizer.whitespaceChars(91, 91);
                parseTokenizer.whitespaceChars(93, 93);
                parseTokenizer.wordChars(95, 95);
                String string4 = parseTokenizer.nextString("counterCode");
                int n3 = string3.indexOf(123);
                int n4 = string3.indexOf(125);
                if (n3 == -1 || n4 == -1) {
                    throw new IOException(string2 + " counter " + string4 + " require { and } on first line for description\n" + string3);
                }
                String string5 = string3.substring(n3 + 1, n4);
                if (bl) {
                    counterArray[n2] = new Counter(string4, string5, string);
                } else if (!counterArray[n2].counterCode.equals(string4) || !counterArray[n2].description.equals(string5)) {
                    throw new IOException(string2 + "expected " + counterArray[n2].counterCode + " {" + counterArray[n2].description + "}\ngot " + string4 + " {" + string5 + "}");
                }
                this.counter = counterArray[n2];
                this.countData = new CountData[5];
                this.countData[0] = new IntCountData(bufferedReader.readLine(), string4, 0, n);
                this.countData[4] = new DoubleCountData(bufferedReader.readLine(), string4, 4, n);
                this.countData[1] = new IntCountData(bufferedReader.readLine(), string4, 1, n);
            }
            catch (Exception exception) {
                throw new IOException(string2 + "\n" + exception.getMessage());
            }
        }
    }

    private class LogData {
        public int procNum;
        public int procTotal;
        public int numEPs;
        public CounterResults[] cResults = null;

        public LogData(File file, int n, Sheet sheet, boolean bl, String string) throws IOException {
            String string2 = "File: " + file.getPath() + "\n  ERROR in LogData(): ";
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getCanonicalPath()));
                String string3 = bufferedReader.readLine();
                ParseTokenizer parseTokenizer = new ParseTokenizer(new StringReader(string3));
                parseTokenizer.parseNumbers();
                parseTokenizer.whitespaceChars(58, 58);
                parseTokenizer.whitespaceChars(47, 47);
                parseTokenizer.nextString("ver");
                double d = parseTokenizer.nextNumber(string2 + "version");
                this.procNum = (int)parseTokenizer.nextNumber(string2 + "procNum");
                if (this.procNum != n) {
                    throw new IOException(string2 + "read index " + this.procNum + " expected " + n);
                }
                this.procTotal = (int)parseTokenizer.nextNumber(string2 + "procTotal");
                parseTokenizer.nextString("ep");
                this.numEPs = (int)parseTokenizer.nextNumber(string2 + "numEPs");
                parseTokenizer.nextString("counters");
                int n2 = (int)parseTokenizer.nextNumber(string2 + "numCounters");
                if (bl) {
                    sheet.counters = new Counter[n2];
                } else if (sheet.counters.length != n2) {
                    throw new IOException(string2 + "expected " + this.cResults.length + " counters but got " + n2);
                }
                if (parseTokenizer.nextToken() != -1) {
                    throw new IOException(string2 + "expected EOF but not found");
                }
                this.cResults = new CounterResults[n2];
                int n3 = 0;
                while (n3 < n2) {
                    this.cResults[n3] = new CounterResults(file, bufferedReader, this.numEPs, sheet.counters, n3, bl, string);
                    ++n3;
                }
            }
            catch (Exception exception) {
                throw new IOException(string2 + "\n" + exception.getMessage());
            }
        }

        public LogData(int n, int n2, int n3, int n4) {
            this.procNum = n;
            this.procTotal = n2;
            this.numEPs = n3;
            this.cResults = new CounterResults[n4];
        }
    }

    private class CounterSummary {
        public double numCalled = 0.0;
        public double totTime = 0.0;
        public double avgCount = 0.0;
        public double stdevCount = 0.0;
        public int maxCount = Integer.MIN_VALUE;
        public int minCount = Integer.MAX_VALUE;
    }

    private class EPValue {
        public static final int NUM_VALUES_PER_COUNTER = 3;
        public static final int LONG_NUM_VALUES_PER_COUNTER = 6;
        public static final int AVG_CALLED = 0;
        public static final int AVG_TIME = 1;
        public static final int AVG_CVAL = 2;
        public static final int AVG_CSTDEV = 3;
        public static final int MAX_CVAL = 4;
        public static final int MIN_CVAL = 5;
        public static final String AVG_CALLED_STR = "numCalled per proc (avg)";
        public static final String AVG_TIME_STR = "totTime(us) per proc (avg)";
        public static final String AVG_CVAL_STR = "per EP (avg over all procs)";
        public static final String AVG_CSTDEV_STR = "stDev per EP (avg over all procs)";
        public static final String MAX_CVAL_STR = "maxCount over all procs";
        public static final String MIN_CVAL_STR = "minCount over all procs";
        public String name = null;
        public CounterSummary[] summary = null;

        public EPValue(String string, int n) {
            this.name = string;
            this.summary = new CounterSummary[n];
            int n2 = 0;
            while (n2 < n) {
                this.summary[n2] = new CounterSummary();
                ++n2;
            }
        }

        public EPValue(String string, int n, LogData[] logDataArray, int n2, boolean bl) {
            this.name = bl ? '[' + new Integer(n).toString() + "] " + string : string;
            this.summary = new CounterSummary[n2];
            int n3 = 0;
            while (n3 < this.summary.length) {
                this.summary[n3] = new CounterSummary();
                ++n3;
            }
            int n4 = logDataArray[0].procTotal;
            int n5 = 0;
            while (n5 < this.summary.length) {
                CounterSummary counterSummary = this.summary[n5];
                n3 = 0;
                while (n3 < n4) {
                    CountData[] countDataArray = logDataArray[n3].cResults[n5].countData;
                    counterSummary.numCalled += countDataArray[0].getValue(n);
                    counterSummary.totTime += countDataArray[1].getValue(n);
                    double d = countDataArray[4].getValue(n);
                    counterSummary.avgCount += d;
                    counterSummary.maxCount = Math.max(counterSummary.maxCount, (int)d);
                    counterSummary.minCount = Math.min(counterSummary.minCount, (int)d);
                    ++n3;
                }
                counterSummary.numCalled /= (double)n4;
                counterSummary.totTime /= (double)n4;
                counterSummary.avgCount /= (double)n4;
                ++n5;
            }
        }
    }

    private class Sheet {
        public int numCols = 0;
        public int numRows = 0;
        public int numProcs = 0;
        public String sheetName = null;
        public Counter[] counters = null;
        public EPValue[] tableRows = null;
        public LogData[] data = null;
        public boolean merged = false;

        public Sheet(ProjectionsFileMgr projectionsFileMgr, int n) throws IOException {
            this.sheetName = projectionsFileMgr.getStsFile(n).getCanonicalPath();
            StsReader stsReader = new StsReader(projectionsFileMgr.getStsFile(n).getCanonicalPath());
            this.numProcs = stsReader.getProcessorCount();
            File[] fileArray = projectionsFileMgr.getLogFiles(n);
            if (this.numProcs != fileArray.length) {
                throw new IOException("Sheet() " + this.sheetName + " expect numProcs " + fileArray.length + " got " + this.numProcs);
            }
            this.data = new LogData[fileArray.length];
            boolean bl = true;
            int n2 = -1;
            int n3 = 0;
            while (n3 < fileArray.length) {
                int n4 = this.getProcIndex(fileArray[n3], n3);
                this.data[n4] = new LogData(fileArray[n3], n3, this, bl, this.sheetName);
                if (bl) {
                    n2 = this.data[n4].numEPs;
                } else if (n2 != this.data[n4].numEPs) {
                    throw new IOException("Sheet() " + this.sheetName + " expect numEPs " + n2 + " proc " + n4 + " has " + this.data[n4].numEPs);
                }
                bl = false;
                ++n3;
            }
            this.tableRows = new EPValue[stsReader.getEntryCount() + 1];
            this.numRows = stsReader.getEntryCount() + 1;
            n3 = 0;
            while (n3 < this.numRows - 1) {
                this.tableRows[n3] = new EPValue(stsReader.getEntryNames()[n3][0], n3, this.data, this.counters.length, true);
                ++n3;
            }
            this.calcEPValueTotals();
        }

        public Sheet(Sheet[] sheetArray, String string) throws Exception {
            int n;
            this.merged = true;
            if (sheetArray.length == 1) {
                this.numCols = sheetArray[0].numCols;
                this.numRows = sheetArray[0].numRows;
                this.numProcs = sheetArray[0].numProcs;
                this.counters = sheetArray[0].counters;
                this.data = sheetArray[0].data;
                this.tableRows = sheetArray[0].tableRows;
                this.sheetName = string;
                return;
            }
            this.numCols = 1;
            this.numRows = sheetArray[0].numRows;
            this.numProcs = sheetArray[0].numProcs;
            this.sheetName = string;
            int n2 = 0;
            int n3 = 0;
            while (n3 < sheetArray.length) {
                n2 += sheetArray[n3].counters.length;
                if (sheetArray[n3].numRows != this.numRows || sheetArray[n3].numProcs != this.numProcs) {
                    throw new Exception("Sheet(Sheet[] sheets) expect " + this.numRows + " rows " + this.numProcs + " procs\n" + "  [" + sheetArray[n3].sheetName + "] has " + sheetArray[n3].numRows + " rows " + sheetArray[n3].numProcs + " procs\n");
                }
                ++n3;
            }
            this.counters = new Counter[n2];
            this.tableRows = new EPValue[this.numRows];
            this.data = new LogData[this.numProcs];
            n3 = 0;
            while (n3 < this.data.length) {
                this.data[n3] = new LogData(n3, this.data.length, sheetArray[0].data[0].numEPs, n2);
                ++n3;
            }
            int n4 = 0;
            n3 = 0;
            while (n3 < sheetArray.length) {
                n = 0;
                while (n < sheetArray[n3].counters.length) {
                    this.counters[n4] = sheetArray[n3].counters[n];
                    ++n4;
                    ++n;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.numProcs) {
                n4 = 0;
                n = 0;
                while (n < sheetArray.length) {
                    int n5 = 0;
                    while (n5 < sheetArray[n].counters.length) {
                        this.data[n3].cResults[n4] = sheetArray[n].data[n3].cResults[n5];
                        ++n4;
                        ++n5;
                    }
                    ++n;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.numRows - 1) {
                this.tableRows[n3] = new EPValue(sheetArray[0].tableRows[n3].name, n3, this.data, this.counters.length, false);
                ++n3;
            }
            this.calcEPValueTotals();
        }

        public boolean similarTo(Sheet sheet) {
            if (sheet.numRows != this.numRows) {
                return false;
            }
            if (sheet.numProcs != this.numProcs) {
                return false;
            }
            return this.sameEPs(sheet);
        }

        public boolean sameEPs(Sheet sheet) {
            if (sheet.tableRows.length != this.tableRows.length) {
                return false;
            }
            int n = 0;
            while (n < this.tableRows.length) {
                if (!sheet.tableRows[n].name.equals(this.tableRows[n].name)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private void calcEPValueTotals() {
            this.numCols = 1 + this.counters.length * 3;
            int n = this.numRows - 1;
            this.tableRows[n] = new EPValue("ALL EPs", this.counters.length);
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < this.counters.length) {
                    this.tableRows[n].summary[n3].numCalled += this.tableRows[n2].summary[n3].numCalled;
                    this.tableRows[n].summary[n3].totTime += this.tableRows[n2].summary[n3].totTime;
                    this.tableRows[n].summary[n3].avgCount += this.tableRows[n2].summary[n3].avgCount * this.tableRows[n2].summary[n3].numCalled;
                    ++n3;
                }
                ++n2;
            }
        }

        private int getProcIndex(File file, int n) throws IOException {
            String string = file.getName();
            int n2 = string.lastIndexOf(".");
            int n3 = string.lastIndexOf(".", n2 - 1);
            if (!string.endsWith(".count")) {
                throw new IOException("Expect count files to end with .count:\n" + file.getCanonicalPath());
            }
            String string2 = string.substring(n3 + 1, n2);
            Integer n4 = new Integer(string2);
            return n4;
        }
    }
}

