/*
  Applet that repeatedly requests a CCS "ping"
*/
import java.io.IOException;
import CcsServer;

public class JavaClient
{
//A little stub main:
	public static void main(String args[]) {
		if (args.length!=2) {
			System.out.println("Usage: demo <ccs server> <ccs port>\n");
			System.exit(1);
		}
		new JavaClient(args[0],Integer.parseInt(args[1]));
	}
	
	public long echoTime(CcsServer ccs,int len) throws IOException {
		long start=System.currentTimeMillis();
		String lenStr=len+" ";
		CcsServer.Request req=ccs.sendRequest("rttTest",0,lenStr.getBytes());
		byte[] resp=ccs.recvResponse(req);
		long end=System.currentTimeMillis();
		if (resp.length!=len) {
			System.out.println("Response got truncated to "+resp.length+" bytes!");
		}
		return end-start;
	}

	public JavaClient(String host,int port) {
		try {
			System.out.println("Connecting to server");
			CcsServer ccs=new CcsServer(host,port);
			System.out.println("Sending request");
			long len;
			len=echoTime(ccs,10);
			System.out.println("10-byte request took "+len+" ms");
			len=echoTime(ccs,1024*1024);
			System.out.println("1-meg request took "+len+" ms");
		}
		catch (IOException e) {
			e.printStackTrace();
		}
	}
}
