#include <stdio.h>
#include "ckcallback-ccs.h"
#include "charmserver.decl.h"

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    int nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running server on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    
    CProxy_Responder arr = CProxy_Responder::ckNew(nElements);

    //Register our CCS handler to call array element 2
    CcsRegisterHandler("rttTest",CkCallback(CkIndex_Responder::ccs_reflect(0),arr[2]));
  };
};

/*array [1D]*/
class Responder : public CBase_Responder
{
  int respMax;
  char *respBuf;
public:
  Responder()
  {
    CkPrintf("Responder %d created\n",thisIndex);
    respMax=10*1024*1024;
    respBuf=(char *)malloc(respMax);
  }
  Responder(CkMigrateMessage *m) {}
  
  void ccs_reflect(CkCcsRequestMsg *msg)
  {
    int len=atoi((char *)msg->data); //Parse length out of request data
    if (len>respMax) len=respMax;
    if (len<0) len=0;
    for (int i=0;i<len;i++) respBuf[i]=(char)i; //Fill our response buffer
    CcsSendDelayedReply(msg->reply,len,respBuf); //Send it off
    delete msg;
  }
};

#include "charmserver.def.h"
