/*
Local openGL utility routines.

Orion Sky Lawlor, olawlor@acm.org, 8/13/2002
*/
#include "glutil.h"
#include <stdio.h>
#include <stdlib.h>


// Check GL for errors after the last command
void GLcheck(const char *where) {
	GLenum e=glGetError();
	if (e==GL_NO_ERROR) return;
	const GLubyte *errString = gluErrorString(e);
	fprintf (stderr, "FATAL OpenGL Error in %s: %s\n", where, errString);
	abort();
}

/*
Bind a (wid x ht) RGBA image to an OpenGL texture object
*/

//Bind an OpenGL texture for these pixels
//  Pixels are copied out, and can be deleted after the call.
GLtexture::GLtexture(const GLubyte *imagePixels, int wid,int ht,
	int srcFormat, int destFormat,
	int texWrap,int texMode)
{
	texName=0;
	glGenTextures(1, &texName);
	glBindTexture(GL_TEXTURE_2D, texName);
	
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, texMode);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, texWrap); 
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, texWrap); 
	gluBuild2DMipmaps (GL_TEXTURE_2D, srcFormat, wid,ht, destFormat,
		       GL_UNSIGNED_BYTE,imagePixels);
	
	GLcheck("after texture download");
}

//Reclaim the texture memory used by this object
GLtexture::~GLtexture() {
	glDeleteTextures(1,&texName);
}

//Bind this texture into the current environment
void GLtexture::bind(void) const {
	glBindTexture(GL_TEXTURE_2D, texName);
}


/*Draw an OpenGL texture in a quadrilateral*/
void GLtextureQuad(const GLtexture &tex,
	const CkVector3d &tl,const CkVector3d &tr,
	const CkVector3d &bl,const CkVector3d &br,
	GLtexture_t type)
{
	tex.bind();
	glEnable(GL_TEXTURE_2D);
	
	switch(type) {
	case GLtexture_nearest:
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		break;
	case GLtexture_linear:
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		break;
	case GLtexture_mipmap:
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
		break;
	};
	
	glBegin (GL_QUAD_STRIP);
	glTexCoord2f(0,0); glVertex3d(bl.x, bl.y, bl.z); 
	glTexCoord2f(1,0); glVertex3d(br.x, br.y, br.z); 
	glTexCoord2f(0,1); glVertex3d(tl.x, tl.y, tl.z); 
	glTexCoord2f(1,1); glVertex3d(tr.x, tr.y, tr.z); 
	glEnd();
}

/*Draw a line between these two points*/
void GLline(const CkVector3d &s,const CkVector3d &e) {
	glDisable(GL_TEXTURE_2D);
	glBegin (GL_LINES);
	// glColor3f(1,1,1);
	glVertex3d(s.x, s.y, s.z); 
	glVertex3d(e.x, e.y, e.z); 
	glEnd();
}



