/*
Broilerplate GLUT/OpenGL main routine.

Orion Sky Lawlor, olawlor@acm.org, 8/13/2002
*/
#include <GL/glut.h>
#include "glutil.h"
#include <stdio.h>
#include <stdlib.h>
#include "math.h"
#include "glutmain.h"

#define GLUTCALLBACK extern "C"

// Default implementation of all guiController events: just ignore it
void guiController::idle(void) {} //Went idle
void guiController::done(void) {} //Exited
void guiController::reshape(int wid,int ht) {}
void guiController::mouseHover(int x,int y) {}
void guiController::mouseDown(int button,int x,int y) {}
void guiController::mouseDrag(int x,int y) {}
void guiController::mouseUp(int button,int x,int y) {}
void guiController::handleEvent(uiEvent_t uiCode) {}

static guiController *glutCtl=NULL;

static int isDown=0; //Mouse is currently pressed
static int glutWid=0,glutHt=0; //Size of window


GLUTCALLBACK void motionFn(int x, int y)
{
	y=glutHt-y; //Flip y around so it matches OpenGL coords.
	if (!isDown) glutCtl->mouseHover(x,y);
	else glutCtl->mouseDrag(x,y);
}

GLUTCALLBACK void mouseFn(int button, int state, int x, int y)
{
	y=glutHt-y; //Flip y around so it matches OpenGL coords.
	if (state==GLUT_DOWN) {
		isDown=1;
		glutCtl->mouseDown(button,x,y);
	}
	if (state==GLUT_UP) {
		glutCtl->mouseDrag(x,y);
		glutCtl->mouseUp(button,x,y);
		isDown=0;
	}
}

/*  Initialize alpha blending function.
 */
static int doAlpha=1; /*Use alpha blending?*/
static int alphaSum=0; /*Alpha'd shapes never darken*/
static int smoothShade=0; /*Use gauraud shading*/
static int replace=0; /*Don't use vertex colors*/

static void init(void)
{
	/*Turn on alpha blending*/
	if (doAlpha) {
		glEnable (GL_BLEND);
		glBlendFunc (GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
	}
	if (alphaSum) glBlendFunc (GL_SRC_ALPHA, GL_ONE);
	
	/*Turn off lighting*/
	glShadeModel (smoothShade?GL_SMOOTH:GL_FLAT);
	glClearColor (0.0, 0.0, 0, 0.0);
	
	GLcheck("after init");
}

GLUTCALLBACK void display(void)
{
   const int psychadelic=0;
   if (!psychadelic) glClear(GL_COLOR_BUFFER_BIT);
   else {
     static int nTimes=0;
     if ((++nTimes%100)<4) glClear(GL_COLOR_BUFFER_BIT);
   }

   glutCtl->draw();

   glutSwapBuffers();
   //if (1) glutPostRedisplay();
   GLcheck("after display");
}

GLUTCALLBACK void reshape(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);

#if 0
   double dx=1.0, dy=1.0; //Size of each axis
   if (w>h) dx=(double)w/(double)h; //Expand x width a bit
   else dy=(double)h/(double)w; //Expand y width a bit
#endif
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   //glOrtho (0,dx, 0,dy, 0, 1);
   //glOrtho (0,w, 0,h, 0, 1);
   
   glutCtl->reshape(w,h);
   
   GLcheck("after reshape");
}

/* ARGSUSED1 */
GLUTCALLBACK void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      //Handle front-end keystrokes here:
      case 'r':
         glutPostRedisplay();	
         break;
      case 27:  case 'q': case 'Q': /*  Escape key  */
         glutCtl->done();
         break;
      default:
         {
	 glutCtl->handleEvent((uiEvent_t)key);
	 }
         break;
   }
}

GLUTCALLBACK void idleFn(void) {
	glutCtl->idle();
}

void glutinit(void) {
   int argc=1;
   char *argv[1]={"foo"};
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
}

/*  Main Loop
 *  Open window with initial window size, title bar, 
 *  RGBA display mode, and handle input events.
 */
int glutmain(const char *winName,guiController *ctl)
{
   glutCtl=ctl;
   int w=800, h=600;
   glutInitWindowSize (w,h);
   glutCreateWindow (winName);
   init();
   glutCtl->reshape(w,h);
   glutMouseFunc(mouseFn);
   glutMotionFunc(motionFn);
   glutReshapeFunc (reshape);
   glutKeyboardFunc (keyboard);
   glutDisplayFunc (display);
   glutIdleFunc (idleFn);
   glutMainLoop();
   return 0;
}
