/*
Reads a Gridgen .grd input file, a simple ASCII format, 
and passes it to a blockConsumer.  Returns an 
error string on errors; returns NULL on sucess.

Orion Sky Lawlor, olawlor@acm.org, 5/30/2001
*/
#include <stdio.h>
#include "gridutil.h"

const char *read_grd(const char *gridFile,blockConsumer &dest)
{
	//Open the input file
	FILE *in=fopen(gridFile,"r");
	if (in==NULL) return "Couldn't open input .grd file";

	//Read the header
	int nBlocks=0;
	if (1!=fscanf(in,"%d",&nBlocks)) return "Couldn't read number of blocks";

	//Read the block sizes
	blockDim *dims=new blockDim[nBlocks];
	int b;
	for (b=0;b<nBlocks;b++) { 
		int nx,ny,nz;
		if (3!=fscanf(in,"%d%d%d",&nx,&ny,&nz))
			return "Couldn't read block dimentions";
		dims[b]=blockDim(nx,ny,nz);
	}
	
	//Read and consume each block's coordinates
	for (b=0;b<nBlocks;b++) {
		int nLocs=dims[b].getSize();
		vector3d *locs=dest.allocateBlock(dims[b]);
		for (int c=0;c<3;c++) //*outer* loop is coordinate axis
		  for (int i=0;i<nLocs;i++) {//*inner* loop is location #
			double loc;
			if (1!=fscanf(in,"%lg",&loc))
				return "Couldn't read coordinate";
			locs[i][c]=loc;
		  }
		const char *err=dest.consume(dims[b],locs);
		if (err!=NULL) return err;
		dest.freeBlock(locs);
	}		
	
	//Finish up
	delete[] dims;
	fclose(in);
	return NULL; //Everything worked
}
