/*
Determines the format of, and calls the appropriate
routine to read a CSAR fluid block mesh.

Orion Sky Lawlor, olawlor@acm.org, 6/8/2001
*/
#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include "util.h"

//Return true if a ends in suffix
bool endsWith(const char *a,const char *suffix)
{
	int al=strlen(a);
	int sl=strlen(suffix);
	if (al<sl) return false;
	const char *a_suff=&a[al-sl];
	return 0==strcmp(a_suff,suffix);
}


//Return true if the indicated file exists and is readable
bool fileExists(const char *fName) {
	FILE *f=fopen(fName,"rb");
	if (f==NULL) 
		return false;
	else {
		fclose(f);
		return true;
	}
}

//Find the numeric part of the file name, and increment it 
// by one.
bool incrementAscii(char *cur)
{
	//Starting from end, work backwards until we reach
	// the first decimal digit.
	int i=strlen(cur)-1;
	while (i>=0 && !isdigit(cur[i])) i--;
	if (i<0) return false; //No digits found
	
	//Carry loop
	while (true) {
		//Increment the current digit
		cur[i]++;
		if (cur[i]!='9'+1) 
			break; //No carry needed-- finished
		//Otherwise, wrap around and carry to next digit
		cur[i]='0';
		i--;
		if (i<0 || !isdigit(cur[i])) return false; //Too many carries
	}
	return true;
}


//Return the filename, padded for fortran use
// Returns a reference to a static internal buffer  
//  (NOT THREADSAFE)
const char *fortranifyString(const char *src)
{
	const int bufLen=500; 
	static char buf[bufLen];
	strcpy(buf,src);
	//Pad with spaces 
	for (int i=strlen(buf);i<bufLen;i++) buf[i]=' ';
	buf[bufLen-1]=0; //Zero-terminate for C use
	return buf;
}

//Replace this string's extention with the given new string
string replaceExtention(const string &a,const string &newSuffix)
{
	string ret(a);
	int dotLoc=ret.rfind(".");
	if (dotLoc==-1) return ret.append(newSuffix);
	return ret.erase(dotLoc).append(newSuffix);
}





