#include "immediatering.h"

static CProxy_immRing_nodegroup immring;

// testing Converse immeidate message
int immediatering_startHandlerIdx=0;
int immediatering_finishHandlerIdx=0;

// testing Converse message
static void sendImmediate(int destNode,int iter) {
  immediateMsg *msg=(immediateMsg *)CmiAlloc(sizeof(immediateMsg));
  msg->iter=iter;
  sprintf(msg->data, "Array!");
  CmiSetHandler(msg, immediatering_startHandlerIdx);
#if 1 /* Use immediate converse message */
  CmiBecomeImmediate(msg);
#endif
  CmiSyncNodeSendAndFree(destNode,sizeof(immediateMsg),(char *)msg);
}

// Converse immediate handler
void immediatering_startHandler(void *vmsg)
{
  const int maxRings = 1000;
  immediateMsg *msg=(immediateMsg *)vmsg;

  if(0!=strcmp(msg->data,"Array!")) {
    CkAbort("Message corrupted");
  }
  if(CkMyNode()==0)
    msg->iter++;
  if (msg->iter < maxRings) { /* Keep passing message around the ring */
    /* This is questionable: */
    sendImmediate((CkMyNode()+1) % CkNumNodes(),msg->iter);
  } else /* msg->iter>=maxRings, so stop: */ { 
    /* finishTest isn't safe from an immediate, so send a 
       regular non-immediate message out: */
    int size=CmiMsgHeaderSizeBytes;
    void *msg=CmiAlloc(size);
    CmiSetHandler(msg,immediatering_finishHandlerIdx);
    CmiSyncSendAndFree(0,size,(char *)msg);
  }
  CmiFree(msg);
}

extern "C" void immediatering_finishHandler(void *msg) {
  finishTest(); // Not safe from inside immediate
  CmiFree(msg);
}

// testing Charm immediate handler

void immRing_nodegroup::start(immMessage *msg)
{
  const int maxRings = 10;

//CkPrintf("[%d] start %d\n", thisIndex, msg->iter);

  if(!msg->check()) {
    CkError("Message corrupted!\n");
    finishTest();
    return;
  }
  if(CkMyNode()==0)
    msg->iter++;
  if (msg->iter < maxRings) {
    thisProxy[(CkMyNode()+1) % CkNumNodes()].start(msg);
  } else {
    delete msg;
    finishTest();
  }
  return;
}

void immediatering_init(void)
{ 
#if 1
  // test Charm immediate messages
  immring[0].start(new immMessage);
#endif
  sendImmediate(0,0);
}

void immediatering_moduleinit(void)
{
  immring = CProxy_immRing_nodegroup::ckNew();
}

void immediatering_initcall(void) {
  // Register converse handlers
  immediatering_startHandlerIdx=CmiRegisterHandler(immediatering_startHandler);
  immediatering_finishHandlerIdx=CmiRegisterHandler(immediatering_finishHandler);
}

#include "immediatering.def.h"
