#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int main(int argc, char **argv) {
  int myrank,size,leftnbr,rightnbr;
  int step=0;
  int i;
  double a[4]={.1,.2,.3,.4},b[4]={.5,.6,.7,.8};
  MPI_Status sts;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD,&myrank);
  MPI_Comm_size(MPI_COMM_WORLD,&size);

  for(step=0;step<6;step++){
    leftnbr = (myrank+size-1)%size;
    rightnbr = (myrank+1)%size;
    MPI_Send(a,4,MPI_DOUBLE,rightnbr,0,MPI_COMM_WORLD);
    MPI_Recv(b,4,MPI_DOUBLE,leftnbr,0,MPI_COMM_WORLD,&sts);
    printf("[%d]step %d,a={%f,%f,%f,%f},b={%f,%f,%f,%f}\n",myrank,step,a[0],a[1],a[2],a[3],b[0],b[1],b[2],b[3]);
    if(step==2){
      MPI_Checkpoint("log");
    }
  }
  
  //printf("MPI_Main about to exit\n");
  MPI_Finalize();
  return 0;
}
