#ifndef JOB_H
#define JOB_H

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <setjmp.h>

#define MAX_CONN 20
#define MAX_SIZE 1024 

#define CHARM   0
#define MPI     1
#define NCHARM  2
#define UNI     3

#define QUEUED    0
#define RUNNING   1
#define SUSPENDED 2
#define FINISHED  3

extern "C"{
#include "ccs.h"
}

struct job_stats{
    int jid;
    int fd;
    char *cmd;
    int num_system_proc;
};

struct job_net_stats{
    unsigned int port,ip,pid;
};

class Job{
 public:  

    unsigned int port,ip,pid;
    int client_soc_fd;

    int type, priority;
    int min_proc;
    int max_proc;
    int num_system_proc;
    int num_allocated_proc;

    CcsServer svr;
    
    char ** argv;
    char * working_directory;
    char *bit_map;
    char *stdin, *stdout, *stderr;
    int job_id;
    int dbid;
    char *name;

    int connected;
    int scheduled;
    int removed;
    int bitmap_changed;

    Job *next;
    
    Job();
    Job(job_stats jstat);
    int destroy(char *bit_map);
 
    void get_arg(char * command);
    int connect();
    void ping();
    
    int set_bitmap();
    void add_proc(int p);
    int delete_proc();

    void started();
};

#endif

