#include "common.h"

struct Node{
    char name[SMALL_BUF_SIZE];
    int ppn;     // Number of processors in the SMP node.
    int speed;       // Speed in Mhz.
    Node *next;
};

//#define USE_UNIX
//#define SHOW_UTILIZATION

#ifdef USE_UNIX
#include <sys/un.h>
#define UNIX_PATH_MAX 108
#else
#include <netinet/in.h>
#endif

class Scheduler{
 public:

    double startTime;

    Scheduler(int port, int nodes, int ppn);
    void start_scheduler();
    
    void Connect(Job *j, int jpid);

    // Functions called by the handlers.
    void wait_for_request();
    void execute_job();
    void load_nodelist(char *node_listfile);
    void remove_job();
    int  start_job(Job *j);
    void dump_stats(FILE *fp);
    void activelist_manager();

 private:

    int port;
    int host_ip;
    int sch_socfd;
    int perr_flag, perr_count;
    
    char nodesfile[SMALL_BUF_SIZE]; // scheduler nodelist file name.
    
    Job *runq;

    // To be initialized from the database.
    int max_port;
    char *free_node_vector;
    int num_free_nodes;

    char *dead_node_vector;
    int num_dead_nodes;

    pthread_mutex_t * shared_mutex, * fork_mutex;

    double utilization;       //Mean system utilization.
    double qsize;             //Mean queue size.
    int cur_qsize;   //current queue size.
    void updateUtil();
    void updateQSize(Job *waitq);

    SchedulingStrategy *strategy;
    int num_nodes;
    int ppn;
        
    Node *activelist, *freelist;
    
    void create_nodes_file(Job *j);
    void set_unijob_host(Job *j);
    void handle_request(int fd);

    void handle_command(char *cmd, char *username, int fd);
    void handle_job(char *cmd, char *username, int fd);
    void handle_remote_job(char *cmd, char *username, int fd);
    void handle_query(char *cmd, char *username, int fd);

    int is_alive(char *);
    int job_running(int pos);
    Node *get_live_node();
    void update_nodesfile();
    void list_jobs(FILE *fp);
    void list_jobs(FILE *fp, int id, char *name);
    void write_script(Job *j);
    void killNodeJobs(Job *j);

    void killJobAtNode(int node); //Kill the job that is running on that node
};
