/*****************************************************************************
 * $Source: /cvsroot/charm/src/ck-ldb/BaseLB.h,v $
 * $Author: gzheng $
 * $Date: 2003/05/08 07:16:51 $
 * $Revision: 1.9 $
 *****************************************************************************/

/**
 \defgroup CkLdb  Charm++ Load Balancing Framework 
*/
/*@{*/

#ifndef BASELB_H
#define BASELB_H

#include "LBDatabase.h"

/// Base class for all LB strategies.
/**
  BaseLB is the base class for all LB strategy class.
  it does some tracking about how many lb strategies are created.
  it also defines some common functions.
*/
class BaseLB: public IrrGroup
{
protected:
  char *lbname;
  LBDatabase *theLbdb;
  LDBarrierReceiver receiver;
public:
  BaseLB() ;
  BaseLB(CkMigrateMessage *m):IrrGroup(m) { /* empty */ }
  void unregister(); 
  inline char *lbName() { return lbname; }
};

/// migration decision for an obj.
struct MigrateInfo {  
    int index;   // object index in objData array
    LDObjHandle obj;
    int from_pe;
    int to_pe;
};

/**
  message contains the migration decision from LB strategies.
*/
class LBMigrateMsg : public CMessage_LBMigrateMsg {
public:
  int n_moves;
  MigrateInfo* moves;

  char * avail_vector;
  int next_lb;

  double * expectedLoad;

  // Other methods & data members

  static void* alloc(int msgnum, size_t size, int* array, int priobits);
  static void* pack(LBMigrateMsg* in);
  static LBMigrateMsg* unpack(void* in);
};

#endif

/*@}*/
