/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import projections.analysis.RLEBlock;
import projections.analysis.SumDetailReader;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;

public class IntervalData {
    public static final int NUM_TYPES = 2;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_NUM_MSGS = 1;
    private static SumDetailReader[] summaryDetails;
    private Vector[][][] rawData;
    private int numEPs = 0;
    private int numPEs = Analysis.getNumProcessors();
    private int numIntervals = 0;
    private double intervalSize = 0.0;

    public IntervalData() {
        this.numEPs = Analysis.getNumUserEntries();
        if (Analysis.hasSumDetailData()) {
            summaryDetails = new SumDetailReader[this.numPEs];
            this.rawData = new Vector[2][this.numPEs][];
            OrderedIntList orderedIntList = Analysis.getValidProcessorList(3);
            orderedIntList.reset();
            while (orderedIntList.hasMoreElements()) {
                int n = orderedIntList.nextElement();
                try {
                    IntervalData.summaryDetails[n] = new SumDetailReader(Analysis.getSumDetailName(n), Analysis.getVersion());
                    int n2 = 0;
                    while (n2 < 2) {
                        this.rawData[n2][n] = summaryDetails[n].getData(n2);
                        ++n2;
                    }
                    if (this.numIntervals < summaryDetails[n].getNumIntervals()) {
                        this.numIntervals = summaryDetails[n].getNumIntervals();
                    }
                    this.intervalSize = summaryDetails[n].getIntervalSize();
                }
                catch (IOException iOException) {
                    System.err.println("Warning: Failed to read summary detail file for processor " + n);
                }
            }
        }
    }

    private void loadData(int n, int n2, int n3, int n4, int n5, double d) {
        if (d < this.intervalSize ? Analysis.hasLogData() : d > this.intervalSize) {
            // empty if block
        }
    }

    public double[][] getData(int n, int n2) {
        double[][] dArray = new double[this.numEPs][this.numIntervals];
        int n3 = 0;
        while (n3 < this.numEPs) {
            Iterator iterator = ((AbstractList)this.rawData[n2][n][n3]).iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                RLEBlock rLEBlock = (RLEBlock)iterator.next();
                int n5 = 0;
                while (n5 < rLEBlock.count) {
                    dArray[n3][n4 + n5] = rLEBlock.value;
                    ++n5;
                }
                n4 += rLEBlock.count;
            }
            ++n3;
        }
        return dArray;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    private void accumulateIntoArray(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        int n6 = 0;
        boolean bl = false;
        Iterator iterator = ((AbstractList)this.rawData[n][n2][n3]).iterator();
        while (iterator.hasNext()) {
            RLEBlock rLEBlock = (RLEBlock)iterator.next();
            int n7 = n6 + rLEBlock.count - 1;
            if (n7 < n4) {
                n6 = n7 + 1;
                continue;
            }
            if (n6 < n4) {
                n6 = n4;
            }
            if (n7 > n5) {
                n7 = n5;
                bl = true;
            }
            int n8 = n6 - n4;
            while (n8 <= n7 - n4) {
                dArray[n8] = rLEBlock.value;
                ++n8;
            }
            n6 = n7 + 1;
            if (bl) break;
        }
    }

    public double[][] getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3) {
        int n4 = Analysis.getNumUserEntries();
        double[][] dArray = new double[n4][n3 - n2 + 1];
        int n5 = 0;
        while (n5 < n4) {
            orderedIntList.reset();
            int n6 = 0;
            while (n6 < orderedIntList.size()) {
                int n7 = orderedIntList.nextElement();
                this.accumulateIntoArray(n, n7, n5, n2, n3, dArray[n5]);
                ++n6;
            }
            ++n5;
        }
        return dArray;
    }

    public Vector getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3, OrderedIntList orderedIntList2) {
        Vector<double[]> vector = new Vector<double[]>();
        double[] dArray = null;
        orderedIntList2.reset();
        int n4 = 0;
        while (n4 < orderedIntList2.size()) {
            dArray = new double[n3 - n2 + 1];
            int n5 = orderedIntList2.nextElement();
            orderedIntList.reset();
            int n6 = 0;
            while (n6 < orderedIntList.size()) {
                int n7 = orderedIntList.nextElement();
                this.accumulateIntoArray(n, n7, n5, n2, n3, dArray);
                ++n6;
            }
            vector.add(dArray);
            ++n4;
        }
        return vector;
    }
}

