/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class ParseTokenizer
extends StreamTokenizer {
    public ParseTokenizer(Reader reader) {
        super(reader);
    }

    public void checkNextString(String string) throws IOException {
        String string2 = this.nextString(string);
        if (!string.equals(string2)) {
            throw new IOException("Expected " + string + " got " + string2);
        }
    }

    public double nextNumber(String string) throws IOException {
        if (-2 != super.nextToken()) {
            throw new IOException("Couldn't read " + string + " got " + this.toString());
        }
        return this.nval;
    }

    public double nextScientific(String string) throws IOException {
        int n;
        double d = this.nextNumber(string + " mantissa");
        String string2 = this.nextString(string + " exponent");
        char c = string2.charAt(0);
        if (c != 'e' && c != 'd' && c != 'E' && c != 'D') {
            throw new IOException("Couldn't find exponent in " + string2);
        }
        string2 = string2.substring(1);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Couldn't parse exponent " + string2);
        }
        return d * Math.pow(10.0, n);
    }

    public String nextString(String string) throws IOException {
        if (-3 != super.nextToken()) {
            throw new IOException("Couldn't read string " + string + " got " + this.toString());
        }
        return this.sval;
    }
}

