/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.AnimationColorBarPanel;
import projections.gui.AnimationDisplayPanel;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

public class AnimationWindow
extends Frame
implements ActionListener {
    private AnimationColorBarPanel colorbarPanel;
    private AnimationDisplayPanel displayPanel;
    private Button bPlusOne;
    private Button bMinusOne;
    private Button bAuto;
    private TimeTextField delayField;
    private TimeTextField intervalField;
    private Panel statusPanel;
    private Panel titlePanel;
    private Label lTitle;
    private Label lStatus;
    private Label lInterval;
    private Label lDelay;
    private int redrawDelay;
    private int curInterval = 0;
    private boolean keepAnimating;
    private AnimateThread thread;

    public AnimationWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (AnimationWindow.this.thread != null && AnimationWindow.this.thread.isAlive()) {
                    AnimationWindow.this.keepAnimating = false;
                    AnimationWindow.this.thread = null;
                }
                AnimationWindow.this.dispose();
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.setTitle("Projections Animation");
        this.createMenus();
        this.createLayout();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.delayField) {
            System.out.println("event on delay field");
            this.redrawDelay = (int)(this.delayField.getValue() / 1000L);
        } else if (actionEvent.getSource() == this.intervalField) {
            this.displayPanel.setIsize((int)this.intervalField.getValue());
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bPlusOne) {
                this.changeCurI(this.displayPanel.getCurI() + 1);
            } else if (button == this.bMinusOne) {
                this.changeCurI(this.displayPanel.getCurI() - 1);
            } else if (button == this.bAuto) {
                if (button.getLabel().equals("Auto")) {
                    button.setLabel("Stop");
                    this.keepAnimating = true;
                    this.thread = new AnimateThread();
                    this.thread.start();
                } else {
                    button.setLabel("Auto");
                    if (this.thread != null && this.thread.isAlive()) {
                        this.keepAnimating = false;
                        this.thread = null;
                        this.changeCurI(this.displayPanel.getCurI());
                    }
                }
            }
        }
    }

    private void changeCurI(int n) {
        this.displayPanel.setCurI(n);
        this.setTitleInfo(this.displayPanel.getCurI());
    }

    private void createLayout() {
        Panel panel = new Panel();
        this.titlePanel = new Panel();
        this.statusPanel = new Panel();
        Panel panel2 = new Panel();
        this.colorbarPanel = new AnimationColorBarPanel();
        this.displayPanel = new AnimationDisplayPanel(this);
        this.bPlusOne = new Button(">>");
        this.bMinusOne = new Button("<<");
        this.bAuto = new Button("Auto");
        this.bPlusOne.addActionListener(this);
        this.bMinusOne.addActionListener(this);
        this.bAuto.addActionListener(this);
        this.redrawDelay = 500;
        this.lDelay = new Label("Delay:", 1);
        this.delayField = new TimeTextField("500 ms", 8);
        this.lInterval = new Label("Interval:", 1);
        this.intervalField = new TimeTextField("100 ms", 4);
        this.delayField.addActionListener(this);
        this.intervalField.addActionListener(this);
        int n = this.displayPanel.getIsize();
        long l = this.displayPanel.getStartTime();
        int n2 = (int)l / n;
        this.titlePanel.setBackground(Color.black);
        this.titlePanel.setForeground(Color.white);
        this.displayPanel.setBackground(Color.black);
        Font font = new Font("SansSerif", 1, 16);
        this.lTitle = new Label("Processor Usage at " + U.t(n * n2), 1);
        this.lTitle.setFont(font);
        this.titlePanel.add(this.lTitle);
        this.lStatus = new Label("");
        this.statusPanel.add((Component)this.lStatus, "Center");
        this.statusPanel.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        panel2.setLayout(gridBagLayout);
        Util.gblAdd(panel2, this.bMinusOne, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bPlusOne, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bAuto, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.lDelay, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.delayField, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.lInterval, gridBagConstraints, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.intervalField, gridBagConstraints, 6, 0, 1, 1, 1, 1);
        panel.setBackground(Color.gray);
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(panel, this.displayPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(panel, this.colorbarPanel, gridBagConstraints, 0, 2, 1, 1, 1, 0);
        Util.gblAdd(panel, this.statusPanel, gridBagConstraints, 0, 3, 1, 1, 1, 0);
        Util.gblAdd(panel, panel2, gridBagConstraints, 0, 4, 1, 1, 1, 0);
        this.add((Component)panel, "Center");
    }

    private void createMenus() {
    }

    public void setStatusInfo(int n, int n2, int n3) {
        String string;
        if (n < 0) {
            string = "";
        } else {
            int n4 = this.displayPanel.getIsize();
            long l = this.displayPanel.getStartTime();
            int n5 = (int)l / n4;
            string = "Processor " + n + ": Usage = " + n3 + "% at " + U.t(n4 * (n2 + n5));
        }
        this.lStatus.setText(string);
        this.lStatus.invalidate();
        this.statusPanel.validate();
    }

    public void setTitleInfo(int n) {
        int n2 = this.displayPanel.getIsize();
        long l = this.displayPanel.getStartTime();
        int n3 = (int)l / n2;
        String string = "Processor Usage at " + U.t(n2 * (n + n3));
        this.lTitle.setText(string);
        this.lTitle.invalidate();
        this.titlePanel.validate();
    }

    class AnimateThread
    extends Thread {
        public AnimateThread() {
            AnimationWindow.this.keepAnimating = true;
        }

        public void run() {
            long l = (long)AnimationWindow.this.redrawDelay + System.currentTimeMillis();
            while (AnimationWindow.this.keepAnimating) {
                long l2 = l - System.currentTimeMillis();
                if (l2 > 0L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                l += (long)AnimationWindow.this.redrawDelay;
                AnimationWindow.this.changeCurI(AnimationWindow.this.displayPanel.getCurI() + 1);
            }
        }
    }
}

