/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.gui.JTimeTextField;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class IntervalRangeDialog
extends RangeDialog
implements ActionListener,
KeyListener,
FocusListener {
    JPanel sizePanel;
    JPanel thresholdPanel;
    JTimeTextField sizeField;
    JTimeTextField thresholdField;
    long intervalSize = 1000L;
    long threshold = 0L;
    boolean existsSizeField;
    boolean existsThresholdField;

    public IntervalRangeDialog(ProjectionsWindow projectionsWindow, String string) {
        super(projectionsWindow, string);
        this.existsSizeField = true;
        this.existsThresholdField = true;
    }

    public IntervalRangeDialog(ProjectionsWindow projectionsWindow, String string, boolean bl, boolean bl2) {
        super(projectionsWindow, string);
        this.existsSizeField = bl;
        this.existsThresholdField = bl2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bOK) {
                JTextField jTextField = this.checkConsistent();
                if (jTextField != null) {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    return;
                }
                this.setAllData();
            } else if (jButton == this.bUpdate) {
                if (this.existsSizeField) {
                    this.updateData(this.sizeField);
                }
                if (this.existsThresholdField) {
                    this.updateData(this.thresholdField);
                }
            }
        } else if (actionEvent.getSource() instanceof JTextField) {
            // empty if block
        }
        super.actionPerformed(actionEvent);
    }

    JPanel createMainLayout() {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = super.createMainLayout();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        if (this.existsSizeField) {
            this.sizePanel = new JPanel();
            this.sizePanel.setLayout(gridBagLayout);
            jLabel = new JLabel("Interval Size :", 2);
            this.sizeField = new JTimeTextField(this.intervalSize, 12);
            this.sizeField.addActionListener(this);
            this.sizeField.addKeyListener(this);
            this.sizeField.addFocusListener(this);
            Util.gblAdd(this.sizePanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.sizePanel, this.sizeField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        }
        if (this.existsThresholdField) {
            this.thresholdPanel = new JPanel();
            this.thresholdPanel.setLayout(gridBagLayout);
            jLabel = new JLabel("EP threshold :", 2);
            this.thresholdField = new JTimeTextField(this.threshold, 12);
            this.thresholdField.addActionListener(this);
            this.thresholdField.addKeyListener(this);
            this.thresholdField.addFocusListener(this);
            Util.gblAdd(this.thresholdPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.thresholdPanel, this.thresholdField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        }
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        if (this.existsSizeField) {
            Util.gblAdd(jPanel, this.sizePanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        }
        if (this.existsThresholdField) {
            Util.gblAdd(jPanel, this.thresholdPanel, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        }
        return jPanel;
    }

    void updateData(JTextField jTextField) {
        if (jTextField instanceof JTimeTextField) {
            if (this.existsSizeField && jTextField == this.sizeField) {
                this.intervalSize = this.sizeField.getValue();
            } else if (this.existsThresholdField && jTextField == this.thresholdField) {
                this.threshold = this.thresholdField.getValue();
            }
        }
        super.updateData(jTextField);
    }

    JTextField checkConsistent() {
        if (this.existsSizeField && (this.intervalSize <= 0L || this.intervalSize > this.totalTime)) {
            return this.sizeField;
        }
        if (this.existsThresholdField && this.threshold < 0L) {
            return this.thresholdField;
        }
        return super.checkConsistent();
    }

    long getIntervalSize() {
        return this.intervalSize;
    }

    long getThresholdTime() {
        return this.threshold;
    }

    void setAllData() {
        super.setAllData();
    }
}

