/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import projections.gui.MainWindow;
import projections.gui.MenuManager;

public class MainMenuManager
extends MenuManager
implements ActionListener,
ItemListener {
    private JMenu fileMenu;
    private JMenu toolMenu;
    private JMenu counterMenu;
    private static final int NO_DATA = 0;
    private static final int OPENED_FILES = 1;
    private MainWindow parent;

    public MainMenuManager(JFrame jFrame) {
        super(jFrame);
        this.parent = (MainWindow)jFrame;
        this.createMenus();
    }

    void stateChanged(int n) {
        switch (n) {
            case 0: {
                this.setEnabled(this.fileMenu, new boolean[]{true, false, false, false, true});
                this.setEnabled(this.toolMenu, new boolean[]{false, false, false, false, false, false, false, false, true, false, true, false, false, false, false});
                break;
            }
            case 1: {
                this.setEnabled(this.fileMenu, new boolean[]{true, true, true, false, true});
                this.setAllTo(this.toolMenu, true);
            }
        }
    }

    private void createMenus() {
        this.fileMenu = this.makeJMenu("File", new Object[]{"Open File(s)", "Close current data", "Close all data", null, "Quit"});
        this.menubar.add(this.fileMenu);
        this.menubar.add(this.makeJMenu("View", new Object[]{new JCheckBoxMenuItem("WindowShade")}));
        this.toolMenu = this.makeJMenu("Tools", new Object[]{"Graphs", "Timelines", "Usage Profile", "Communication Histogram", "Animations", "View Log Files", "Histograms", "Overview", "Multirun Analysis", null, "Performance Counters", "General Graph", "Interval Graph", "Generate EP Data", "Entry Point Characteristics Graph"});
        this.menubar.add(this.toolMenu);
        this.stateChanged(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            if (string.equals("Open File(s)")) {
                this.parent.showOpenFileDialog();
            }
            if (string.equals("Close current data")) {
                this.parent.closeCurrent();
            } else if (string.equals("Close all data")) {
                this.parent.closeAll();
            } else if (string.equals("Quit")) {
                this.parent.shutdown();
            } else if (string.equals("Multirun Analysis") || string.equals("Histograms") || string.equals("Graphs") || string.equals("Timelines") || string.equals("Animations") || string.equals("Usage Profile") || string.equals("Communication Histogram") || string.equals("View Log Files") || string.equals("Overview") || string.equals("Performance Counters") || string.equals("General Graph") || string.equals("Interval Graph") || string.equals("Entry Point Characteristics Graph") || string.equals("Generate EP Data")) {
                this.parent.menuToolSelected(string);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void fileOpened() {
        this.stateChanged(1);
    }

    public void lastFileClosed() {
        this.stateChanged(0);
    }
}

