/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import projections.gui.Analysis;
import projections.gui.AnimationWindow;
import projections.gui.CommWindow;
import projections.gui.CounterCallBack;
import projections.gui.EPAnalysis;
import projections.gui.EPCharWindow;
import projections.gui.GraphWindow;
import projections.gui.GraphingWindow;
import projections.gui.HelpWindow;
import projections.gui.HistogramWindow;
import projections.gui.IntervalWindow;
import projections.gui.InvalidFileDialog;
import projections.gui.LogFileViewerWindow;
import projections.gui.MainFileFilter;
import projections.gui.MainMenuManager;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.MainTitlePanel;
import projections.gui.MainWindowPanel;
import projections.gui.MultiRunWindow;
import projections.gui.ProfileWindow;
import projections.gui.ProjectionsFileChooser;
import projections.gui.ScreenInfo;
import projections.gui.StlWindow;
import projections.gui.TimelineWindow;
import projections.gui.Util;
import projections.gui.count.CounterFrame;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.SummaryDataSource;
import projections.gui.graph.SummaryXAxis;
import projections.gui.graph.SummaryYAxis;

public class MainWindow
extends JFrame
implements ActionListener {
    public static double CUR_VERSION = 4.0;
    private GraphWindow graphWindow;
    private TimelineWindow timelineWindow;
    private AnimationWindow animationWindow;
    private ProfileWindow profileWindow;
    private CommWindow commWindow;
    private HelpWindow helpWindow;
    private LogFileViewerWindow logFileViewerWindow;
    private HistogramWindow histogramWindow;
    private StlWindow stlWindow;
    private MultiRunWindow multiRunWindow;
    private IntervalWindow intervalWindow;
    private EPCharWindow epCharWindow;
    private GraphingWindow graphingWindow;
    private EPAnalysis epAnalysis;
    private MainTitlePanel titlePanel;
    private MainWindowPanel mainPanel;
    private MainMenuManager menuManager;
    private MainSummaryGraphPanel summaryGraphPanel;
    private MainRunStatusPanel runStatusPanel;
    private SummaryDataSource sumDataSource;
    private SummaryXAxis sumXAxis;
    private SummaryYAxis sumYAxis;
    private GraphPanel graphPanel;
    private Image bgimage;

    public MainWindow() {
        ScreenInfo.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.menuManager = new MainMenuManager(this);
        this.createLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void createLayout() {
        Serializable serializable;
        try {
            serializable = this.getClass().getResource("/projections/images/bgimage");
            this.bgimage = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            this.mainPanel = new MainWindowPanel(this.bgimage);
        }
        catch (Exception exception) {
            System.out.println("Error loading background image.  Continuing.");
            this.mainPanel = new MainWindowPanel(null);
        }
        this.setContentPane(this.mainPanel);
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout((LayoutManager)((Object)serializable));
        this.titlePanel = new MainTitlePanel(this);
        this.runStatusPanel = new MainRunStatusPanel();
        this.summaryGraphPanel = new MainSummaryGraphPanel(this.runStatusPanel);
        Util.gblAdd(this.mainPanel, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0);
        Util.gblAdd(this.mainPanel, this.runStatusPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 0, 20, 0, 20);
        Util.gblAdd(this.mainPanel, this.summaryGraphPanel, gridBagConstraints, 0, 2, 1, 1, 1, 1, 0, 20, 20, 20);
        this.pack();
    }

    public void menuToolSelected(String string) {
        if (string.equals("Graphs")) {
            this.showChildWindow(this.graphWindow, "GraphWindow");
        } else if (string.equals("Histograms")) {
            this.showChildWindow(this.histogramWindow, "HistogramWindow");
        } else if (string.equals("Timelines")) {
            this.showTimelineWindow();
        } else if (string.equals("Animations")) {
            this.showAnimationWindow();
        } else if (string.equals("Usage Profile")) {
            this.showChildWindow(this.profileWindow, "ProfileWindow");
        } else if (string.equals("Communication Histogram")) {
            this.showChildWindow(this.commWindow, "CommWindow");
        } else if (string.equals("View Log Files")) {
            this.showChildWindow(this.logFileViewerWindow, "LogFileViewerWindow");
        } else if (string.equals("Overview")) {
            this.showStlWindow();
        } else if (string.equals("Multirun Analysis")) {
            this.showChildWindow(this.multiRunWindow, "MultiRunWindow");
        } else if (string.equals("Performance Counters")) {
            this.showCounterWindow();
        } else if (string.equals("General Graph")) {
            this.showChildWindow(this.graphingWindow, "GraphingWindow");
        } else if (string.equals("Interval Graph") || string.equals("Entry Point Characteristics Graph") || string.equals("Generate EP Data")) {
            // empty if block
        }
    }

    public void showChildWindow(Object object, String string) {
        try {
            if (object == null) {
                String string2 = this.getClass().getPackage().getName() + "." + string;
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(this.getClass());
                object = constructor.newInstance(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showTimelineWindow() {
        if (this.timelineWindow == null) {
            this.timelineWindow = new TimelineWindow(this);
            ((Component)this.timelineWindow).setSize(640, 480);
        }
    }

    public void showAnimationWindow() {
        new Thread(new Runnable(){

            public void run() {
                MainWindow.this.animationWindow = new AnimationWindow();
                ((Component)MainWindow.this.animationWindow).setVisible(true);
            }
        }).start();
    }

    public void showStlWindow() {
        new Thread(new Runnable(){

            public void run() {
                MainWindow.this.stlWindow = new StlWindow();
            }
        }).start();
    }

    public void showCounterWindow() {
        CounterFrame counterFrame = new CounterFrame();
        Object var2_2 = null;
        try {
            ProjectionsFileChooser projectionsFileChooser = new ProjectionsFileChooser(counterFrame, "Performance Counter Analysis", 1);
            CounterCallBack counterCallBack = new CounterCallBack(counterFrame, projectionsFileChooser);
            int n = projectionsFileChooser.showDialog(counterCallBack);
        }
        catch (Exception exception) {
            System.out.println("something got screwed");
            ProjectionsFileChooser.handleException(counterFrame, exception);
        }
    }

    public void activateEPAnalysis() {
        if (this.epAnalysis == null) {
            this.epAnalysis = new EPAnalysis(this);
        }
    }

    public void showOpenFileDialog() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(new MainFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.setTitle("Projections -" + jFileChooser.getSelectedFile());
            this.openFile(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void openFile(String string) {
        try {
            Analysis.initAnalysis(string);
            Analysis.loadSummaryData();
            if (Analysis.hasSummaryData()) {
                double[] dArray = Analysis.getSummaryAverageData();
                this.sumDataSource = new SummaryDataSource(dArray);
                this.sumXAxis = new SummaryXAxis(dArray.length, Analysis.getSummaryIntervalSize());
                this.sumYAxis = new SummaryYAxis();
                this.graphPanel = new GraphPanel(new Graph(this.sumDataSource, this.sumXAxis, this.sumYAxis));
                this.summaryGraphPanel.add("data", this.graphPanel, "run data");
            }
            this.menuManager.fileOpened();
        }
        catch (IOException iOException) {
            InvalidFileDialog invalidFileDialog = new InvalidFileDialog(this);
            ((Component)invalidFileDialog).setVisible(true);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            InvalidFileDialog invalidFileDialog = new InvalidFileDialog(this);
            ((Component)invalidFileDialog).setVisible(true);
        }
    }

    public void closeChildWindow(Object object) {
        if (object.equals(this.timelineWindow)) {
            this.timelineWindow = null;
        } else if (object.equals(this.profileWindow)) {
            this.profileWindow = null;
        } else if (object.equals(this.logFileViewerWindow)) {
            this.logFileViewerWindow = null;
        } else if (object.equals(this.graphWindow)) {
            this.graphWindow = null;
        } else if (object.equals(this.multiRunWindow)) {
            this.multiRunWindow = null;
        }
    }

    public void shutdown() {
        System.exit(0);
    }

    public void closeCurrent() {
        this.closeAll();
    }

    public void closeAll() {
        this.summaryGraphPanel.removeAll();
        this.menuManager.lastFileClosed();
        this.setTitle("Projections");
    }

    public void CloseEPAnalysis() {
        this.epAnalysis = null;
    }

    public Color getGraphColor(int n) {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphColor(n);
        }
        return null;
    }

    public boolean GraphExists() {
        return this.graphWindow != null;
    }

    public static void help() {
        System.out.println("-h:\t\tshow this page");
        System.out.println("-V:\t\tshow Projections version");
        System.out.println("-u <ver>:\tuse old version format");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = null;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-h")) {
                MainWindow.help();
            } else if (stringArray[n].equals("-V")) {
                System.out.println("Projections version: " + Analysis.getVersion());
                System.exit(0);
            } else if (stringArray[n].equals("-u")) {
                double d;
                if (++n == stringArray.length) {
                    MainWindow.help();
                }
                if ((d = Double.parseDouble(stringArray[n])) > CUR_VERSION) {
                    System.out.println("Invalid (future) Projections version!");
                    System.exit(1);
                }
                CUR_VERSION = d;
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        MainWindow mainWindow = new MainWindow();
        mainWindow.pack();
        mainWindow.setTitle("Projections");
        ((Component)mainWindow).setVisible(true);
        if (string != null) {
            mainWindow.openFile(string);
        }
    }
}

