/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import projections.gui.Bubble;

public class ProfileObject
extends Component
implements MouseListener {
    private float usage;
    private String name;
    private int processor;
    private String[] bubbletext;
    private Bubble bubble;
    private boolean inside = false;

    public ProfileObject(float f, String string, int n) {
        this.usage = f;
        this.name = string;
        this.processor = n;
        this.bubbletext = new String[3];
        this.bubbletext[0] = string;
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.bubbletext[1] = "USAGE: " + numberFormat.format(f) + "%";
        this.bubbletext[2] = n == -1 ? "Average" : "Processor " + n;
        this.addMouseListener(this);
    }

    public String getName() {
        return this.name;
    }

    public float getUsage() {
        return this.usage;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.inside) {
            this.inside = true;
            ProfileObject profileObject = this;
            Point point = profileObject.getLocationOnScreen();
            Dimension dimension = this.getSize();
            if (this.bubble == null) {
                this.bubble = new Bubble(this, this.bubbletext);
            }
            ((Component)this.bubble).setLocation(point.x + dimension.width + 5, point.y + mouseEvent.getY());
            this.bubble.setVisible(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.inside) {
            if (this.bubble != null) {
                this.bubble.dispose();
            }
            this.inside = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = this.name.equals("MESSAGE PACKING") ? Color.pink : (this.name.equals("OVERHEAD") ? Color.white : (this.name.equals("IDLE") ? Color.white : this.getForeground()));
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        if (this.name.equals("OVERHEAD")) {
            graphics.setColor(Color.black);
            int n3 = 0;
            while (n3 < n2 + n) {
                graphics.drawLine(n3, 0, 0, n3);
                graphics.drawLine(n3 + 1, 0, 0, n3 + 1);
                n3 += 4;
            }
        }
    }
}

