/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.TimelineEvent;
import projections.analysis.TimelineMessage;
import projections.analysis.UserEvent;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.TimelineDisplayCanvas;
import projections.gui.TimelineLine;
import projections.gui.TimelineObject;
import projections.gui.TimelineWindow;
import projections.gui.Util;
import projections.misc.ProgressDialog;

public class TimelineData {
    int vpw;
    int vph;
    int tlw;
    int tlh;
    int lcw;
    int ath;
    int abh;
    int sbw;
    int sbh;
    int mpw;
    int mph;
    public int tluh;
    public int barheight;
    int numPs;
    float scale;
    public int offset;
    public OrderedIntList processorList;
    OrderedIntList oldplist = null;
    String processorString;
    String oldpstring = null;
    public boolean colorbyObjectId;
    public double pixelIncrement;
    public int timeIncrement;
    int labelIncrement;
    int numIntervals;
    int[] entries;
    Color[] entryColor;
    public TimelineObject[][] tloArray;
    public Vector[] mesgVector;
    public Vector[] oldmesgVector;
    UserEvent[][] userEventsArray = null;
    TimelineDisplayCanvas displayCanvas;
    int xmin;
    int xmax;
    long xmintime;
    long xmaxtime;
    int xminpixel;
    int xmaxpixel;
    float[] processorUsage;
    float[] idleUsage;
    float[] packUsage;
    OrderedUsageList[] entryUsageList;
    public long beginTime;
    public long endTime;
    public long totalTime;
    long oldBT = -1L;
    long oldET = -1L;
    boolean showPacks = false;
    boolean showIdle = false;
    boolean showMsgs = true;
    public TimelineWindow timelineWindow;
    public Vector mesgCreateExecVector;

    public TimelineData(TimelineWindow timelineWindow) {
        this.timelineWindow = timelineWindow;
        this.displayCanvas = timelineWindow.displayCanvas;
        this.lcw = 100;
        this.sbw = 20;
        this.sbh = 20;
        this.barheight = 20;
        this.tluh = this.barheight + 20;
        this.numPs = 0;
        this.ath = 50;
        this.scale = 1.0f;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.processorString = Analysis.getValidProcessorString();
        this.offset = 10;
        this.pixelIncrement = 5.0;
        this.timeIncrement = 100;
        this.labelIncrement = 5;
        this.numIntervals = 1;
        this.beginTime = 0L;
        this.endTime = this.totalTime = Analysis.getTotalTime();
        this.xmin = 0;
        this.xmax = this.numIntervals;
        this.xmintime = 0L;
        this.xmaxtime = 1L;
        this.xminpixel = 0;
        this.xmaxpixel = 1;
        this.mesgCreateExecVector = new Vector();
        this.tloArray = null;
        this.mesgVector = null;
        this.entries = new int[Analysis.getNumUserEntries()];
        this.entryColor = new Color[Analysis.getNumUserEntries()];
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = (float)(1.0 / (double)Analysis.getNumUserEntries());
        if (new File(Analysis.getLogDirectory() + File.separator + "color.map").exists()) {
            try {
                Util.restoreColors(this.entryColor, "Timeline Graph");
            }
            catch (IOException iOException) {
                System.err.println("unable to load color.map");
            }
        } else {
            int n = 0;
            while (n < Analysis.getNumUserEntries()) {
                this.entries[n] = 0;
                this.entryColor[n] = Analysis.getEntryColor(n);
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void createTLOArray() {
        block24: {
            var1_1 = this.tloArray;
            var2_2 = this.userEventsArray;
            this.oldmesgVector = this.mesgVector;
            this.mesgVector = new Vector[Analysis.getNumProcessors()];
            var3_3 = 0;
            while (var3_3 < Analysis.getNumProcessors()) {
                this.mesgVector[var3_3] = null;
                ++var3_3;
            }
            this.tloArray = new TimelineObject[this.processorList.size()][];
            this.userEventsArray = new UserEvent[this.processorList.size()][];
            if (var1_1 == null || this.beginTime < this.oldBT || this.endTime > this.oldET) break block24;
            var6_4 = 0;
            var7_6 = 0;
            this.processorList.reset();
            this.oldplist.reset();
            var5_7 = this.processorList.nextElement();
            var4_8 = this.oldplist.nextElement();
            ** GOTO lbl88
            {
                var4_8 = this.oldplist.nextElement();
                ++var6_4;
                do {
                    if (var4_8 != -1 && var4_8 < var5_7) continue block1;
                    if (var4_8 == -1) break block1;
                    if (var4_8 == var5_7) {
                        if (this.beginTime == this.oldBT && this.endTime == this.oldET) {
                            this.tloArray[var7_6] = var1_1[var6_4];
                            this.userEventsArray[var7_6] = var2_2[var6_4];
                            this.mesgVector[var4_8] = this.oldmesgVector[var5_7];
                        } else {
                            var9_10 = var1_1[var6_4].length;
                            var10_12 = 0;
                            var11_13 = 0;
                            var12_14 = var9_10 - 1;
                            var8_9 = 0;
                            while (var8_9 < var9_10) {
                                if (var1_1[var6_4][var8_9].getEndTime() >= this.beginTime) break;
                                ++var11_13;
                                ++var8_9;
                            }
                            var8_9 = var9_10 - 1;
                            while (var8_9 >= 0) {
                                if (var1_1[var6_4][var8_9].getBeginTime() <= this.endTime) break;
                                --var12_14;
                                --var8_9;
                            }
                            var10_12 = var12_14 - var11_13 + 1;
                            this.tloArray[var7_6] = new TimelineObject[var10_12];
                            this.mesgVector[var5_7] = new Vector<E>();
                            var8_9 = 0;
                            while (var8_9 < var10_12) {
                                this.tloArray[var7_6][var8_9] = var1_1[var6_4][var8_9 + var11_13];
                                this.tloArray[var7_6][var8_9].setUsage();
                                this.tloArray[var7_6][var8_9].setPackUsage();
                                var13_15 = 0;
                                while (var13_15 < this.tloArray[var7_6][var8_9].messages.length) {
                                    this.mesgVector[var5_7].addElement(this.tloArray[var7_6][var8_9].messages[var13_15]);
                                    ++var13_15;
                                }
                                ++var8_9;
                            }
                            if (var2_2 != null && var2_2[var6_4] != null) {
                                var9_10 = var2_2[var6_4].length;
                                var10_12 = 0;
                                var11_13 = 0;
                                var12_14 = var9_10 - 1;
                                var8_9 = 0;
                                while (var8_9 < var9_10) {
                                    if (var2_2[var6_4][var8_9].EndTime >= this.beginTime) break;
                                    ++var11_13;
                                    ++var8_9;
                                }
                                var8_9 = var9_10 - 1;
                                while (var8_9 >= 0) {
                                    if (var2_2[var6_4][var8_9].BeginTime <= this.endTime) break;
                                    --var12_14;
                                    --var8_9;
                                }
                                var10_12 = var12_14 - var11_13 + 1;
                                this.userEventsArray[var7_6] = new UserEvent[var10_12];
                                var8_9 = 0;
                                while (var8_9 < var10_12) {
                                    this.userEventsArray[var7_6][var8_9] = var2_2[var6_4][var11_13 + var8_9];
                                    ++var8_9;
                                }
                            }
                        }
                    }
                    var5_7 = this.processorList.nextElement();
                    ++var7_6;
lbl88:
                    // 2 sources

                } while (var5_7 != -1);
            }
            var1_1 = null;
            var2_2 = null;
        }
        this.processorList.reset();
        var5_7 = this.processorList.size();
        var6_5 = new ProgressDialog("Reading timeline data");
        var7_6 = 0;
        while (var7_6 < var5_7) {
            if (!var6_5.progress(var7_6 + 1, var5_7, var7_6 + 1 + " of " + var5_7)) break;
            var4_8 = this.processorList.nextElement();
            if (this.tloArray[var7_6] == null) {
                this.tloArray[var7_6] = this.getData(var4_8, var7_6);
            }
            ++var7_6;
        }
        var6_5.done();
        var8_9 = 0;
        while (var8_9 < Analysis.getNumUserEntries()) {
            this.entries[var8_9] = 0;
            ++var8_9;
        }
        this.processorUsage = new float[this.tloArray.length];
        this.entryUsageList = new OrderedUsageList[this.tloArray.length];
        var9_11 = new float[Analysis.getNumUserEntries()];
        this.idleUsage = new float[this.tloArray.length];
        this.packUsage = new float[this.tloArray.length];
        var10_12 = 0;
        while (var10_12 < this.tloArray.length) {
            this.processorUsage[var10_12] = 0.0f;
            this.idleUsage[var10_12] = 0.0f;
            this.packUsage[var10_12] = 0.0f;
            var11_13 = 0;
            while (var11_13 < Analysis.getNumUserEntries()) {
                var9_11[var11_13] = 0.0f;
                ++var11_13;
            }
            var12_14 = 0;
            while (var12_14 < this.tloArray[var10_12].length) {
                var13_17 = this.tloArray[var10_12][var12_14].getUsage();
                var14_18 = this.tloArray[var10_12][var12_14].getEntry();
                if (var14_18 >= 0) {
                    v0 = var14_18;
                    this.entries[v0] = this.entries[v0] + 1;
                    v1 = var10_12;
                    this.processorUsage[v1] = this.processorUsage[v1] + var13_17;
                    v2 = var10_12;
                    this.packUsage[v2] = this.packUsage[v2] + this.tloArray[var10_12][var12_14].getPackUsage();
                    v3 = var14_18;
                    var9_11[v3] = var9_11[v3] + this.tloArray[var10_12][var12_14].getNetUsage();
                } else {
                    v4 = var10_12;
                    this.idleUsage[v4] = this.idleUsage[v4] + var13_17;
                }
                ++var12_14;
            }
            this.entryUsageList[var10_12] = new OrderedUsageList();
            var13_15 = 0;
            while (var13_15 < Analysis.getNumUserEntries()) {
                if (var9_11[var13_15] > 0.0f) {
                    this.entryUsageList[var10_12].insert(var9_11[var13_15], var13_15);
                }
                ++var13_15;
            }
            ++var10_12;
        }
    }

    private TimelineObject[] getData(int n, int n2) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.mesgVector[n] = new Vector();
        Analysis.createTL(n, this.beginTime, this.endTime, vector, vector2);
        int n3 = vector2.size();
        if (n3 > 0) {
            this.userEventsArray[n2] = new UserEvent[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.userEventsArray[n2][n4] = (UserEvent)vector2.elementAt(n4);
                ++n4;
            }
        } else {
            this.userEventsArray[n2] = null;
        }
        int n5 = vector.size();
        TimelineObject[] timelineObjectArray = new TimelineObject[n5];
        int n6 = 0;
        while (n6 < n5) {
            TimelineEvent timelineEvent = (TimelineEvent)vector.elementAt(n6);
            long l = timelineEvent.BeginTime;
            long l2 = timelineEvent.EndTime;
            int n7 = timelineEvent.EntryPoint;
            int n8 = timelineEvent.SrcPe;
            int n9 = timelineEvent.MsgLen;
            ObjectId objectId = timelineEvent.id;
            long l3 = timelineEvent.RecvTime;
            int n10 = timelineEvent.EventID;
            Vector vector3 = timelineEvent.MsgsSent;
            int n11 = vector3 == null ? 0 : vector3.size();
            TimelineMessage[] timelineMessageArray = new TimelineMessage[n11];
            int n12 = 0;
            while (n12 < n11) {
                timelineMessageArray[n12] = (TimelineMessage)vector3.elementAt(n12);
                this.mesgVector[n].addElement((TimelineMessage)vector3.elementAt(n12));
                ++n12;
            }
            Vector vector4 = timelineEvent.PackTimes;
            int n13 = vector4 == null ? 0 : vector4.size();
            PackTime[] packTimeArray = new PackTime[n13];
            int n14 = 0;
            while (n14 < n13) {
                packTimeArray[n14] = (PackTime)vector4.elementAt(n14);
                ++n14;
            }
            timelineObjectArray[n6] = new TimelineObject(this, l, l2, n7, timelineMessageArray, packTimeArray, n, n8, n9, l3, objectId, n10);
            ++n6;
        }
        return timelineObjectArray;
    }

    public int getNumUserEvents() {
        if (this.userEventsArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.userEventsArray.length) {
            if (this.userEventsArray[n2] != null) {
                n += this.userEventsArray[n2].length;
            }
            ++n2;
        }
        return n;
    }

    public void drawConnectingLine(int n, long l, int n2, long l2, TimelineObject timelineObject, int n3) {
        int n4;
        Dimension dimension = this.displayCanvas.getSize();
        double d = this.pixelIncrement / (double)this.timeIncrement;
        long l3 = this.endTime - this.beginTime + 1L;
        int n5 = dimension.width;
        int n6 = this.offset + (int)((double)(this.endTime - this.beginTime) * this.pixelIncrement / (double)this.timeIncrement);
        int n7 = timelineObject.h;
        int n8 = timelineObject.startY;
        this.processorList.reset();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (n3 == 2) {
            boolean bl = false;
            int n12 = 0;
            while (n12 < this.mesgCreateExecVector.size()) {
                TimelineLine timelineLine = (TimelineLine)this.mesgCreateExecVector.elementAt(n12);
                if (timelineLine.pCurrent == n2 && timelineLine.executiontime == l2) {
                    bl = true;
                    break;
                }
                ++n12;
            }
            if (bl) {
                this.mesgCreateExecVector.remove(n12);
            }
            this.displayCanvas.repaint();
            return;
        }
        int n13 = 0;
        while (n13 < this.processorList.size()) {
            n4 = this.processorList.nextElement();
            if (n4 == n) {
                n9 = n11;
            }
            if (n4 == n2) {
                n10 = n11;
            }
            ++n11;
            ++n13;
        }
        this.processorList.reset();
        double d2 = (double)dimension.height / (double)this.processorList.size();
        n4 = (int)((double)(l - this.beginTime) * d + (double)this.offset);
        int n14 = (int)((double)(l2 - this.beginTime) * d + (double)this.offset);
        int n15 = (int)(d2 * (double)n9 + (double)n7 + (double)n8 + 5.0 + 5.0);
        int n16 = (int)(d2 * (double)n10 + (double)n7);
        TimelineLine timelineLine = new TimelineLine(n, n2, timelineObject, l, l2);
        this.mesgCreateExecVector.add(timelineLine);
        this.displayCanvas.repaint();
    }

    public void drawAllLines() {
        Graphics graphics = this.displayCanvas.getGraphics();
        if (!this.mesgCreateExecVector.isEmpty()) {
            graphics.setColor(new Color(100, 100, 255));
            Dimension dimension = this.displayCanvas.getSize();
            double d = this.pixelIncrement / (double)this.timeIncrement;
            double d2 = (double)dimension.height / (double)this.processorList.size();
            int n = 0;
            while (n < this.mesgCreateExecVector.size()) {
                int n2;
                TimelineLine timelineLine = (TimelineLine)this.mesgCreateExecVector.elementAt(n);
                int n3 = 0;
                int n4 = 0;
                this.processorList.reset();
                int n5 = 0;
                while (n5 < this.processorList.size()) {
                    n2 = this.processorList.nextElement();
                    if (n2 == timelineLine.pCreation) {
                        n3 = n5;
                    }
                    if (n2 == timelineLine.pCurrent) {
                        n4 = n5;
                    }
                    ++n5;
                }
                n2 = (int)((double)(timelineLine.creationtime - this.beginTime) * d + (double)this.offset);
                int n6 = (int)((double)(timelineLine.executiontime - this.beginTime) * d + (double)this.offset);
                int n7 = (int)(d2 * (double)n3 + (double)timelineLine.obj.h + (double)timelineLine.obj.startY + 5.0 + 5.0);
                int n8 = (int)(d2 * (double)n4 + (double)timelineLine.obj.h);
                graphics.drawLine(n2, n7, n6, n8);
                ++n;
            }
        }
    }

    public void clearAllLines() {
        if (this.tloArray != null) {
            int n = 0;
            while (n < this.tloArray.length) {
                if (this.tloArray[n] != null) {
                    int n2 = 0;
                    while (n2 < this.tloArray[n].length) {
                        if (this.tloArray[n][n2] != null) {
                            this.tloArray[n][n2].clearCreationLine();
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        this.mesgCreateExecVector.clear();
    }

    public void addProcessor(int n) {
        this.oldplist = this.processorList.copyOf();
        this.processorList.insert(n);
        this.numPs = this.processorList.size();
        this.processorString = this.processorList.listToString();
        this.timelineWindow.procRangeDialog(false);
    }
}

