/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import projections.gui.FloatTextField;
import projections.gui.Util;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;

public class GraphPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final Color BACKGROUND = Color.black;
    private static final Color FOREGROUND = Color.white;
    private JPanel mainPanel;
    private JScrollPane displayPanel;
    private Graph displayCanvas;
    private Button bIncreaseX;
    private Button bDecreaseX;
    private Button bResetX;
    private Checkbox cbLineGraph;
    private Checkbox cbBarGraph;
    private Label lScale;
    private FloatTextField scaleField;

    public GraphPanel(Graph graph) {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (GraphPanel.this.mainPanel != null) {
                    GraphPanel.this.displayCanvas.setBounds(GraphPanel.this.displayPanel.getViewportBorderBounds());
                    GraphPanel.this.displayCanvas.repaint();
                }
            }
        });
        this.setBackground(Color.lightGray);
        this.displayCanvas = graph;
        this.createLayout();
    }

    private void createLayout() {
        this.lScale = new Label("X-Axis Scale: ", 1);
        this.scaleField = new FloatTextField(1.0f, 5);
        this.scaleField.addActionListener(this);
        this.bDecreaseX = new Button("<<");
        this.bIncreaseX = new Button(">>");
        this.bResetX = new Button("Reset");
        this.bIncreaseX.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.cbLineGraph = new Checkbox("Line Graph", false, checkboxGroup);
        this.cbBarGraph = new Checkbox("Bar Graph", true, checkboxGroup);
        this.cbLineGraph.addItemListener(this);
        this.cbBarGraph.addItemListener(this);
        if (this.displayCanvas.getGraphType() == 5) {
            this.cbLineGraph.setState(true);
            this.cbBarGraph.setState(false);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        Util.gblAdd(jPanel, this.cbLineGraph, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.cbBarGraph, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.bDecreaseX, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.lScale, gridBagConstraints, 3, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.scaleField, gridBagConstraints, 4, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.bIncreaseX, gridBagConstraints, 5, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.bResetX, gridBagConstraints, 6, 0, 1, 1, 1, 0);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gridBagLayout);
        this.displayPanel = new JScrollPane(this.displayCanvas);
        Util.gblAdd(this.mainPanel, this.displayPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this, jPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public Dimension getMinimumSize() {
        return new Dimension(500, 400);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 400);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = this.scaleField.getValue();
        float f2 = 0.0f;
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bDecreaseX) {
                f2 = (float)((int)(f * 4.0f) - 1) / 4.0f;
                if ((double)f2 < 1.0) {
                    f2 = 1.0f;
                }
            } else if (button == this.bIncreaseX) {
                f2 = (float)((int)(f * 4.0f) + 1) / 4.0f;
            } else if (button == this.bResetX) {
                f2 = 1.0f;
            }
            if (f2 != f) {
                this.scaleField.setText("" + f2);
                this.displayCanvas.setScale(f2);
            }
        } else if (actionEvent.getSource() instanceof FloatTextField) {
            f2 = f;
            this.displayCanvas.setScale(f2);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        if (checkbox == this.cbLineGraph) {
            this.displayCanvas.setGraphType(5);
        } else if (checkbox == this.cbBarGraph) {
            this.displayCanvas.setGraphType(4);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        double[][] dArrayArray = new double[][]{{20.0, 2100.0, 49.0, 3.0}, {25.0, 34.0, 8.0, 10.0}, {23.0, 20.0, 54.0, 3.0}, {2000.0, 27.0, 4.0, 40.0}, {25.0, 21.0, 7.0, 4.0}, {20.0, 21.0, 8.0, 10.0}, {24.0, 26.0, 44.0, 4.0}, {22.0, 26.0, 20.0, 5.0}, {29.0, 29.0, 5.0, 20.0}, {20.0, 21.0, 8.0, 7.0}, {24.0, 20.0, 10.0, 3.0}, {21.0, 25.0, 6.0, 8.0}, {34.0, 23.0, 11.0, 11.0}, {20.0, 20.0, 20.0, 20.0}, {27.0, 25.0, 4.0, 5.0}, {21.0, 20.0, 5.0, 7.0}, {21.0, 24.0, 5.0, 8.0}, {26.0, 22.0, 5.0, 3.0}, {26.0, 29.0, 7.0, 10.0}, {29.0, 20.0, 8.0, 6.0}, {21.0, 24.0, 9.0, 4.0}};
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        DataSource2D dataSource2D = new DataSource2D("Histogram", dArrayArray);
        XAxisFixed xAxisFixed = new XAxisFixed("Entry Point Execution Time", "ms");
        YAxisAuto yAxisAuto = new YAxisAuto("Count", "", dataSource2D);
        Graph graph = new Graph();
        graph.setGraphType(5);
        graph.setBarGraphType(1);
        graph.setData(dataSource2D, xAxisFixed, yAxisAuto);
        GraphPanel graphPanel = new GraphPanel(graph);
        JMenuBar jMenuBar = new JMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Trial Item");
        jMenu.add(jMenuItem);
        jFrame.getContentPane().add(graphPanel);
        jFrame.pack();
        ((Component)jFrame).setSize(800, 600);
        jFrame.setTitle("Projections");
        ((Component)jFrame).setVisible(true);
    }
}

