/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Label;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class CcsImagePanel
extends MemImagePanel {
    int redrawCount = 0;
    Label status;
    CcsThread ccs;
    Controller3d cntl = null;
    Toolbar tools;
    Config config = null;
    private boolean imageRequested = false;
    private volatile ByteImage curImg;
    int lastWid = 200;
    int lastHt = 150;

    public CcsImagePanel(MainPanel mainPanel, Label label, Toolbar toolbar, String string, int n) {
        this.tools = toolbar;
        this.ccs = new CcsThread(label, string, n);
        this.ccs.addRequest(new CcsConfigRequest(this, mainPanel));
    }

    public void stop() {
        this.ccs.finish();
    }

    private void debug(String string) {
    }

    public void gotConfig(Vector3d vector3d, Vector3d vector3d2) {
        if (this.config.is3d) {
            System.out.println("Box size: " + vector3d + " to " + vector3d2);
            this.cntl = new Controller3d(this, this.tools, vector3d, vector3d2, this.lastWid, this.lastHt);
        }
        if (!this.imageRequested) {
            this.debug("Sending request from gotConfig");
            this.requestImage();
        }
    }

    public void requestImage() {
        this.imageRequested = true;
        Controller3d.ImageRequest3d imageRequest3d = null;
        if (this.cntl != null) {
            imageRequest3d = this.cntl.get3dRequest();
        }
        this.ccs.addRequest(new CcsImageRequest(this, imageRequest3d), true);
    }

    public void gotImage(ByteImage byteImage) {
        this.curImg = byteImage;
        this.debug("gotImage");
        this.imageRequested = false;
        this.repaint(1L);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.cntl != null) {
            this.cntl.paint(graphics, this.getSize());
        }
    }

    public void fillBuffer(int[] nArray, int n, int n2) {
        ByteImage byteImage;
        this.lastWid = n;
        this.lastHt = n2;
        if (this.cntl != null) {
            this.cntl.updateSize(n, n2);
        }
        if ((byteImage = this.curImg) == null) {
            return;
        }
        byte[] byArray = byteImage.data;
        int n3 = n;
        int n4 = n2;
        if (n3 > byteImage.wid) {
            n3 = byteImage.wid;
        }
        if (n4 > byteImage.ht) {
            n4 = byteImage.ht;
        }
        this.debug("redraw");
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (byteImage.isColor) {
                n12 = n5 * byteImage.wid * 3;
                n11 = n5 * n;
                n10 = 0;
                while (n10 < n3) {
                    n9 = 255;
                    n8 = byArray[n12 + n10 * 3 + 0] & 0xFF;
                    n7 = byArray[n12 + n10 * 3 + 1] & 0xFF;
                    n6 = byArray[n12 + n10 * 3 + 2] & 0xFF;
                    nArray[n11 + n10] = (n9 << 24) + (n8 << 16) + (n7 << 8) + n6;
                    ++n10;
                }
            } else {
                n12 = n5 * byteImage.wid;
                n11 = n5 * n;
                n10 = 0;
                while (n10 < n3) {
                    n9 = byArray[n12 + n10 + 0] & 0xFF;
                    n8 = 255;
                    n7 = n9;
                    n6 = n9;
                    int n13 = n9;
                    nArray[n11 + n10] = (n8 << 24) + (n7 << 16) + (n6 << 8) + n13;
                    ++n10;
                }
            }
            ++n5;
        }
        if (!this.imageRequested && (n != byteImage.wid || n2 != byteImage.ht || this.config.isPush)) {
            this.debug("Sending request from fillBuffer");
            this.requestImage();
        }
    }

    private class CcsImageRequest
    extends CcsThread.request {
        int wid;
        int ht;
        CcsImagePanel dest;

        public CcsImageRequest(CcsImagePanel ccsImagePanel2, Controller3d.ImageRequest3d imageRequest3d) {
            super("lvImage", null);
            this.dest = ccsImagePanel2;
            this.wid = CcsImagePanel.this.lastWid;
            this.ht = CcsImagePanel.this.lastHt;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(this.wid);
                dataOutputStream.writeInt(this.ht);
                if (imageRequest3d != null) {
                    imageRequest3d.x.write(dataOutputStream);
                    imageRequest3d.y.write(dataOutputStream);
                    imageRequest3d.z.write(dataOutputStream);
                    imageRequest3d.o.write(dataOutputStream);
                    dataOutputStream.writeDouble(imageRequest3d.minZ);
                    dataOutputStream.writeDouble(imageRequest3d.maxZ);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setData(byteArrayOutputStream.toByteArray());
        }

        public void handleReply(byte[] byArray) {
            this.dest.gotImage(new ByteImage(byArray, this.wid, this.ht, CcsImagePanel.this.config.isColor));
        }
    }

    private class CcsConfigRequest
    extends CcsThread.request {
        CcsImagePanel dest;
        MainPanel caller;

        public CcsConfigRequest(CcsImagePanel ccsImagePanel2, MainPanel mainPanel) {
            super("lvConfig", 0);
            this.dest = ccsImagePanel2;
            this.caller = mainPanel;
        }

        public void handleReply(byte[] byArray) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                CcsImagePanel.this.config = new Config(dataInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            System.out.println("Config values: color=" + CcsImagePanel.this.config.isColor + " push=" + CcsImagePanel.this.config.isPush + " 3d=" + CcsImagePanel.this.config.is3d + "\n");
            CcsImagePanel.this.gotConfig(CcsImagePanel.this.config.min, CcsImagePanel.this.config.max);
            this.caller.createGrid();
        }
    }

    private static class ByteImage {
        public int wid;
        public int ht;
        public byte[] data;
        public boolean isColor;

        public ByteImage(byte[] byArray, int n, int n2, boolean bl) {
            this.data = byArray;
            this.wid = n;
            this.ht = n2;
            this.isColor = bl;
        }
    }
}

