/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class CcsServer {
    protected InetAddress hostIP;
    protected int hostPort;
    protected int numNodes;
    protected int numPes;
    protected int[] nodeFirst;
    protected int[] nodeSize;
    protected Socket replySocket;
    protected boolean printDebug = false;

    public CcsServer(InetAddress inetAddress, int n) throws IOException {
        this.connect(inetAddress, n);
    }

    public CcsServer(String string, int n) throws IOException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        this.connect(inetAddress, n);
    }

    public CcsServer(String string) throws IOException, NumberFormatException {
        Serializable serializable;
        int n = string.indexOf("=");
        int n2 = string.indexOf("=", n + 1);
        String string2 = string.substring(n + 1, string.indexOf(",")).trim();
        String string3 = string.substring(n2 + 1, string.indexOf("$")).trim();
        long l = Long.parseLong(string2);
        int n3 = Integer.parseInt(string3);
        if (l < 0L) {
            l += 0x100000000L;
        }
        String string4 = "";
        int n4 = 3;
        while (n4 >= 0) {
            serializable = new Long(0xFFL & l >> 8 * n4);
            string4 = string4 + ((Long)serializable).toString();
            if (n4 > 0) {
                string4 = string4 + ".";
            }
            --n4;
        }
        serializable = null;
        try {
            serializable = InetAddress.getByName(string4);
        }
        catch (UnknownHostException unknownHostException) {
            throw new NumberFormatException(unknownHostException.toString());
        }
        this.connect((InetAddress)serializable, n3);
    }

    public Socket sendRequest(String string, int n) throws IOException {
        return this.sendRequest(string, n, null);
    }

    public Socket sendRequest(String string, int n, byte[] byArray) throws IOException {
        System.out.println("  Connecting for request '" + string + "'");
        this.replySocket = new Socket(this.hostIP, this.hostPort);
        this.debug("  Connected.  Sending header");
        System.out.println("Sender is " + this.hostIP + "\n");
        DataOutputStream dataOutputStream = new DataOutputStream(this.replySocket.getOutputStream());
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n);
        int n3 = 32;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        n4 = 0;
        while (n4 < string.length()) {
            byArray2[n4] = (byte)string.charAt(n4);
            ++n4;
        }
        n4 = string.length();
        while (n4 < n3) {
            byArray2[n4] = 0;
            ++n4;
        }
        dataOutputStream.write(byArray2, 0, n3);
        this.debug("  Header sent.  Sending " + n2 + " bytes of request data");
        this.debug("Handle is " + byArray2 + "\n");
        if (byArray != null) {
            dataOutputStream.write(byArray);
        }
        dataOutputStream.flush();
        this.debug("  Request sent");
        return this.replySocket;
    }

    public byte[] recvResponse() throws IOException {
        return this.recvResponse(this.replySocket);
    }

    public byte[] recvResponse(Socket socket) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        int n = dataInputStream.readInt();
        this.debug("  Response: " + n + " bytes");
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        socket.close();
        return byArray;
    }

    public boolean hasResponse(Socket socket) throws IOException {
        if (socket == null) {
            throw new IOException("Null socket!");
        }
        return socket.getInputStream().available() > 0;
    }

    public void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            socket = null;
        }
    }

    public void close() {
        this.close(this.replySocket);
        this.replySocket = null;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumPes() {
        return this.numPes;
    }

    public int getNodeFirst(int n) {
        return this.nodeFirst[n];
    }

    public int getNodeSize(int n) {
        return this.nodeSize[n];
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.hostIP = inetAddress;
        this.hostPort = n;
        this.debug("Connecting...");
        this.sendRequest("ccs_getinfo", 0);
        this.debug("Connected.  Getting machine info.");
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.recvResponse()));
        this.debug("Parsing machine info");
        this.numNodes = dataInputStream.readInt();
        this.nodeFirst = new int[this.numNodes];
        this.nodeSize = new int[this.numNodes];
        this.numPes = 0;
        int n2 = 0;
        while (n2 < this.numNodes) {
            this.nodeFirst[n2] = this.numPes;
            this.nodeSize[n2] = dataInputStream.readInt();
            this.numPes += this.nodeSize[n2];
            ++n2;
        }
    }

    protected void debug(String string) {
        if (this.printDebug) {
            System.out.println("CcsServer: " + string);
        }
    }
}

