/*
Local openGL utility routines.

Orion Sky Lawlor, olawlor@acm.org, 8/13/2002
*/

#ifndef __UIUC_PPL_CHARM_GLUTIL_H
#define __UIUC_PPL_CHARM_GLUTIL_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include "ckvector3d.h"

// Check GL for errors after the last command
void GLcheck(const char *where);

enum GLtexture_t {
  GLtexture_nearest=0, //Nearest-neighbor interpolation
  GLtexture_linear=1, //Linear interpolation
  GLtexture_mipmap=2 //Mipmapping
};

/*
Bind a (wid x ht) RGBA image to an OpenGL texture object
*/
class GLtexture {
	GLuint texName;
	GLtexture(const GLtexture &src); /*do not use*/
	void operator=(const GLtexture &src); /*do not use*/
public:
	//Bind an OpenGL texture for these pixels
	//  Pixels are copied out, and can be deleted after the call.
	GLtexture(const GLubyte *imagePixels, int wid,int ht,
		int srcFormat=4, int destFormat=GL_RGBA,
		int texWrap=GL_CLAMP,int texMode=GL_MODULATE);
	
	//Reclaim the texture memory used by this object
	~GLtexture();
	
	//Bind this texture into the current environment
	void bind(void) const;
};

/*Draw an OpenGL texture in a quadrilateral*/
void GLtextureQuad(const GLtexture &tex,
	const CkVector3d &tl,const CkVector3d &tr,
	const CkVector3d &bl,const CkVector3d &br,
	GLtexture_t type=GLtexture_mipmap);

/*Draw a line between these two points*/
void GLline(const CkVector3d &s,const CkVector3d &e);

inline void GLrepaint(int nMilliseconds) {
	glutPostRedisplay();
}

#endif /*def(thisHeader)*/
