#!/bin/sh

Do() {
	echo "Running>" $@
	$@ || exit 1
}

# figure out how big a block to make:
nx=4
ny=8
nz=3
block="block001.msh"
echo "Making $nx x $ny x $nz block as $block..."
Do ../simpleblock $block \
	0.0 10.0 $nx \
	0.0 20.0 $ny \
	0.0 5.0 $nz 

# Divide up the new block:
nPieces=2
out="2out"
echo "Splitting $block into $nPieces pieces..."
Do ../makemblock $block $nPieces $out
