#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define MCHARM  0        // migratable charm jobs, started on all processors.
#define MPI     1        // MPI jobs.
#define NCHARM  2        // Non migratable charm jobs, default.
#define UNI     3        // Uni processor jobs.

#define QUEUED    0
#define RUNNING   1
#define CONNECTED 2
#define SUSPENDED 3
#define FINISHED  4
#define SCHEDULED 5
#define REJECTED  6
#define BITMAPSET 7

#define MAX_STRING_SIZE 256

class Job{
 public:  
    /*
    unsigned int port,ip,pid;
    int client_soc_fd;
    */

    int type, priority;
    int req_min_proc;           //Determines memory requirements.	
    int min_proc;               //Influenced by deadline.
    int max_proc;
    int num_system_proc;
    int num_allocated_proc;
    int dbid;
    
    double work;             // computation
    double deadline;         // deadline
    double profit;           // profit
    double arrivalTime;       // Time when job arrived.
    double startTime;         // Time when job started.

    char *bit_map;
    /*
    CcsServer svr;    
    char ** argv;
    char argbuf[1024];
    
    char *working_directory;
    char *Stdin, *Stdout, *Stderr;

    char name[MAX_STRING_SIZE];
    */
    int status;
    int bitmap_changed;
    Job *next;
    
    Job(int nproc);
    ~Job();
    
    /*
    void parse_query(char *query);
    void init_arg();

    int connect();
    int ping();
    void Kill();
    int set_bitmap();    
    */

    void add_proc(int p);
    int delete_proc();
    int delete_all(char *bit_map);

    //    void started();
};

class SchedulingStrategy{
 public:
      
    virtual int is_available(Job *j, Job *waitq, Job *runq) = 0;
    virtual void allocate_processors(Job *waitq, Job *runq) = 0;
    
    char *free_proc_vector;
    int num_free_proc;
    int nproc;
};

#endif
