/*****************************************************************************
 * $Source: /cvsroot/charm/src/ck-ldb/GreedyLB.C,v $
 * $Author: gzheng $
 * $Date: 2003/08/07 16:07:08 $
 * $Revision: 1.6 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

/*
 status:
  * support processor avail bitvector
  * support nonmigratable attrib
*/

#include <charm++.h>

#if CMK_LBDB_ON

#include "cklists.h"
#include "GreedyLB.h"

void CreateGreedyLB()
{
  //  CkPrintf("[%d] creating GreedyLB %d\n",CkMyPe(),loadbalancer);
  loadbalancer = CProxy_GreedyLB::ckNew();
  //  CkPrintf("[%d] created GreedyLB %d\n",CkMyPe(),loadbalancer);
}

static void lbinit(void) {
//        LBSetDefaultCreate(CreateGreedyLB);        
  LBRegisterBalancer("GreedyLB", CreateGreedyLB, "always assign the heaviest obj onto lightest loaded processor.");
}

#include "GreedyLB.def.h"

GreedyLB::GreedyLB()
{
  lbname = "GreedyLB";
  if (CkMyPe()==0)
    CkPrintf("[%d] GreedyLB created\n",CkMyPe());
}

CmiBool GreedyLB::QueryBalanceNow(int _step)
{
  //  CkPrintf("[%d] Balancing on step %d\n",CkMyPe(),_step);
  return CmiTrue;
}

CmiBool  GreedyLB::Compare(double x, double y, HeapCmp cmp)
{
  const int test =  ((cmp == GT) ? (x > y) : (x < y));

  if (test) return CmiTrue; 
  else return CmiFalse;
}


void GreedyLB::Heapify(HeapData *heap, int node, int heapSize, HeapCmp cmp)
{
  int left = 2*node+1;
  int right = 2*node+2;
  int xchange;

  //heap[left].load > heap[node].load)
  if (left <= heapSize &&  Compare(heap[left].load, heap[node].load, cmp))
    xchange = left;
  else xchange = node;
  //heap[right].load > heap[xchange].load) 
  if (right <= heapSize && Compare(heap[right].load, heap[xchange].load, cmp))
    xchange = right;

  if (xchange != node) {
    HeapData obj;
    obj = heap[node];
    heap[node] = heap[xchange];
    heap[xchange] = obj;
    Heapify(heap, xchange, heapSize, cmp);
  }    
}

void GreedyLB::BuildHeap(HeapData *data, int heapSize, HeapCmp cmp)
{
	int i;
	for(i=heapSize/2; i >= 0; i--)
		Heapify(data, i, heapSize, cmp);
}

void GreedyLB::HeapSort(HeapData *data, int heapSize, HeapCmp cmp)
{
	int i;
	HeapData key;

	BuildHeap(data, heapSize, cmp);
	for (i=heapSize; i > 0; i--) {
		key = data[0];
		data[0] = data[i];
		data[i] = key;
		heapSize--;
		Heapify(data, 0, heapSize, cmp);
	}
}

GreedyLB::HeapData* 
GreedyLB::BuildObjectArray(CentralLB::LDStats* stats, 
                             int count, int *objCount)
{
  HeapData *objData;

  *objCount = 0;
  int obj;
  *objCount += stats->n_objs;

//for (obj = 0; obj < stats[pe].n_objs; obj++)
//if (stats[pe].objData[obj].migratable == CmiTrue) (*objCount)++; 

  objData  = new HeapData[*objCount];
  *objCount = 0; 
  for(obj=0; obj < stats->n_objs; obj++) {
    LDObjData &oData = stats->objData[obj];
    int pe = stats->from_proc[obj];
    if (!oData.migratable) {
      if (!stats->procs[pe].available) 
        CmiAbort("GreedyLB cannot handle nonmigratable object on an unavial processor!\n");
      continue;
    }
    objData[*objCount].load = oData.wallTime * stats->procs[pe].pe_speed;
    objData[*objCount].pe = pe;
    objData[*objCount].id = obj;
    (*objCount)++;
  }
  
  HeapSort(objData, *objCount-1, GT);
  return objData;
}

GreedyLB::HeapData* 
GreedyLB::BuildCpuArray(CentralLB::LDStats* stats, 
                          int count, int *peCount)
{
  int pe;

  *peCount = 0;
  for (pe = 0; pe < count; pe++)
    if (stats->procs[pe].available) (*peCount)++;
  HeapData *data = new HeapData[*peCount];
  int *map = new int[count];
  
  *peCount = 0;
  for (pe=0; pe < count; pe++) {
    CentralLB::ProcStats &peData = stats->procs[pe];
 
    data[*peCount].load = 0.0;
    map[pe] = -1;
    if (peData.available) 
    {
      data[*peCount].load += peData.bg_walltime;
      data[*peCount].pe = data[*peCount].id = pe;
      map[pe] = *peCount;
      (*peCount)++;
    }
  }

  // take non migratbale object load as background load
  for (int obj = 0; obj < stats->n_objs; obj++) 
  { 
      LDObjData &oData = stats->objData[obj];
      if (!oData.migratable)  {
        int pe = stats->from_proc[obj];
        pe = map[pe];
        if (pe==-1) 
          CmiAbort("GreedyLB: nonmigratable object on an unavail processor!\n");
        data[pe].load += oData.wallTime;
      }
  }

  // considering cpu speed
  for (pe = 0; pe<*peCount; pe++)
    data[pe].load *= stats->procs[data[pe].pe].pe_speed;

  BuildHeap(data, *peCount-1, LT);     // minHeap
  delete [] map;
  return data;
}

void GreedyLB::work(CentralLB::LDStats* stats, int count)
{
  int  obj, heapSize, objCount;
  int *pemap = new int [count];
  HeapData *cpuData = BuildCpuArray(stats, count, &heapSize);
  HeapData *objData = BuildObjectArray(stats, count, &objCount);

  //  CkPrintf("[%d] GreedyLB strategy\n",CkMyPe());

  heapSize--;
  for (obj=0; obj < objCount; obj++) {
    HeapData minCpu;  
    // Operation of extracting the the least loaded processor
    // from the heap
    minCpu = cpuData[0];
    cpuData[0] = cpuData[heapSize];
    heapSize--;
    Heapify(cpuData, 0, heapSize, LT);    

    // Increment the time of the least loaded processor by the cpuTime of
    // the `heaviest' object
    minCpu.load += objData[obj].load;

    //Insert object into migration queue if necessary
    const int dest = minCpu.pe;
    const int pe   = objData[obj].pe;
    const int id   = objData[obj].id;
    if (dest != pe) {
      stats->to_proc[id] = dest;
      //  CkPrintf("[%d] Obj %d migrating from %d to %d\n",
      //           CkMyPe(),obj,pe,dest);
    }

    //Insert the least loaded processor with load updated back into the heap
    heapSize++;
    int location = heapSize;
    while (location>0 && cpuData[(location-1)/2].load > minCpu.load) {
      cpuData[location] = cpuData[(location-1)/2];
      location = (location-1)/2;
    }
    cpuData[location] = minCpu;
  }

  delete [] cpuData;
  delete [] objData;
}


#endif


/*@}*/




