#include "ampi.h"
#include "ampiimpl.h"

FDECL {
#define mpi_send FTN_NAME( MPI_SEND , mpi_send )
#define mpi_recv FTN_NAME( MPI_RECV , mpi_recv )
#define mpi_get_count FTN_NAME( MPI_GET_COUNT , mpi_get_count )
#define mpi_isend FTN_NAME( MPI_ISEND , mpi_isend )
#define mpi_irecv FTN_NAME( MPI_IRECV , mpi_irecv )
#define mpi_wait FTN_NAME( MPI_WAIT , mpi_wait )
#define mpi_test FTN_NAME( MPI_TEST , mpi_test )
#define mpi_waitany FTN_NAME( MPI_WAITANY , mpi_waitany )
#define mpi_testany FTN_NAME( MPI_TESTANY , mpi_testany )
#define mpi_waitall FTN_NAME( MPI_WAITALL , mpi_waitall )
#define mpi_testall FTN_NAME( MPI_TESTALL , mpi_testall )
#define mpi_waitsome FTN_NAME( MPI_WAITSOME , mpi_waitsome )
#define mpi_testsome FTN_NAME( MPI_TESTSOME , mpi_testsome )
#define mpi_request_free FTN_NAME(MPI_REQUEST_FREE , mpi_request_free)
#define mpi_cancel FTN_NAME(MPI_CANCEL, mpi_cancel)
#define mpi_iprobe FTN_NAME( MPI_IPROBE , mpi_iprobe )
#define mpi_probe FTN_NAME( MPI_PROBE , mpi_probe )
#define mpi_send_init FTN_NAME( MPI_SEND_INIT , mpi_send_init )
#define mpi_recv_init FTN_NAME( MPI_RECV_INIT , mpi_recv_init )
#define mpi_start FTN_NAME( MPI_START , mpi_start )
#define mpi_startall FTN_NAME( MPI_STARTALL , mpi_startall )
#define mpi_sendrecv FTN_NAME( MPI_SENDRECV , mpi_sendrecv )
#define mpi_sendrecv_replace FTN_NAME( MPI_SENDRECV_REPLACE , mpi_sendrecv_replace )
#define mpi_type_contiguous FTN_NAME( MPI_TYPE_CONTIGUOUS , mpi_type_contiguous )
#define mpi_type_vector FTN_NAME( MPI_TYPE_VECTOR , mpi_type_vector )
#define mpi_type_hvector FTN_NAME( MPI_TYPE_HVECTOR , mpi_type_hvector )
#define mpi_type_indexed FTN_NAME( MPI_TYPE_INDEXED , mpi_type_indexed )
#define mpi_type_hindexed FTN_NAME( MPI_TYPE_HINDEXED , mpi_type_hindexed )
#define mpi_type_struct FTN_NAME( MPI_TYPE_STRUCT , mpi_type_struct )
#define mpi_type_commit FTN_NAME( MPI_TYPE_COMMIT , mpi_type_commit )
#define mpi_type_free FTN_NAME( MPI_TYPE_FREE , mpi_type_free )
#define mpi_type_extent FTN_NAME( MPI_TYPE_EXTENT , mpi_type_extent )
#define mpi_type_size FTN_NAME( MPI_TYPE_SIZE , mpi_type_size )
#define mpi_type_lb FTN_NAME( MPI_TYPE_LB , mpi_type_lb )
#define mpi_type_ub FTN_NAME( MPI_TYPE_UB , mpi_type_ub )
#define mpi_address FTN_NAME( MPI_ADDRESS , mpi_address )
#define mpi_get_element FTN_NAME( MPI_GET_ELEMENT , mpi_get_element )
#define mpi_pack FTN_NAME( MPI_PACK , mpi_pack )
#define mpi_unpack FTN_NAME( MPI_UNPACK , mpi_unpack )
#define mpi_pack_size FTN_NAME( MPI_PACK_SIZE , mpi_pack_size )

#define mpi_barrier FTN_NAME( MPI_BARRIER , mpi_barrier )
#define mpi_bcast FTN_NAME( MPI_BCAST , mpi_bcast )
#define mpi_gather FTN_NAME( MPI_GATHER , mpi_gather )
#define mpi_gatherv FTN_NAME( MPI_GATHERV , mpi_gatherv )
#define mpi_scatter FTN_NAME( MPI_SCATTER , mpi_scatter )
#define mpi_scatterv FTN_NAME( MPI_SCATTERV , mpi_scatterv )
#define mpi_allgather FTN_NAME( MPI_ALLGATHER , mpi_allgather )
#define mpi_iallgather FTN_NAME( MPI_IALLGATHER , mpi_iallgather )
#define mpi_allgatherv FTN_NAME( MPI_ALLGATHERV , mpi_allgatherv )
#define mpi_alltoall FTN_NAME( MPI_ALLTOALL , mpi_alltoall )
#define mpi_ialltoall FTN_NAME( MPI_IALLTOALL , mpi_ialltoall )
#define mpi_alltoallv FTN_NAME( MPI_ALLTOALLV , mpi_alltoallv )
#define mpi_reduce FTN_NAME( MPI_REDUCE , mpi_reduce )
#define mpi_ireduce FTN_NAME( MPI_IREDUCE , mpi_ireduce )
#define mpi_allreduce FTN_NAME( MPI_ALLREDUCE , mpi_allreduce )
#define mpi_iallreduce FTN_NAME( MPI_IALLREDUCE , mpi_iallreduce )
#define mpi_reduce_scatter FTN_NAME( MPI_REDUCE_SCATTER , mpi_reduce_scatter )
#define mpi_scan FTN_NAME( MPI_SCAN , mpi_scan )

#define mpi_group_size FTN_NAME( MPI_GROUP_SIZE, mpi_group_size)
#define mpi_group_rank FTN_NAME( MPI_GROUP_RANK, mpi_group_rank)
#define mpi_group_translate_ranks FTN_NAME(MPI_GROUP_TRANSLATE_RANKS, mpi_group_translate_ranks)
#define mpi_group_compare FTN_NAME(MPI_GROUP_COMPARE, mpi_group_compare)
#define mpi_comm_group FTN_NAME( MPI_COMM_GROUP, mpi_comm_group)
#define mpi_group_union FTN_NAME(MPI_GROUP_UNION, mpi_group_union)
#define mpi_group_intersection FTN_NAME(MPI_GROUP_INTERSECTION, mpi_group_intersection)
#define mpi_group_difference FTN_NAME(MPI_GROUP_DIFFERENCE, mpi_group_difference)
#define mpi_group_incl FTN_NAME(MPI_GROUP_INCL, mpi_group_incl)
#define mpi_group_excl FTN_NAME(MPI_GROUP_EXCL, mpi_group_excl)
#define mpi_group_range_incl FTN_NAME(MPI_GROUP_RANGE_INCL, mpi_group_range_incl)
#define mpi_group_range_excl FTN_NAME(MPI_GROUP_RANGE_EXCL, mpi_group_range_excl)
#define mpi_group_free FTN_NAME(MPI_GROUP_FREE, mpi_group_free)
#define mpi_comm_create FTN_NAME(MPI_COMM_CREATE, mpi_comm_create)
#define mpi_comm_rank FTN_NAME( MPI_COMM_RANK , mpi_comm_rank )
#define mpi_comm_size FTN_NAME( MPI_COMM_SIZE , mpi_comm_size )
#define mpi_comm_dup FTN_NAME( MPI_COMM_DUP , mpi_comm_dup )
#define mpi_comm_split FTN_NAME( MPI_COMM_SPLIT , mpi_comm_split )
#define mpi_comm_free FTN_NAME( MPI_COMM_FREE , mpi_comm_free )
#define mpi_comm_test_inter FTN_NAME( MPI_COMM_TEST_INTER , mpi_comm_test_inter )

#define mpi_cart_create FTN_NAME ( MPI_CART_CREATE , mpi_cart_create )
#define mpi_graph_create FTN_NAME ( MPI_GRAPH_CREATE , mpi_graph_create )
#define mpi_topo_test FTN_NAME ( MPI_TOPO_TEST , mpi_topo_test )
#define mpi_cart_map FTN_NAME ( MPI_CART_MAP , mpi_cart_map )
#define mpi_graph_map FTN_NAME ( MPI_GRAPH_MAP , mpi_graph_map )
#define mpi_cartdim_get FTN_NAME ( MPI_CARTDIM_GET , mpi_cartdim_get )
#define mpi_cart_get FTN_NAME ( MPI_CART_GET , mpi_cart_get )
#define mpi_cart_rank FTN_NAME ( MPI_CART_RANK , mpi_cart_rank )
#define mpi_cart_coords FTN_NAME ( MPI_CART_COORDS , mpi_cart_coords )
#define mpi_cart_shift FTN_NAME ( MPI_CART_SHIFT , mpi_cart_shift )
#define mpi_graphdims_get FTN_NAME ( MPI_GRAPHDIMS_GET , mpi_graphdims_get )
#define mpi_graph_get FTN_NAME ( MPI_GRAPH_GET , mpi_graph_get )
#define mpi_graph_neighbors_count FTN_NAME ( MPI_GRAPH_NEIGHBORS_COUNT , mpi_graph_neighbors_count )
#define mpi_graph_neighbors FTN_NAME ( MPI_GRAPH_NEIGHBORS , mpi_graph_neighbors )
#define mpi_dims_create FTN_NAME ( MPI_DIMS_CREATE , mpi_dims_create )
#define mpi_cart_sub FTN_NAME ( MPI_CART_SUB , mpi_cart_sub )

#define mpi_get_processor_name FTN_NAME ( MPI_GET_PROCESSOR_NAME , mpi_get_processor_name )
#define mpi_errhandler_create FTN_NAME( MPI_ERRHANDLER_CREATE , mpi_errhandler_create )
#define mpi_errhandler_set FTN_NAME( MPI_ERRHANDLER_SET , mpi_errhandler_set )
#define mpi_errhandler_get FTN_NAME( MPI_ERRHANDLER_GET , mpi_errhandler_get )
#define mpi_errhandler_free FTN_NAME( MPI_ERRHANDLER_FREE , mpi_errhandler_free )
#define mpi_error_string FTN_NAME( MPI_ERROR_STRING , mpi_error_string )
#define mpi_error_class FTN_NAME( MPI_ERROR_CLASS , mpi_error_class )
#define mpi_wtime FTN_NAME( MPI_WTIME , mpi_wtime )
#define mpi_wtick FTN_NAME( MPI_WTICK , mpi_wtick )
#define mpi_init FTN_NAME( MPI_INIT , mpi_init )
#define mpi_initialized FTN_NAME( MPI_INITIALIZED , mpi_initialized )
#define mpi_init_universe FTN_NAME( MPI_INIT_UNIVERSE , mpi_init_universe )
#define mpi_finalize FTN_NAME( MPI_FINALIZE , mpi_finalize )
#define mpi_abort FTN_NAME( MPI_ABORT , mpi_abort )

#define mpi_print FTN_NAME( MPI_PRINT , mpi_print )
#define mpi_register FTN_NAME( MPI_REGISTER , mpi_register )
#define mpi_migrate FTN_NAME( MPI_MIGRATE , mpi_migrate )
#define mpi_checkpoint FTN_NAME( MPI_CHECKPOINT , mpi_checkpoint )

void mpi_init_universe(int *unicomm)
{
  AMPIAPI("mpi_init_universe");
  for(int i=0;i<mpi_nworlds; i++)
  {
    unicomm[i] = MPI_COMM_UNIVERSE[i];
  }
}

void mpi_init(int *ierr){
  *ierr = MPI_Init(NULL,NULL);
}

void mpi_initialized(int *isInit, int* ierr)
{
  *ierr = MPI_Initialized(isInit);
}

void mpi_comm_rank(int *comm, int *rank, int *ierr)
{
  *ierr = MPI_Comm_rank(*comm, rank);
}

void mpi_comm_size(int *comm, int *size, int *ierr)
{
  *ierr = MPI_Comm_size(*comm, size);
}

void mpi_finalize(int *ierr)
{
  *ierr = MPI_Finalize();
}

void mpi_send(void *msg, int *count, int *type, int *dest,
  int *tag, int *comm, int *ierr)
{
  *ierr = MPI_Send(msg, *count, *type, *dest, *tag, *comm);
}

void mpi_recv(void *msg, int *count, int *type, int *src,
  int *tag, int *comm, int *status, int *ierr)
{
  *ierr = MPI_Recv(msg, *count, *type, *src, *tag, *comm,
                    (MPI_Status*) status);
}

void mpi_probe(int *src, int *tag, int *comm, int *status, int *ierr)
{
  *ierr = MPI_Probe(*src, *tag, *comm, (MPI_Status*) status);
}

void mpi_iprobe(int *src,int *tag,int *comm,int *flag,int *status,int *ierr)
{
  *ierr = MPI_Iprobe(*src, *tag, *comm, flag, (MPI_Status*) status);
}

void mpi_sendrecv(void *sndbuf, int *sndcount, int *sndtype,
  int *dest, int *sndtag, void *rcvbuf,
  int *rcvcount, int *rcvtype, int *src,
  int *rcvtag, int *comm, int *status, int *ierr)
{
  *ierr = MPI_Sendrecv(sndbuf, *sndcount, *sndtype, *dest, *sndtag,
                        rcvbuf, *rcvcount, *rcvtype, *src, *rcvtag,
			*comm, (MPI_Status*) status);
}

void mpi_sendrecv_replace(void *buf, int* count, int* datatype,
                          int* dest, int* sendtag, int* source, int* recvtag,
                          int* comm, int* status, int *ierr)
{
  *ierr = MPI_Sendrecv_replace(buf, *count, *datatype, *dest, *sendtag,
                               *source, *recvtag, *comm, (MPI_Status*) status);
}

void mpi_barrier(int *comm, int *ierr)
{
  *ierr = MPI_Barrier(*comm);
}

void mpi_bcast(void *buf, int *count, int *type, int *root, int *comm, 
   int *ierr)
{
  *ierr = MPI_Bcast(buf, *count, *type, *root, *comm);
}

void mpi_reduce(void *inbuf, void *outbuf, int *count, int *type,
   int *op, int *root, int *comm, int *ierr)
{
  *ierr = MPI_Reduce(inbuf, outbuf, *count, *type, *op, *root, *comm);
}

void mpi_allreduce(void *inbuf,void *outbuf,int *count,int *type,
   int *op, int *comm, int *ierr)
{
  *ierr = MPI_Allreduce(inbuf, outbuf, *count, *type, *op, *comm);
}

double mpi_wtime(void)
{
  return MPI_Wtime();
}

double mpi_wtick(void)
{
  return MPI_Wtick();
}

void mpi_start(int *reqnum, int *ierr)
{
  *ierr = MPI_Start((MPI_Request*) reqnum);
}

void mpi_startall(int *count, int *reqnum, int *ierr)
{
  *ierr = MPI_Startall(*count, (MPI_Request*) reqnum);
}

void mpi_waitall(int *count, int *request, int *status, int *ierr)
{
  *ierr = MPI_Waitall(*count, (MPI_Request*) request, (MPI_Status*) status);
}

void mpi_waitany(int *count, int *request, int *index, int *status, int *ierr)
{
  *ierr = MPI_Waitany(*count, (MPI_Request*) request, index,
                       (MPI_Status*) status);
}

void mpi_wait(int *request, int *status, int *ierr)
{
  *ierr = MPI_Wait((MPI_Request*) request, (MPI_Status*) status);
}

void mpi_testall(int *count, int *request, int *flag, int *status, int *ierr)
{
  *ierr = MPI_Testall(*count, (MPI_Request*) request, flag,
      (MPI_Status*) status);
}

void mpi_waitsome(int *incount, int *array_of_requests, int *outcount, int *array_of_indices, int *array_of_statuses, int *ierr)
{
  *ierr = MPI_Waitsome(*incount, (MPI_Request *)array_of_requests, outcount, array_of_indices, (MPI_Status*) array_of_statuses);
}

void mpi_testsome(int *incount, int *array_of_requests, int *outcount, int *array_of_indices, int *array_of_statuses, int *ierr)
{
  *ierr = MPI_Testsome(*incount, (MPI_Request *)array_of_requests, outcount, array_of_indices, (MPI_Status*) array_of_statuses);
}

void mpi_testany(int *count, int *request, int *index, int *flag, int *status, int *ierr)
{
  *ierr = MPI_Testany(*count, (MPI_Request*) request, index, flag,
      (MPI_Status*) status);
}

void mpi_test(int *request, int *flag, int *status, int *ierr)
{
  *ierr = MPI_Test((MPI_Request*) request, flag, (MPI_Status*) status);
}

void mpi_request_free(int *request, int *ierr)
{
  *ierr = MPI_Request_free((MPI_Request *)request);
}

void mpi_cancel(int *request, int *ierr)
{
  *ierr = MPI_Cancel((MPI_Request *)request);
}

void mpi_recv_init(void *buf, int *count, int *type, int *srcpe,
   int *tag, int *comm, int *req, int *ierr)
{
  *ierr = MPI_Recv_init(buf,*count,*type,*srcpe,*tag,*comm,(MPI_Request*)req);
}

void mpi_send_init(void *buf, int *count, int *type, int *destpe,
   int *tag, int *comm, int *req, int *ierr)
{
  *ierr = MPI_Send_init(buf,*count,*type,*destpe,*tag,*comm,
                         (MPI_Request*)req);
}

void mpi_type_contiguous(int *count, int *oldtype, int *newtype, int *ierr)
{
  *ierr = MPI_Type_contiguous(*count, *oldtype, newtype);
}

void mpi_type_vector(int *count, int *blocklength, int *stride,
   int *oldtype, int*  newtype, int *ierr)
{
  *ierr = MPI_Type_vector(*count, *blocklength, *stride, *oldtype, newtype);
}

void mpi_type_hvector(int *count, int *blocklength, int *stride,
   int* oldtype, int* newtype, int* ierr)
{
  *ierr = MPI_Type_hvector(*count, *blocklength, *stride, *oldtype, newtype);
}

void mpi_type_indexed(int *count, int* arrBlength, int* arrDisp,
   int* oldtype, int*  newtype, int* ierr)
{
  *ierr = MPI_Type_indexed(*count, arrBlength, arrDisp, *oldtype, newtype);
}

void mpi_type_hindexed(int* count, int* arrBlength, int* arrDisp,
   int* oldtype, int* newtype, int* ierr)
{
  *ierr = MPI_Type_hindexed(*count, arrBlength, arrDisp, *oldtype, newtype);
}

void mpi_type_struct(int* count, int* arrBlength, int* arrDisp,
   int* oldtype, int* newtype, int* ierr)
{
  *ierr = MPI_Type_struct(*count, arrBlength, arrDisp, oldtype, newtype);
}


void mpi_type_commit(int *type, int *ierr)
{
  *ierr = MPI_Type_commit(type);
}

void mpi_type_free(int *type, int *ierr)
{
  *ierr = MPI_Type_free(type);
}

void  mpi_type_extent(int* type, int* extent, int* ierr)
{
  *ierr = MPI_Type_extent(*type, extent);
}

void  mpi_type_size(int* type, int* size, int* ierr)
{
  *ierr = MPI_Type_size(*type, size);
}

void mpi_type_lb(int* datatype, int* displacement, int* ierr)
{
  *ierr = MPI_Type_lb(*datatype, displacement);
}

void mpi_type_ub(int* datatype, int* displacement, int* ierr)
{
  *ierr = MPI_Type_ub(*datatype, displacement);
}

void mpi_address(int* location, int *address, int* ierr)
{
  *ierr = MPI_Address(location, address);
}

void mpi_get_elements(int *status, int* datatype, int *count, int* ierr)
{
  *ierr = MPI_Get_elements((MPI_Status*) status, *datatype, count);
}

void mpi_pack(void *inbuf, int *incount, int *datatype, void *outbuf,
    int *outsize, int *position, int *comm, int *ierr)
{
  *ierr = MPI_Pack(inbuf, *incount, (MPI_Datatype)*datatype, outbuf,
      *outsize, position, *comm);
}

void mpi_unpack(void *inbuf, int *insize, int *position, void *outbuf,
    int *outcount, int *datatype, int *comm, int *ierr)
{
  *ierr = MPI_Unpack(inbuf, *insize, position, outbuf, *outcount,
      (MPI_Datatype) *datatype, (MPI_Comm) *comm);
}

void mpi_pack_size(int *incount, int *datatype, int *comm, int *size, int *ierr)
{
  *ierr = MPI_Pack_size(*incount, (MPI_Datatype) *datatype, *comm, size);
}

void mpi_isend(void *buf, int *count, int *datatype, int *dest,
   int *tag, int *comm, int *request, int *ierr)
{
  *ierr = MPI_Isend(buf, *count, *datatype, *dest, *tag, *comm, (MPI_Request *)request);
}

void mpi_irecv(void *buf, int *count, int *datatype, int *src,
   int *tag, int *comm, int *request, int *ierr)
{
  *ierr = MPI_Irecv(buf, *count, *datatype, *src, *tag, *comm, (MPI_Request *)request);
}

void mpi_allgatherv(void *sendbuf, int *sendcount, int *sendtype,
   void *recvbuf, int *recvcounts, int *displs,
   int *recvtype, int *comm, int *ierr)
{
  *ierr = MPI_Allgatherv(sendbuf, *sendcount, *sendtype, recvbuf, recvcounts,
                          displs, *recvtype, *comm);
}

void mpi_allgather(void *sendbuf, int *sendcount, int *sendtype,
   void *recvbuf, int *recvcount, int *recvtype,
   int *comm, int *ierr)
{
  *ierr = MPI_Allgather(sendbuf, *sendcount, *sendtype, recvbuf, *recvcount,
                         *recvtype, *comm);
}

void mpi_gatherv(void *sendbuf, int *sendcount, int *sendtype,
   void *recvbuf, int *recvcounts, int *displs,
   int *recvtype, int *root, int *comm, int *ierr)
{
  *ierr = MPI_Gatherv(sendbuf, *sendcount, *sendtype, recvbuf, recvcounts,
                       displs, *recvtype, *root, *comm);
}

void mpi_gather(void *sendbuf, int *sendcount, int *sendtype,
   void *recvbuf, int *recvcount, int *recvtype,
   int *root, int *comm, int *ierr)
{
  *ierr = MPI_Gather(sendbuf, *sendcount, *sendtype, recvbuf, *recvcount,
                      *recvtype, *root, *comm);
}

void mpi_scatterv(void *sendbuf, int *sendcounts, int *displs, int *sendtype,
   void *recvbuf, int *recvcount, int *recvtype, int *root, int *comm, int *ierr)
{
  *ierr = MPI_Scatterv(sendbuf, sendcounts, displs, *sendtype, recvbuf, *recvcount,
                       *recvtype, *root, *comm);
}

void mpi_scatter(void *sendbuf, int *sendcount, int *sendtype,
   void *recvbuf, int *recvcount, int *recvtype,
   int *root, int *comm, int *ierr)
{
  *ierr = MPI_Scatter(sendbuf, *sendcount, *sendtype, recvbuf, *recvcount,
                      *recvtype, *root, *comm);
}

void mpi_alltoallv(void *sendbuf, int *sendcounts, int *sdispls,
   int *sendtype, void *recvbuf, int *recvcounts,
   int *rdispls, int *recvtype, int *comm, int *ierr)
{
  *ierr = MPI_Alltoallv(sendbuf, sendcounts, sdispls, *sendtype, recvbuf,
                         recvcounts, rdispls, *recvtype, *comm);
}

void mpi_alltoall(void *sendbuf, int *sendcount, int *sendtype,
   void *recvbuf, int *recvcount, int *recvtype,
   int *comm, int *ierr)
{
  *ierr = MPI_Alltoall(sendbuf, *sendcount, *sendtype, recvbuf, *recvcount,
                       *recvtype, *comm);
}

void mpi_iallgather(void *sendbuf, int* sendcount, int* sendtype,
                    void *recvbuf, int* recvcount, int* recvtype,
                    int* comm, int* request, int* ierr)
{
  *ierr = MPI_Iallgather(sendbuf, *sendcount, *sendtype, recvbuf, *recvcount,
                         *recvtype, *comm, (MPI_Request *)request);

}

void mpi_ialltoall(void *sendbuf, int* sendcount, int* sendtype,
                 void *recvbuf, int* recvcount, int* recvtype,
                 int* comm, int *request, int* ierr)
{
  *ierr = MPI_Ialltoall(sendbuf, *sendcount, *sendtype,
                        recvbuf, *recvcount, *recvtype,
                        *comm, (MPI_Request *)request);
}

void mpi_ireduce(void *sendbuf, void *recvbuf, int* count, int* type,
                int* op, int* root, int* comm, int *request, int* ierr)
{
  *ierr = MPI_Ireduce(sendbuf, recvbuf, *count, *type,
                      *op, *root, *comm, (MPI_Request*) request);
}

void mpi_iallreduce(void *inbuf, void *outbuf, int* count, int* type,
                   int* op, int* comm, int *request, int* ierr)
{
  *ierr = MPI_Iallreduce(inbuf, outbuf, *count, *type,
                         *op, *comm, (MPI_Request*) request);
}
void mpi_reduce_scatter(void *sendbuf, void *recvbuf, int *recvcounts,
                       int* datatype, int* op, int* comm, int* ierr)
{
  *ierr = MPI_Reduce_scatter(sendbuf, recvbuf, recvcounts,
                             *datatype, *op, *comm);
}

void mpi_scan(void* sendbuf, void* recvbuf, int* count, int* datatype, int* op, int* comm, int* ierr)
{
  *ierr = MPI_Scan(sendbuf,recvbuf,*count,*datatype,*op,*comm );
}

void mpi_comm_dup(int *comm, int *newcomm, int *ierr)
{
  *newcomm = *comm;
  *ierr = 0;
}

void mpi_comm_split(int* src, int* color, int* key, int *dest, int *ierr)
{
  *ierr = MPI_Comm_split(*src, *color, *key, dest);
}

void mpi_comm_free(int *comm, int *ierr)
{
  *ierr = 0;
}

void mpi_comm_test_inter(int* comm, int* flag, int* ierr)
{
  *ierr = MPI_Comm_test_inter(*comm, flag);
}

void mpi_cart_create(int* comm_old, int* ndims, int *dims, int *periods,
		    int* reorder, int* comm_cart, int* ierr)
{
  *ierr = MPI_Cart_create(*comm_old, *ndims, dims, periods, *reorder, comm_cart);
}

void mpi_graph_create(int* comm_old, int* nnodes, int *index, int *edges,
		     int* reorder, int* comm_graph, int* ierr)
{
  *ierr = MPI_Graph_create(*comm_old, *nnodes, index, edges, *reorder, comm_graph);
}

void mpi_topo_test(int* comm, int *status, int* ierr)
{
  *ierr = MPI_Topo_test(*comm, status);
}

void mpi_cart_map(int* comm, int* ndims, int *dims, int *periods,
                 int *newrank, int* ierr)
{
  *ierr = MPI_Cart_map(*comm, *ndims, dims, periods, newrank);
}

void mpi_graph_map(int* comm, int* nnodes, int *index, int *edges,
		  int *newrank, int* ierr)
{
  *ierr = MPI_Graph_map(*comm, *nnodes, index, edges, newrank);
}

void mpi_cartdim_get(int* comm, int *ndims, int* ierr)
{
  *ierr = MPI_Cartdim_get(*comm, ndims);
}

void mpi_cart_get(int* comm, int* maxdims, int *dims, int *periods,
		 int *coords, int* ierr)
{
  *ierr = MPI_Cart_get(*comm, *maxdims, dims, periods, coords);
}

void mpi_cart_rank(int* comm, int *coords, int *rank, int* ierr)
{
  *ierr = MPI_Cart_rank(*comm, coords, rank);
}

void mpi_cart_coords(int* comm, int* rank, int* maxdims, int *coords, int* ierr)
{
  *ierr = MPI_Cart_coords(*comm, *rank, *maxdims, coords);
}

void mpi_cart_shift(int* comm, int* direction, int* disp, int *rank_source,
		   int *rank_dest, int* ierr)
{
  *ierr = MPI_Cart_shift(*comm, *direction, *disp, rank_source, rank_dest);
}

void mpi_graphdims_get(int* comm, int *nnodes, int *nedges, int* ierr)
{
  *ierr = MPI_Graphdims_get(*comm, nnodes, nedges);
}

void mpi_graph_get(int* comm, int *maxindex, int *maxedges, int *index,
		  int *edges, int* ierr)
{
  *ierr = MPI_Graph_get(*comm, *maxindex, *maxedges, index, edges);
}

void mpi_graph_neighbors_count(int* comm, int *rank, int *nneighbors, int* ierr)
{
  *ierr = MPI_Graph_neighbors_count(*comm, *rank, nneighbors);
}

void mpi_graph_neighbors(int* comm, int *rank, int *maxneighbors,
			int *neighbors, int* ierr)
{
  *ierr = MPI_Graph_neighbors(*comm, *rank, *maxneighbors, neighbors);
}

void mpi_dims_create(int *nnodes, int *ndims, int *dims, int* ierr)
{
  *ierr = MPI_Dims_create(*nnodes, *ndims, dims);
}

void mpi_cart_sub(int* comm, int *remain_dims, int* newcomm, int* ierr)
{
  *ierr = MPI_Cart_sub(*comm, remain_dims, newcomm);
}

void mpi_get_processor_name(char* name, int *resultlen, int *ierr)
{
  *ierr = MPI_Get_processor_name(name, resultlen);
}

void mpi_errhandler_create(int *function, int *errhandler, int *ierr){  *ierr = 0;  }
void mpi_errhandler_set(int* comm, int* errhandler, int *ierr){  *ierr = 0;  }
void mpi_errhandler_get(int* comm, int *errhandler, int *ierr){  *ierr = 0;  }
void mpi_errhandler_free(int *errhandler, int *ierr){  *ierr = 0;  }
void mpi_error_string(int* errorcode, char *string, int *resultlen, int *ierr)
{
  *ierr = MPI_Error_string(*errorcode, string, resultlen);
}
void mpi_error_class(int* errorcode, int *errorclass, int *ierr)
{
  *ierr = MPI_Error_class(*errorcode, errorclass);
}

void mpi_group_size(int* group, int* size, int* ierror){
  *ierror = MPI_Group_size(*group, size);
}
void mpi_group_rank(int* group, int* rank, int* ierror){
  *ierror = MPI_Group_rank(*group, rank);
}
void mpi_group_translate_ranks(int* group1, int* n, int* ranks1, int* group2, int* ranks2, int* ierror){
  *ierror = MPI_Group_translate_ranks(*group1, *n, ranks1, *group2, ranks2);
}
void mpi_group_compare(int* group1, int* group2, int* result, int* ierror){
  *ierror = MPI_Group_compare(*group1, *group2, result);
}
void mpi_comm_group(int* comm, int* group, int* ierror){
  *ierror = MPI_Comm_group(*comm, group);
}
void mpi_group_union(int* group1, int* group2, int* newgroup, int* ierror){
  *ierror = MPI_Group_union(*group1, *group2, newgroup);
}
void mpi_group_intersection(int* group1, int* group2, int* newgroup, int* ierror){
  *ierror = MPI_Group_intersection(*group1, *group2, newgroup);
}
void mpi_group_difference(int* group1, int* group2, int* newgroup, int* ierror){
  *ierror = MPI_Group_difference(*group1, *group2, newgroup);
}
void mpi_group_incl(int* group, int* n, int* ranks, int* newgroup, int* ierror){
  *ierror = MPI_Group_incl(*group, *n, ranks, newgroup);
}
void mpi_group_excl(int* group, int* n, int* ranks, int* newgroup, int* ierror){
  *ierror = MPI_Group_excl(*group, *n, ranks, newgroup);
}
void mpi_group_range_incl(int* group, int* n, int ranges[][3], int* newgroup, int* ierror){
  *ierror = MPI_Group_range_incl(*group, *n, ranges, newgroup);
}
void mpi_group_range_excl(int* group,int*  n, int ranges[][3], int* newgroup, int* ierror){
  *ierror = MPI_Group_range_excl(*group, *n, ranges, newgroup);
}
void mpi_group_free(int*  group, int*  ierror){
  *ierror = 0;
}
void mpi_comm_create(int*  comm, int*  group, int*  newcomm, int*  ierror){
  *ierror = MPI_Comm_create(*comm, *group, newcomm);
}

void mpi_abort(int *comm, int *errorcode, int *ierr)
{
  *ierr = MPI_Abort(*comm, *errorcode);
}

void mpi_get_count(int *sts, int *dtype, int *cnt, int *ierr)
{
  *ierr = MPI_Get_count((MPI_Status*) sts, *dtype, cnt);
}

void mpi_print(char *str, int len)
{
  char *tmpstr = new char[len+1];
  memcpy(tmpstr,str,len);
  tmpstr[len] = '\0';
  MPI_Print(tmpstr);
  delete[] tmpstr;
}

void mpi_migrate(void)
{
  MPI_Migrate();
}

int mpi_register(void *d, MPI_PupFn f)
{
  return MPI_Register(d,f);
}

void mpi_checkpoint(char *dname){
  MPI_Checkpoint(dname);
}

} // extern "C"

