package projector.gui;
import projector.core.*;
import projector.language.*;
//import projections.misc.ProgressDialog;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.text.*;




public class HistogramWindow extends GenericGraphWindow
   implements ActionListener,ItemListener
{
   int NO_OF_BINS;
   int FREQUENCY;

// variables (in addition to those in the super class) to be set by RangeDialog
   private long [] totalExecutionTime;	// sum total of the execution times of all the entry points selected
   private long [] longestExecutionTime;	// longest EntryPoint execution time

//variables to be passed to EntrySelectionDialog
   private EntrySelectionDialog entryDialog;
   private boolean stateArray[][];
   private Color colorArray[][];
   private String [] entryNames;

// progress bar
//   private ProgressDialog progressBar;

   private JTextArea statusArea;		// displays the number of EPs in each bin as an ordered pair
   private boolean recordEP;			// should longest entrypoints be recorded & displayed as a table?
   private EntryPointWindow epFrame;

   private boolean startUp;			// show both range dialog & epdialog during startup

   private int langCount;			//which Language to show
   private int [][] allCounts;			// stores counts for all languages
   private int maxLang;
   private String [] languageNames;

// later replace this with HistogramWindow()
   public HistogramWindow(MainWindow mainWindow)
   {
	  super("Projections Histograms");
//	  super();
	  setTitle("Projections Histograms");
	  FREQUENCY = 100;
	  NO_OF_BINS=25;
	  setGraphSpecificData();

	  int noEPs = Analysis.getUserEntryCount();
	  stateArray = new boolean[1][noEPs];	// where should this be?
	  for(int i=0; i < noEPs; i++)
		stateArray[0][i] = true;

          String names[][] = Analysis.getUserEntryNames();
	  entryNames = new String[noEPs];
       	  for(int i=0; i<noEPs ; i++)
		entryNames[i] = names[i][0];

          colorArray = new Color[1][noEPs];
          for(int i=0; i < noEPs; i++)
                colorArray[0][i] = Analysis.getEntryColor(i);

	  recordEP = false;	// don't record longest EPs by default
	  epFrame = null;
	  statusArea = new JTextArea(6,2);	// to display the no. of EPs vs bins as text
//   	  progressBar = new ProgressDialog("Counting EntryPoints...");
	  startUp = true;
	  langCount = 1;


	  createMenus();
	  getContentPane().add(getMainPanel());

	  pack();
	//  setVisible(true);
	  showDialog();
	  
	  setVisible(true);
   }

/* if there is an epFrame existing, dispose it before disposing the window */
   public void close(){
	if(epFrame != null)
		epFrame.dispose();
	super.close();
   }

/* Show the RangeDialog to set processor numbers and interval times */
   void showDialog()
   {
	if(dialog == null)
		 dialog = new HistogramRangeDialog(this,"Select Range");
	int dialogstatus = dialog.showDialog();
//	dialog.displayDialog();
//	if(!isDialogCancelled)
	if(dialogstatus == RangeDialog.DIALOG_OK)
	{
		//setAllData();	// get the values input from the dialog
		dialog.setAllData();
		setGraphSpecificData();
		if(!startUp)
			refreshGraph();
		else
			showEntryDialog();

	}
   }

/* Show the EntrySelectionDialog to select Entrypoints to be considered */
   void showEntryDialog()
   {
	if(startUp) startUp = false;

	int noEPs = Analysis.getUserEntryCount();
	String typeLabelStrings[] = {"Entry Points"};

	boolean existsArray[][] = new boolean[1][noEPs];
	for(int i=0; i<noEPs; i++)
		existsArray[0][i] = true;

		// temporarily disbaling entry method selction as it is only supported by charm if ampi supports it we will do something
	/*if(entryDialog == null)
		 entryDialog = new EntrySelectionDialog(this, typeLabelStrings,stateArray,colorArray,existsArray,entryNames);
	entryDialog.showDialog();*/
	refreshGraph();
   }

   public void actionPerformed(ActionEvent evt)
   {
	  if(evt.getSource() instanceof JMenuItem)
	  {
		 JMenuItem m = (JMenuItem)evt.getSource();
		 if(m.getText().equals("Set Range"))
		        showDialog();
		 else if(m.getText().equals("Select Entry Points"))
			showEntryDialog();
		 else if(m.getText().equals("Close"))
			close();
		 else if(m.getText().equals("Next Language")){
		 		langCount++;
				if(langCount >= maxLang){
					langCount = 1;
				}
				System.out.println("Language " + langCount);
				refreshLanguageGraph(langCount);
			}
	  }
   }

   public void itemStateChanged(ItemEvent evt)
   {
	recordEP = (evt.getStateChange()==1)?true:false;	// if the itemStateChanged is to 1, then it is selected
	if(recordEP)
		refreshGraph();
	else
		epFrame.setVisible(false);
   }

  protected JPanel getMainPanel()
  {
	  JPanel mainPanel = super.getMainPanel();
          mainPanel.add(Box.createRigidArea(new Dimension(0,6)));
	  mainPanel.add(new JScrollPane(statusArea,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED));
	  return mainPanel;
  }

   protected void setGraphSpecificData(){
	  setXAxis("Entry Point Execution Time (us)","us",0,FREQUENCY);
	  setYAxis("Instances","");
   }

   protected void refreshGraph()
   {
// get new counts and redraw the graph
	  allCounts = getCounts();
	  refreshLanguageGraph(langCount);
   }
   protected void refreshLanguageGraph(int language){
   	  int [] counts = allCounts[language];
	  setDataSource("",counts);
	  super.refreshGraph();

	  String firstRow  ="Bin  ", secondRow="EPs  ";
	  String  thirdRow = "Total Execution Time: " + String.valueOf(totalExecutionTime[language])+ " us";
	  String fourthRow = "Longest Entry Point Execution Time: " + longestExecutionTime[language] +" us";
	  String fifthRow = "Language is " + languageNames[language];

	  for(int i=0; i<counts.length; i++)
		if(counts[i]!=0)
		{
			firstRow = firstRow + i + "\t";
			secondRow = secondRow + counts[i] +"\t";
		}

	   // clear the text area and enter new set
	   statusArea.setText("");
	   statusArea.append(firstRow+"\n");
	   statusArea.append(secondRow+"\n\n");
	   statusArea.append(fifthRow+"\n");
	   statusArea.append(thirdRow+"\n");
	   statusArea.append(fourthRow+"\n");

	// print to the screen
   }

   private int[][] getCounts()
   {
	  int instances = 0;


	  OrderedIntList tmpPEs = validPEs.copyOf();
	  
	  TraceReader tReader;
	  // Object of any language .
	  GeneralEventObject geObj1,geObj2;
	  //Array for Interpreters;
	  Interpreter [] interpreters;
	  //Interval Generator to generate Intervals
	  IntervalGenerator igen;
	


	  boolean teof;

	  if(recordEP)
	  {
		if(epFrame == null){
			epFrame = new EntryPointWindow();
	  		epFrame.setSize(600,600);
		}
		else
			epFrame.clearTableData();	// prepare table to enter new data in place of old
	  }
	


	tReader = null;
	
	try{
	  tReader = new TraceReader(Analysis.getFilename(),"");
	  }catch(Exception e){
		System.out.println("Problem with Trace Reader " + e);
		System.exit(0);
	  }

	  maxLang = tReader.getMaxLangs();
	  languageNames = tReader.getLanguageNames();
	  int [][] counts = new int[maxLang+1][NO_OF_BINS];
	  totalExecutionTime = new long[maxLang];
	  longestExecutionTime = new long[maxLang];
	  //initialize the buckets
	  for(int j=1;j<maxLang;j++){
	  	for(int i=0; i<NO_OF_BINS; i++)
			counts[j][i] = 0;
		totalExecutionTime[j] = 0;
		longestExecutionTime[j] = 0;

	  }  
	  tmpPEs.reset();
	  Vector [] intervalVect;
	  int diff;
	  while(tmpPEs.hasMoreElements()){
	  	int pe = tmpPEs.nextElement();
		igen = new IntervalGenerator(Analysis.getFilename(),pe);
		intervalVect  = igen.getIntervals((double )startTime/1000000.0,(double )endTime/1000000.0);
		System.out.println("Size of intervalVect " + intervalVect.length+" maxLang = "+maxLang );
		for(int i=1;i<maxLang;i++){
			int numIntervals= intervalVect[i].size();
			System.out.println("Size of intervalVect["+i+"] = " + numIntervals);
			Interval intervalElement;
			long executionTime;
			for(int j = 0;j < numIntervals;j++){
				
				intervalElement = (Interval )intervalVect[i].elementAt(j);
				
				executionTime = (long )(intervalElement.executionTime*1000000.0);

				totalExecutionTime[i] += executionTime;
				if(longestExecutionTime[i] < executionTime){
					longestExecutionTime[i] = executionTime;
				}
				
				diff = (int )(executionTime / FREQUENCY);
				
				if(diff >= NO_OF_BINS){
					diff = NO_OF_BINS-1;
				}
				counts[i][diff]++;
				instances++;
				
			}
		}
		System.out.println("done for Proc "+pe);
	  }
	  System.out.println("instances " +  instances);	  
	  
	  if(recordEP)	epFrame.setVisible(true);
	  return(counts);
}
	  


// override the super class' createMenus(), add any menu items in fileMenu if needed, add any new menus to the menuBar
// then call super class' createMenus() to add the menuBar to the Window
   protected void createMenus()
   {
	  fileMenu = Util.makeJMenu(fileMenu,new Object[]
	  {
		"Select Entry Points","Next Language"
	  },new boolean[] {false,false},this);

          menuBar.add(Util.makeJMenu("View", new Object[]
          {
                 new JCheckBoxMenuItem("Show Longest EPs",true)
          },new boolean [] { false},
          this));

	  super.createMenus();
    }
    
    public void setGrainSize(int val){
    	FREQUENCY = val;	
    }
    public void setBoxNumber(int val){
    	NO_OF_BINS=val;
    }
}
class HistogramRangeDialog extends RangeDialog {
	private JPanel histPanel;
	private JLabel grainLabel,boxLabel;
	private HistogramWindow parentWindow;
	JTextField grainText,boxText;
	public HistogramRangeDialog(HistogramWindow parentWindow,String titleString){
		super(parentWindow,titleString);
		this.parentWindow = parentWindow;
	}
	public void displayDialog() {
		if(layoutComplete){
			setVisible(true);
		}
		addWindowListener(new WindowAdapter()
	    	{
			public void windowClosing(WindowEvent e)
			{
			    dialogState = DIALOG_CANCELLED;
			    setVisible(false);
			}
		 });
		 mainPanel = createMainLayout();
		 buttonPanel = createButtonLayout();
		 histPanel = createHistogramPanel();
	 	 this.getContentPane().setLayout(new BorderLayout());
	   	 this.getContentPane().add(mainPanel, BorderLayout.NORTH);
	  	 this.getContentPane().add(buttonPanel, BorderLayout.CENTER);
		 this.getContentPane().add(histPanel,BorderLayout.SOUTH);
		 layoutComplete = true;
		 pack();
		 setResizable(false);
		 setVisible(true);
	}
	public JPanel createHistogramPanel(){
		JPanel  tempPanel = new JPanel();
		grainLabel = new JLabel("Grain Size:",JLabel.LEFT);
		boxLabel = new JLabel("Number of boxes: ",JLabel.LEFT);
		grainText = new JTextField("100",6);
		boxText = new JTextField("25",6);
		tempPanel.add(grainLabel);
		tempPanel.add(grainText);
		tempPanel.add(boxLabel);
		tempPanel.add(boxText);
		return tempPanel;
	}
	
	void setAllData(){
		String grainString = grainText.getText();
		String boxString = boxText.getText();
		int grainVal=0;
		int boxVal=0;
		try{
		grainVal = Integer.parseInt(grainString);
		boxVal = Integer.parseInt(boxString);
		}catch(Exception e){
			return;
		}
		parentWindow.setGrainSize(grainVal);
		parentWindow.setBoxNumber(boxVal);
		super.setAllData();
	}
}
