/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.rundoc;

import com.martiansoftware.rundoc.MacroException;
import com.martiansoftware.rundoc.MacroProcessor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class MacroInputStream
extends FilterInputStream {
    public static final int DEFAULT_MAXMACROLENGTH = 1024;
    public static final String DEFAULT_MACROSTART = "${";
    public static final String DEFAULT_MACROEND = "}";
    private String macroStart = "${";
    private int macroStartLength = "${".length();
    private String macroEnd = "}";
    private int macroEndLength = "}".length();
    private int maxMacroLength = 1024;
    private int bufSize = 1024 + this.macroStartLength + this.macroEndLength;
    private int maxBufSize = Short.MAX_VALUE;
    private int maxLeftRecursionDepth = 32;
    private MacroProcessor processor = null;
    private StringBuffer buf = null;
    private boolean eof = false;

    public MacroInputStream(InputStream in, MacroProcessor processor) {
        super(in);
        this.init(processor, 1024);
    }

    public MacroInputStream(InputStream in, MacroProcessor processor, int maxMacroLength) {
        super(in);
        this.init(processor, maxMacroLength);
    }

    private void init(MacroProcessor processor, int maxMacroLength) {
        this.processor = processor;
        this.setMaxMacroLength(maxMacroLength);
        this.buf = new StringBuffer();
        this.eof = false;
    }

    private void recomputeBufSize() {
        this.bufSize = this.maxMacroLength + this.macroStartLength + this.macroEndLength;
    }

    public void setMaxMacroLength(int maxMacroLength) {
        this.maxMacroLength = maxMacroLength;
        this.recomputeBufSize();
    }

    public int getMaxMacroLength() {
        return this.maxMacroLength;
    }

    public void setMacroStart(String macroStart) {
        if (macroStart == null || macroStart.length() == 0) {
            throw new IllegalArgumentException("macroStart may not be empty.");
        }
        this.macroStart = macroStart;
        this.macroStartLength = macroStart.length();
        this.recomputeBufSize();
    }

    public void setMacroEnd(String macroEnd) {
        if (macroEnd == null || macroEnd.length() == 0) {
            throw new IllegalArgumentException("macroEnd may not be empty.");
        }
        this.macroEnd = macroEnd;
        this.macroEndLength = macroEnd.length();
        this.recomputeBufSize();
    }

    public String getMacroStart() {
        return this.macroStart;
    }

    public String getMacroEnd() {
        return this.macroEnd;
    }

    public void setMacroDelimiters(String macroStart, String macroEnd) {
        this.setMacroStart(macroStart);
        this.setMacroEnd(macroEnd);
    }

    private void fillBuffer(boolean force) throws IOException {
        if (!this.eof && (force || this.buf.length() <= this.macroStartLength)) {
            int charsToRead = this.bufSize - this.buf.length();
            int charsRead = 0;
            int thisChar = 0;
            while (!this.eof && charsRead < charsToRead) {
                thisChar = this.in.read();
                if (thisChar == -1) {
                    this.eof = true;
                    continue;
                }
                this.buf.append((char)thisChar);
                ++charsRead;
            }
        }
    }

    public int read() throws IOException {
        this.fillBuffer(false);
        if (this.buf.length() == 0) {
            return -1;
        }
        if (this.buf.length() > this.macroStartLength) {
            int curLeftRecursionDepth = 0;
            boolean done = false;
            while (this.buf.substring(0, this.macroStartLength).equals(this.macroStart) && !done) {
                if (++curLeftRecursionDepth >= this.maxLeftRecursionDepth) {
                    throw new MacroException("Maximum left recursion depth of " + this.maxLeftRecursionDepth + " has been reached.  You probably have circular" + " macro definitions.");
                }
                this.fillBuffer(true);
                int endPos = this.buf.toString().indexOf(this.macroEnd, this.macroStartLength);
                if (endPos <= -1) continue;
                String macro = this.buf.substring(this.macroStartLength, endPos);
                if (this.processor == null) continue;
                String macroResult = this.processor.processMacro(macro);
                if (macroResult == null) {
                    done = true;
                    continue;
                }
                this.buf.delete(0, endPos + this.macroEndLength);
                this.buf.insert(0, macroResult);
                if (this.buf.length() < this.maxBufSize) continue;
                throw new MacroException("Maximum buffer size of " + this.maxBufSize + " has been reached.  You probably have" + " circular macro definitions.");
            }
        }
        char result = this.buf.charAt(0);
        this.buf.delete(0, 1);
        return result;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int result = 0;
        if (!this.eof) {
            int curIndex = offset;
            while (curIndex + result < length) {
                int c = this.read();
                if (c == -1) break;
                b[curIndex] = (byte)c;
                ++result;
                ++curIndex;
            }
        }
        if (result == 0 && length != 0) {
            result = -1;
        }
        return result;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public int getMaxLeftRecursionDepth() {
        return this.maxLeftRecursionDepth;
    }

    public void setMaxBufSize(int maxBufSize) {
        this.maxBufSize = maxBufSize;
    }

    public void setMaxLeftRecursionDepth(int maxLeftRecursionDepth) {
        this.maxLeftRecursionDepth = maxLeftRecursionDepth;
    }
}

