/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.rundoc;

import com.martiansoftware.rundoc.MacroInputStream;
import com.martiansoftware.rundoc.MacroProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;

public class RunDoc
extends Task
implements MacroProcessor {
    public static final String FORMAT_DOCBOOK = "docbook";
    private static final String RUNSNIP_START = "@@rundoc:";
    private static final String RUNSNIP_END = "@@";
    private static final int BUFSIZE = 2048;
    private String prompt = null;
    private String format = "docbook";
    private ArrayList filesets = new ArrayList();
    StringBuffer buf = new StringBuffer();
    private Environment env = new Environment();

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    private String xmlSafe(String s) {
        return s.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public void addEnv(Environment.Variable envvar) {
        this.env.addVariable(envvar);
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String formatDocbook(String command, String output) {
        StringBuffer result = new StringBuffer();
        result.append("<prompt>");
        result.append(this.xmlSafe(this.prompt));
        result.append("</prompt><command>");
        result.append(this.xmlSafe(command));
        result.append("</command>\n<computeroutput>");
        result.append(this.xmlSafe(output));
        result.append("</computeroutput>");
        return result.toString();
    }

    public String formatResult(String command, String output) {
        if (this.format.equalsIgnoreCase(FORMAT_DOCBOOK)) {
            return this.formatDocbook(command, output);
        }
        throw new BuildException("Unsupported format: " + this.format);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String processMacro(String macro) {
        System.out.println("Executing [" + macro + "]...");
        StringWriter result = new StringWriter();
        try {
            Process p = Runtime.getRuntime().exec(macro, this.env.getVariables());
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader errIn = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            char[] buf = new char[2048];
            int charsRead = 0;
            int errCharsRead = 0;
            while (charsRead >= 0 || errCharsRead >= 0) {
                charsRead = in.read(buf);
                if (charsRead >= 0) {
                    result.write(buf, 0, charsRead);
                }
                if ((errCharsRead = errIn.read(buf)) < 0) continue;
                result.write(buf, 0, errCharsRead);
            }
            p.waitFor();
            ((Reader)in).close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException("Error running [" + macro + "]", t);
        }
        return this.formatResult(macro, result.toString());
    }

    private void runSnipFile(File file) throws BuildException {
        if (this.prompt == null) {
            throw new BuildException("No prompt set.");
        }
        try {
            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
            MacroInputStream min = new MacroInputStream(fin, this);
            min.setMacroDelimiters(RUNSNIP_START, RUNSNIP_END);
            InputStreamReader in = new InputStreamReader(min);
            StringWriter result = new StringWriter();
            char[] buf = new char[2048];
            int charsRead = 0;
            while ((charsRead = in.read(buf)) >= 0) {
                result.write(buf, 0, charsRead);
            }
            ((Reader)in).close();
            result.close();
            OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(file)));
            out.write(result.toString());
            ((Writer)out).close();
        }
        catch (Throwable t) {
            throw new BuildException("Unable to read " + file.getAbsolutePath() + ": " + t.getMessage(), t);
        }
    }

    public void execute() throws BuildException {
        Iterator i = this.filesets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            File dir = fs.getDir(this.getProject());
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            int idx = 0;
            while (idx < srcFiles.length) {
                this.runSnipFile(new File(dir, srcFiles[idx]));
                ++idx;
            }
        }
    }
}

